/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.stream;

import ai.timefold.solver.core.api.domain.common.DomainAccessType;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.ConstraintJustification;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import ai.timefold.solver.core.impl.domain.lookup.ClassAndPlanningIdComparator;
import java.util.Comparator;
import java.util.List;

public final class DefaultConstraintJustification
implements ConstraintJustification,
Comparable<DefaultConstraintJustification> {
    private final Score<?> impact;
    private final List<Object> facts;
    private Comparator<Object> classAndIdPlanningComparator;

    public static DefaultConstraintJustification of(Score<?> impact, Object fact) {
        return new DefaultConstraintJustification(impact, List.of(fact));
    }

    public static DefaultConstraintJustification of(Score<?> impact, Object factA, Object factB) {
        return new DefaultConstraintJustification(impact, List.of(factA, factB));
    }

    public static DefaultConstraintJustification of(Score<?> impact, Object factA, Object factB, Object factC) {
        return new DefaultConstraintJustification(impact, List.of(factA, factB, factC));
    }

    public static DefaultConstraintJustification of(Score<?> impact, Object factA, Object factB, Object factC, Object factD) {
        return new DefaultConstraintJustification(impact, List.of(factA, factB, factC, factD));
    }

    public static DefaultConstraintJustification of(Score<?> impact, Object ... facts) {
        return new DefaultConstraintJustification(impact, List.of(facts));
    }

    public static DefaultConstraintJustification of(Score<?> impact, List<Object> facts) {
        return new DefaultConstraintJustification(impact, facts);
    }

    private DefaultConstraintJustification(Score<?> impact, List<Object> facts) {
        this.impact = impact;
        this.facts = facts;
    }

    public <Score_ extends Score<Score_>> Score_ getImpact() {
        return (Score_)this.impact;
    }

    public List<Object> getFacts() {
        return this.facts;
    }

    public String toString() {
        return this.facts.toString();
    }

    @Override
    public int compareTo(DefaultConstraintJustification other) {
        List<Object> otherJustificationList;
        String otherImpactClassName;
        String impactClassName = this.impact.getClass().getCanonicalName();
        int scoreClassComparison = impactClassName.compareTo(otherImpactClassName = other.impact.getClass().getCanonicalName());
        if (scoreClassComparison != 0) {
            return scoreClassComparison;
        }
        int scoreComparison = this.impact.compareTo(other.impact);
        if (scoreComparison != 0) {
            return scoreComparison;
        }
        List<Object> justificationList = this.getFacts();
        if (justificationList != (otherJustificationList = other.getFacts())) {
            if (justificationList.size() != otherJustificationList.size()) {
                return Integer.compare(justificationList.size(), otherJustificationList.size());
            }
            Comparator<Object> comparator = this.getClassAndIdPlanningComparator(other);
            for (int i = 0; i < justificationList.size(); ++i) {
                Object right;
                Object left = justificationList.get(i);
                int comparison = comparator.compare(left, right = otherJustificationList.get(i));
                if (comparison == 0) continue;
                return comparison;
            }
        }
        return Integer.compare(System.identityHashCode(this), System.identityHashCode(other));
    }

    private Comparator<Object> getClassAndIdPlanningComparator(DefaultConstraintJustification other) {
        if (this.classAndIdPlanningComparator != null) {
            return this.classAndIdPlanningComparator;
        }
        if (other.classAndIdPlanningComparator != null) {
            return other.classAndIdPlanningComparator;
        }
        this.classAndIdPlanningComparator = new ClassAndPlanningIdComparator(new MemberAccessorFactory(), DomainAccessType.REFLECTION, false);
        other.classAndIdPlanningComparator = this.classAndIdPlanningComparator;
        return this.classAndIdPlanningComparator;
    }
}

