/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.buildin.hardmediumsoft;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.ScoreUtil;
import java.util.Objects;

public final class HardMediumSoftScore
implements Score<HardMediumSoftScore> {
    public static final HardMediumSoftScore ZERO = new HardMediumSoftScore(0, 0, 0, 0);
    public static final HardMediumSoftScore ONE_HARD = new HardMediumSoftScore(0, 1, 0, 0);
    public static final HardMediumSoftScore ONE_MEDIUM = new HardMediumSoftScore(0, 0, 1, 0);
    public static final HardMediumSoftScore ONE_SOFT = new HardMediumSoftScore(0, 0, 0, 1);
    private final int initScore;
    private final int hardScore;
    private final int mediumScore;
    private final int softScore;

    public static HardMediumSoftScore parseScore(String scoreString) {
        String[] scoreTokens = ScoreUtil.parseScoreTokens(HardMediumSoftScore.class, scoreString, "hard", "medium", "soft");
        int initScore = ScoreUtil.parseInitScore(HardMediumSoftScore.class, scoreString, scoreTokens[0]);
        int hardScore = ScoreUtil.parseLevelAsInt(HardMediumSoftScore.class, scoreString, scoreTokens[1]);
        int mediumScore = ScoreUtil.parseLevelAsInt(HardMediumSoftScore.class, scoreString, scoreTokens[2]);
        int softScore = ScoreUtil.parseLevelAsInt(HardMediumSoftScore.class, scoreString, scoreTokens[3]);
        return HardMediumSoftScore.ofUninitialized(initScore, hardScore, mediumScore, softScore);
    }

    public static HardMediumSoftScore ofUninitialized(int initScore, int hardScore, int mediumScore, int softScore) {
        return new HardMediumSoftScore(initScore, hardScore, mediumScore, softScore);
    }

    public static HardMediumSoftScore of(int hardScore, int mediumScore, int softScore) {
        return new HardMediumSoftScore(0, hardScore, mediumScore, softScore);
    }

    public static HardMediumSoftScore ofHard(int hardScore) {
        return HardMediumSoftScore.of(hardScore, 0, 0);
    }

    public static HardMediumSoftScore ofMedium(int mediumScore) {
        return HardMediumSoftScore.of(0, mediumScore, 0);
    }

    public static HardMediumSoftScore ofSoft(int softScore) {
        return HardMediumSoftScore.of(0, 0, softScore);
    }

    private HardMediumSoftScore() {
        this(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    private HardMediumSoftScore(int initScore, int hardScore, int mediumScore, int softScore) {
        this.initScore = initScore;
        this.hardScore = hardScore;
        this.mediumScore = mediumScore;
        this.softScore = softScore;
    }

    @Override
    public int initScore() {
        return this.initScore;
    }

    public int hardScore() {
        return this.hardScore;
    }

    @Deprecated(forRemoval=true)
    public int getHardScore() {
        return this.hardScore;
    }

    public int mediumScore() {
        return this.mediumScore;
    }

    @Deprecated(forRemoval=true)
    public int getMediumScore() {
        return this.mediumScore;
    }

    public int softScore() {
        return this.softScore;
    }

    @Deprecated(forRemoval=true)
    public int getSoftScore() {
        return this.softScore;
    }

    @Override
    public HardMediumSoftScore withInitScore(int newInitScore) {
        return new HardMediumSoftScore(newInitScore, this.hardScore, this.mediumScore, this.softScore);
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0 && this.hardScore >= 0;
    }

    @Override
    public HardMediumSoftScore add(HardMediumSoftScore addend) {
        return new HardMediumSoftScore(this.initScore + addend.initScore(), this.hardScore + addend.hardScore(), this.mediumScore + addend.mediumScore(), this.softScore + addend.softScore());
    }

    @Override
    public HardMediumSoftScore subtract(HardMediumSoftScore subtrahend) {
        return new HardMediumSoftScore(this.initScore - subtrahend.initScore(), this.hardScore - subtrahend.hardScore(), this.mediumScore - subtrahend.mediumScore(), this.softScore - subtrahend.softScore());
    }

    @Override
    public HardMediumSoftScore multiply(double multiplicand) {
        return new HardMediumSoftScore((int)Math.floor((double)this.initScore * multiplicand), (int)Math.floor((double)this.hardScore * multiplicand), (int)Math.floor((double)this.mediumScore * multiplicand), (int)Math.floor((double)this.softScore * multiplicand));
    }

    @Override
    public HardMediumSoftScore divide(double divisor) {
        return new HardMediumSoftScore((int)Math.floor((double)this.initScore / divisor), (int)Math.floor((double)this.hardScore / divisor), (int)Math.floor((double)this.mediumScore / divisor), (int)Math.floor((double)this.softScore / divisor));
    }

    @Override
    public HardMediumSoftScore power(double exponent) {
        return new HardMediumSoftScore((int)Math.floor(Math.pow(this.initScore, exponent)), (int)Math.floor(Math.pow(this.hardScore, exponent)), (int)Math.floor(Math.pow(this.mediumScore, exponent)), (int)Math.floor(Math.pow(this.softScore, exponent)));
    }

    @Override
    public HardMediumSoftScore abs() {
        return new HardMediumSoftScore(Math.abs(this.initScore), Math.abs(this.hardScore), Math.abs(this.mediumScore), Math.abs(this.softScore));
    }

    @Override
    public HardMediumSoftScore zero() {
        return ZERO;
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.hardScore, this.mediumScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HardMediumSoftScore) {
            HardMediumSoftScore other = (HardMediumSoftScore)o;
            return this.initScore == other.initScore() && this.hardScore == other.hardScore() && this.mediumScore == other.mediumScore() && this.softScore == other.softScore();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, this.hardScore, this.mediumScore, this.softScore);
    }

    @Override
    public int compareTo(HardMediumSoftScore other) {
        if (this.initScore != other.initScore()) {
            return Integer.compare(this.initScore, other.initScore());
        }
        if (this.hardScore != other.hardScore()) {
            return Integer.compare(this.hardScore, other.hardScore());
        }
        if (this.mediumScore != other.mediumScore()) {
            return Integer.compare(this.mediumScore, other.mediumScore());
        }
        return Integer.compare(this.softScore, other.softScore());
    }

    @Override
    public String toShortString() {
        return ScoreUtil.buildShortString(this, n -> n.intValue() != 0, "hard", "medium", "soft");
    }

    public String toString() {
        return ScoreUtil.getInitPrefix(this.initScore) + this.hardScore + "hard/" + this.mediumScore + "medium/" + this.softScore + "soft";
    }
}

