/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.common.inliner;

import ai.timefold.solver.constraint.streams.common.AbstractConstraint;
import ai.timefold.solver.constraint.streams.common.inliner.BendableBigDecimalScoreInliner;
import ai.timefold.solver.constraint.streams.common.inliner.ConstraintMatchSupplier;
import ai.timefold.solver.constraint.streams.common.inliner.ScoreContext;
import ai.timefold.solver.constraint.streams.common.inliner.UndoScoreImpacter;
import ai.timefold.solver.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import java.math.BigDecimal;

final class BendableBigDecimalScoreContext
extends ScoreContext<BendableBigDecimalScore, BendableBigDecimalScoreInliner> {
    private final int hardScoreLevelCount;
    private final int softScoreLevelCount;
    private final int scoreLevel;
    private final BigDecimal scoreLevelWeight;

    public BendableBigDecimalScoreContext(BendableBigDecimalScoreInliner parent, AbstractConstraint<?, ?, ?> constraint, BendableBigDecimalScore constraintWeight, int hardScoreLevelCount, int softScoreLevelCount, int scoreLevel, BigDecimal scoreLevelWeight) {
        super(parent, constraint, constraintWeight);
        this.hardScoreLevelCount = hardScoreLevelCount;
        this.softScoreLevelCount = softScoreLevelCount;
        this.scoreLevel = scoreLevel;
        this.scoreLevelWeight = scoreLevelWeight;
    }

    public BendableBigDecimalScoreContext(BendableBigDecimalScoreInliner parent, AbstractConstraint<?, ?, ?> constraint, BendableBigDecimalScore constraintWeight, int hardScoreLevelCount, int softScoreLevelCount) {
        this(parent, constraint, constraintWeight, hardScoreLevelCount, softScoreLevelCount, -1, BigDecimal.ZERO);
    }

    public UndoScoreImpacter changeSoftScoreBy(BigDecimal matchWeight, ConstraintMatchSupplier<BendableBigDecimalScore> constraintMatchSupplier) {
        BigDecimal softImpact = this.scoreLevelWeight.multiply(matchWeight);
        ((BendableBigDecimalScoreInliner)this.parent).softScores[this.scoreLevel] = ((BendableBigDecimalScoreInliner)this.parent).softScores[this.scoreLevel].add(softImpact);
        UndoScoreImpacter undoScoreImpact = () -> {
            ((BendableBigDecimalScoreInliner)this.parent).softScores[this.scoreLevel] = ((BendableBigDecimalScoreInliner)this.parent).softScores[this.scoreLevel].subtract(softImpact);
        };
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, BendableBigDecimalScore.ofSoft((int)this.hardScoreLevelCount, (int)this.softScoreLevelCount, (int)this.scoreLevel, (BigDecimal)softImpact), constraintMatchSupplier);
    }

    public UndoScoreImpacter changeHardScoreBy(BigDecimal matchWeight, ConstraintMatchSupplier<BendableBigDecimalScore> constraintMatchSupplier) {
        BigDecimal hardImpact = this.scoreLevelWeight.multiply(matchWeight);
        ((BendableBigDecimalScoreInliner)this.parent).hardScores[this.scoreLevel] = ((BendableBigDecimalScoreInliner)this.parent).hardScores[this.scoreLevel].add(hardImpact);
        UndoScoreImpacter undoScoreImpact = () -> {
            ((BendableBigDecimalScoreInliner)this.parent).hardScores[this.scoreLevel] = ((BendableBigDecimalScoreInliner)this.parent).hardScores[this.scoreLevel].subtract(hardImpact);
        };
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, BendableBigDecimalScore.ofHard((int)this.hardScoreLevelCount, (int)this.softScoreLevelCount, (int)this.scoreLevel, (BigDecimal)hardImpact), constraintMatchSupplier);
    }

    public UndoScoreImpacter changeScoreBy(BigDecimal matchWeight, ConstraintMatchSupplier<BendableBigDecimalScore> constraintMatchSupplier) {
        BigDecimal[] hardImpacts = new BigDecimal[this.hardScoreLevelCount];
        BigDecimal[] softImpacts = new BigDecimal[this.softScoreLevelCount];
        for (int hardScoreLevel = 0; hardScoreLevel < this.hardScoreLevelCount; ++hardScoreLevel) {
            BigDecimal hardImpact;
            hardImpacts[hardScoreLevel] = hardImpact = ((BendableBigDecimalScore)this.constraintWeight).hardScore(hardScoreLevel).multiply(matchWeight);
            ((BendableBigDecimalScoreInliner)this.parent).hardScores[hardScoreLevel] = ((BendableBigDecimalScoreInliner)this.parent).hardScores[hardScoreLevel].add(hardImpact);
        }
        for (int softScoreLevel = 0; softScoreLevel < this.softScoreLevelCount; ++softScoreLevel) {
            BigDecimal softImpact;
            softImpacts[softScoreLevel] = softImpact = ((BendableBigDecimalScore)this.constraintWeight).softScore(softScoreLevel).multiply(matchWeight);
            ((BendableBigDecimalScoreInliner)this.parent).softScores[softScoreLevel] = ((BendableBigDecimalScoreInliner)this.parent).softScores[softScoreLevel].add(softImpact);
        }
        UndoScoreImpacter undoScoreImpact = () -> {
            for (int hardScoreLevel = 0; hardScoreLevel < this.hardScoreLevelCount; ++hardScoreLevel) {
                ((BendableBigDecimalScoreInliner)this.parent).hardScores[hardScoreLevel] = ((BendableBigDecimalScoreInliner)this.parent).hardScores[hardScoreLevel].subtract(hardImpacts[hardScoreLevel]);
            }
            for (int softScoreLevel = 0; softScoreLevel < this.softScoreLevelCount; ++softScoreLevel) {
                ((BendableBigDecimalScoreInliner)this.parent).softScores[softScoreLevel] = ((BendableBigDecimalScoreInliner)this.parent).softScores[softScoreLevel].subtract(softImpacts[softScoreLevel]);
            }
        };
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, BendableBigDecimalScore.of((BigDecimal[])hardImpacts, (BigDecimal[])softImpacts), constraintMatchSupplier);
    }
}

