/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.drl.holder;

import ai.timefold.solver.constraint.drl.holder.AbstractScoreHolder;
import ai.timefold.solver.core.api.domain.constraintweight.ConstraintConfiguration;
import ai.timefold.solver.core.api.domain.constraintweight.ConstraintWeight;
import ai.timefold.solver.core.api.domain.solution.PlanningScore;
import ai.timefold.solver.core.api.score.buildin.bendable.BendableScore;
import ai.timefold.solver.core.api.score.buildin.bendable.BendableScoreHolder;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;

public final class BendableScoreHolderImpl
extends AbstractScoreHolder<BendableScore>
implements BendableScoreHolder {
    protected final Map<Rule, AbstractScoreHolder.IntMatchExecutor> matchExecutorByNumberMap = new LinkedHashMap<Rule, AbstractScoreHolder.IntMatchExecutor>();
    protected final Map<Rule, AbstractScoreHolder.ScoreMatchExecutor<BendableScore>> matchExecutorByScoreMap = new LinkedHashMap<Rule, AbstractScoreHolder.ScoreMatchExecutor<BendableScore>>();
    private int[] hardScores;
    private int[] softScores;

    public BendableScoreHolderImpl(boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintMatchEnabled);
        this.hardScores = new int[hardLevelsSize];
        this.softScores = new int[softLevelsSize];
    }

    public int getHardLevelsSize() {
        return this.hardScores.length;
    }

    public int getHardScore(int hardLevel) {
        return this.hardScores[hardLevel];
    }

    public int getSoftLevelsSize() {
        return this.softScores.length;
    }

    public int getSoftScore(int softLevel) {
        return this.softScores[softLevel];
    }

    @Override
    public void configureConstraintWeight(Rule rule, BendableScore constraintWeight) {
        AbstractScoreHolder.IntMatchExecutor matchExecutor;
        super.configureConstraintWeight(rule, constraintWeight);
        if (constraintWeight.equals((Object)BendableScore.zero((int)this.hardScores.length, (int)this.softScores.length))) {
            matchExecutor = (kcontext, matchWeight) -> {};
        } else {
            Integer singleLevel = null;
            Integer singleLevelWeight = null;
            for (int i = 0; i < constraintWeight.levelsSize(); ++i) {
                int levelWeight = constraintWeight.hardOrSoftScore(i);
                if (levelWeight == 0) continue;
                if (singleLevel != null) {
                    singleLevel = null;
                    singleLevelWeight = null;
                    break;
                }
                singleLevel = i;
                singleLevelWeight = levelWeight;
            }
            if (singleLevel != null) {
                int level;
                int levelWeight = singleLevelWeight;
                if (singleLevel < constraintWeight.hardLevelsSize()) {
                    level = singleLevel;
                    matchExecutor = (kcontext, matchWeight) -> this.addHardConstraintMatch(kcontext, level, levelWeight * matchWeight);
                } else {
                    level = singleLevel - constraintWeight.hardLevelsSize();
                    matchExecutor = (kcontext, matchWeight) -> this.addSoftConstraintMatch(kcontext, level, levelWeight * matchWeight);
                }
            } else {
                matchExecutor = (kcontext, matchWeight) -> {
                    int i;
                    int[] hardWeights = new int[this.hardScores.length];
                    int[] softWeights = new int[this.softScores.length];
                    for (i = 0; i < hardWeights.length; ++i) {
                        hardWeights[i] = constraintWeight.hardScore(i) * matchWeight;
                    }
                    for (i = 0; i < softWeights.length; ++i) {
                        softWeights[i] = constraintWeight.softScore(i) * matchWeight;
                    }
                    this.addMultiConstraintMatch(kcontext, hardWeights, softWeights);
                };
            }
        }
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
        this.matchExecutorByScoreMap.put(rule, (kcontext, weightMultiplier) -> {
            int i;
            int[] hardWeights = new int[this.hardScores.length];
            int[] softWeights = new int[this.softScores.length];
            for (i = 0; i < hardWeights.length; ++i) {
                hardWeights[i] = constraintWeight.hardScore(i) * weightMultiplier.hardScore(i);
            }
            for (i = 0; i < softWeights.length; ++i) {
                softWeights[i] = constraintWeight.softScore(i) * weightMultiplier.softScore(i);
            }
            this.addMultiConstraintMatch(kcontext, hardWeights, softWeights);
        });
    }

    public void penalize(RuleContext kcontext) {
        this.impactScore(kcontext, -1);
    }

    public void penalize(RuleContext kcontext, int weightMultiplier) {
        this.impactScore(kcontext, -weightMultiplier);
    }

    public void penalize(RuleContext kcontext, int[] hardWeightsMultiplier, int[] softWeightsMultiplier) {
        int i;
        int[] negatedHardWeightsMultiplier = new int[this.hardScores.length];
        int[] negatedSoftWeightsMultiplier = new int[this.softScores.length];
        for (i = 0; i < negatedHardWeightsMultiplier.length; ++i) {
            negatedHardWeightsMultiplier[i] = -hardWeightsMultiplier[i];
        }
        for (i = 0; i < negatedSoftWeightsMultiplier.length; ++i) {
            negatedSoftWeightsMultiplier[i] = -softWeightsMultiplier[i];
        }
        this.impactScore(kcontext, negatedHardWeightsMultiplier, negatedSoftWeightsMultiplier);
    }

    public void reward(RuleContext kcontext) {
        this.impactScore(kcontext, 1);
    }

    public void reward(RuleContext kcontext, int weightMultiplier) {
        this.impactScore(kcontext, weightMultiplier);
    }

    public void reward(RuleContext kcontext, int[] hardWeightsMultiplier, int[] softWeightsMultiplier) {
        this.impactScore(kcontext, hardWeightsMultiplier, softWeightsMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext) {
        this.impactScore(kcontext, 1);
    }

    @Override
    public void impactScore(RuleContext kcontext, int weightMultiplier) {
        Rule rule = kcontext.getRule();
        AbstractScoreHolder.IntMatchExecutor matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext, long weightMultiplier) {
        throw new UnsupportedOperationException("In the rule (" + kcontext.getRule().getName() + "), the scoreHolder class (" + this.getClass() + ") does not support a long weightMultiplier (" + weightMultiplier + ").\nIf you're using constraint streams, maybe switch from penalizeLong() to penalize().");
    }

    @Override
    public void impactScore(RuleContext kcontext, BigDecimal weightMultiplier) {
        throw new UnsupportedOperationException("In the rule (" + kcontext.getRule().getName() + "), the scoreHolder class (" + this.getClass() + ") does not support a BigDecimal weightMultiplier (" + weightMultiplier + ").\nIf you're using constraint streams, maybe switch from penalizeBigDecimal() to penalize().");
    }

    private void impactScore(RuleContext kcontext, int[] hardWeightsMultiplier, int[] softWeightsMultiplier) {
        Rule rule = kcontext.getRule();
        AbstractScoreHolder.ScoreMatchExecutor<BendableScore> matchExecutor = this.matchExecutorByScoreMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, BendableScore.of((int[])hardWeightsMultiplier, (int[])softWeightsMultiplier));
    }

    public void addHardConstraintMatch(RuleContext kcontext, int hardLevel, int weight) {
        if (hardLevel >= this.hardScores.length) {
            throw new IllegalArgumentException("The hardLevel (" + hardLevel + ") isn't lower than the hardScores length (" + this.hardScores.length + ") defined by the @" + PlanningScore.class.getSimpleName() + " on the planning solution class.");
        }
        int n = hardLevel;
        this.hardScores[n] = this.hardScores[n] + weight;
        this.registerConstraintMatch(kcontext, () -> {
            int n = hardLevel;
            this.hardScores[n] = this.hardScores[n] - weight;
        }, () -> {
            int[] newHardScores = new int[this.hardScores.length];
            int[] newSoftScores = new int[this.softScores.length];
            newHardScores[hardLevel] = weight;
            return BendableScore.of((int[])newHardScores, (int[])newSoftScores);
        });
    }

    public void addSoftConstraintMatch(RuleContext kcontext, int softLevel, int weight) {
        if (softLevel >= this.softScores.length) {
            throw new IllegalArgumentException("The softLevel (" + softLevel + ") isn't lower than the softScores length (" + this.softScores.length + ") defined by the @" + PlanningScore.class.getSimpleName() + " on the planning solution class.");
        }
        int n = softLevel;
        this.softScores[n] = this.softScores[n] + weight;
        this.registerConstraintMatch(kcontext, () -> {
            int n = softLevel;
            this.softScores[n] = this.softScores[n] - weight;
        }, () -> {
            int[] newHardScores = new int[this.hardScores.length];
            int[] newSoftScores = new int[this.softScores.length];
            newSoftScores[softLevel] = weight;
            return BendableScore.of((int[])newHardScores, (int[])newSoftScores);
        });
    }

    public void addMultiConstraintMatch(RuleContext kcontext, int[] hardWeights, int[] softWeights) {
        int i;
        if (hardWeights.length != this.hardScores.length) {
            throw new IllegalArgumentException("The hardWeights length (" + hardWeights.length + ") is different than the hardScores length (" + this.hardScores.length + ") defined by the @" + PlanningScore.class.getSimpleName() + " on the planning solution class.");
        }
        for (i = 0; i < this.hardScores.length; ++i) {
            int n = i;
            this.hardScores[n] = this.hardScores[n] + hardWeights[i];
        }
        if (softWeights.length != this.softScores.length) {
            throw new IllegalArgumentException("The softWeights length (" + softWeights.length + ") is different than the softScores length (" + this.softScores.length + ") defined by the @" + PlanningScore.class.getSimpleName() + " on the planning solution class.");
        }
        for (i = 0; i < this.softScores.length; ++i) {
            int n = i;
            this.softScores[n] = this.softScores[n] + softWeights[i];
        }
        this.registerConstraintMatch(kcontext, () -> {
            int i;
            for (i = 0; i < this.hardScores.length; ++i) {
                int n = i;
                this.hardScores[n] = this.hardScores[n] - hardWeights[i];
            }
            for (i = 0; i < this.softScores.length; ++i) {
                int n = i;
                this.softScores[n] = this.softScores[n] - softWeights[i];
            }
        }, () -> BendableScore.of((int[])hardWeights, (int[])softWeights));
    }

    @Override
    public BendableScore extractScore(int initScore) {
        return BendableScore.ofUninitialized((int)initScore, (int[])Arrays.copyOf(this.hardScores, this.hardScores.length), (int[])Arrays.copyOf(this.softScores, this.softScores.length));
    }
}

