/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.statistic.bestscore;

import ai.timefold.solver.benchmark.config.statistic.ProblemStatisticType;
import ai.timefold.solver.benchmark.impl.report.BenchmarkReport;
import ai.timefold.solver.benchmark.impl.report.LineChart;
import ai.timefold.solver.benchmark.impl.result.ProblemBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SubSingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.statistic.ProblemStatistic;
import ai.timefold.solver.benchmark.impl.statistic.SubSingleStatistic;
import ai.timefold.solver.benchmark.impl.statistic.bestscore.BestScoreStatisticPoint;
import ai.timefold.solver.benchmark.impl.statistic.bestscore.BestScoreSubSingleStatistic;
import java.util.ArrayList;
import java.util.List;

public class BestScoreProblemStatistic
extends ProblemStatistic<LineChart<Long, Double>> {
    private BestScoreProblemStatistic() {
    }

    public BestScoreProblemStatistic(ProblemBenchmarkResult problemBenchmarkResult) {
        super(problemBenchmarkResult, ProblemStatisticType.BEST_SCORE);
    }

    @Override
    public SubSingleStatistic createSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        return new BestScoreSubSingleStatistic(subSingleBenchmarkResult);
    }

    @Override
    protected List<LineChart<Long, Double>> generateCharts(BenchmarkReport benchmarkReport) {
        ArrayList builderList = new ArrayList(15);
        for (SingleBenchmarkResult singleBenchmarkResult : this.problemBenchmarkResult.getSingleBenchmarkResultList()) {
            if (!singleBenchmarkResult.hasAllSuccess()) continue;
            String solverLabel = singleBenchmarkResult.getSolverBenchmarkResult().getNameWithFavoriteSuffix();
            SubSingleStatistic subSingleStatistic = singleBenchmarkResult.getSubSingleStatistic(this.problemStatisticType);
            List points = subSingleStatistic.getPointList();
            for (BestScoreStatisticPoint point : points) {
                if (!point.isInitialized()) continue;
                long timeMillisSpent = point.getTimeMillisSpent();
                double[] levelValues = point.getScore().toLevelDoubles();
                for (int i = 0; i < levelValues.length && i < 15; ++i) {
                    if (i >= builderList.size()) {
                        builderList.add(new LineChart.Builder());
                    }
                    LineChart.Builder builder = (LineChart.Builder)builderList.get(i);
                    if (singleBenchmarkResult.getSolverBenchmarkResult().isFavorite()) {
                        builder.markFavorite(solverLabel);
                    }
                    builder.add(solverLabel, timeMillisSpent, levelValues[i]);
                }
            }
            long timeMillisSpent = singleBenchmarkResult.getTimeMillisSpent();
            double[] bestScoreLevels = singleBenchmarkResult.getMedian().getScore().toLevelDoubles();
            for (int i = 0; i < bestScoreLevels.length && i < 15; ++i) {
                if (i >= builderList.size()) {
                    builderList.add(new LineChart.Builder());
                }
                LineChart.Builder builder = (LineChart.Builder)builderList.get(i);
                if (singleBenchmarkResult.getSolverBenchmarkResult().isFavorite()) {
                    builder.markFavorite(solverLabel);
                }
                builder.add(solverLabel, timeMillisSpent, bestScoreLevels[i]);
            }
        }
        ArrayList<LineChart<Long, Double>> chartList = new ArrayList<LineChart<Long, Double>>(builderList.size());
        for (int scoreLevelIndex = 0; scoreLevelIndex < builderList.size(); ++scoreLevelIndex) {
            String scoreLevelLabel = this.problemBenchmarkResult.findScoreLevelLabel(scoreLevelIndex);
            LineChart.Builder builder = (LineChart.Builder)builderList.get(scoreLevelIndex);
            LineChart chart = builder.build("bestScoreProblemStatisticChart" + scoreLevelIndex, this.problemBenchmarkResult.getName() + " best " + scoreLevelLabel + " statistic", "Time spent", "Best " + scoreLevelLabel, true, true, false);
            chartList.add(chart);
        }
        return chartList;
    }
}

