/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.aggregator;

import ai.timefold.solver.benchmark.config.report.BenchmarkReportConfig;
import ai.timefold.solver.benchmark.impl.report.BenchmarkReport;
import ai.timefold.solver.benchmark.impl.report.BenchmarkReportFactory;
import ai.timefold.solver.benchmark.impl.result.PlannerBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SolverBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SubSingleBenchmarkResult;
import java.io.File;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BenchmarkAggregator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BenchmarkAggregator.class);
    private File benchmarkDirectory = null;
    private BenchmarkReportConfig benchmarkReportConfig = null;

    public File getBenchmarkDirectory() {
        return this.benchmarkDirectory;
    }

    public void setBenchmarkDirectory(File benchmarkDirectory) {
        this.benchmarkDirectory = benchmarkDirectory;
    }

    public BenchmarkReportConfig getBenchmarkReportConfig() {
        return this.benchmarkReportConfig;
    }

    public void setBenchmarkReportConfig(BenchmarkReportConfig benchmarkReportConfig) {
        this.benchmarkReportConfig = benchmarkReportConfig;
    }

    public File aggregate(List<SingleBenchmarkResult> singleBenchmarkResultList, Map<SolverBenchmarkResult, String> solverBenchmarkResultNameMap) {
        if (this.benchmarkDirectory == null) {
            throw new IllegalArgumentException("The benchmarkDirectory (" + String.valueOf(this.benchmarkDirectory) + ") must not be null.");
        }
        if (!this.benchmarkDirectory.exists()) {
            throw new IllegalArgumentException("The benchmarkDirectory (" + String.valueOf(this.benchmarkDirectory) + ") must exist.");
        }
        if (this.benchmarkReportConfig == null) {
            throw new IllegalArgumentException("The benchmarkReportConfig (" + String.valueOf((Object)this.benchmarkReportConfig) + ") must not be null.");
        }
        if (singleBenchmarkResultList.isEmpty()) {
            throw new IllegalArgumentException("The singleBenchmarkResultList (" + String.valueOf(singleBenchmarkResultList) + ") must not be empty.");
        }
        OffsetDateTime startingTimestamp = OffsetDateTime.now();
        for (SingleBenchmarkResult singleBenchmarkResult : singleBenchmarkResultList) {
            for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
                subSingleBenchmarkResult.setSingleBenchmarkResult(singleBenchmarkResult);
            }
            singleBenchmarkResult.initSubSingleStatisticMaps();
        }
        if (solverBenchmarkResultNameMap != null) {
            for (Map.Entry entry : solverBenchmarkResultNameMap.entrySet()) {
                SolverBenchmarkResult result = (SolverBenchmarkResult)entry.getKey();
                String newName = (String)entry.getValue();
                if (result.getName().equals(newName)) continue;
                result.setName(newName);
            }
        }
        PlannerBenchmarkResult plannerBenchmarkResult = PlannerBenchmarkResult.createMergedResult(singleBenchmarkResultList);
        plannerBenchmarkResult.setStartingTimestamp(startingTimestamp);
        plannerBenchmarkResult.initBenchmarkReportDirectory(this.benchmarkDirectory);
        BenchmarkReportFactory benchmarkReportFactory = new BenchmarkReportFactory(this.benchmarkReportConfig);
        BenchmarkReport benchmarkReport = benchmarkReportFactory.buildBenchmarkReport(plannerBenchmarkResult);
        plannerBenchmarkResult.accumulateResults(benchmarkReport);
        benchmarkReport.writeReport();
        LOGGER.info("Aggregation ended: statistic html overview ({}).", (Object)benchmarkReport.getHtmlOverviewFile().getAbsolutePath());
        return benchmarkReport.getHtmlOverviewFile().getAbsoluteFile();
    }
}

