/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.config;

import ai.timefold.solver.benchmark.api.PlannerBenchmarkFactory;
import ai.timefold.solver.benchmark.config.SolverBenchmarkConfig;
import ai.timefold.solver.benchmark.config.blueprint.SolverBenchmarkBluePrintConfig;
import ai.timefold.solver.benchmark.config.report.BenchmarkReportConfig;
import ai.timefold.solver.benchmark.impl.io.PlannerBenchmarkConfigIO;
import ai.timefold.solver.benchmark.impl.report.BenchmarkReport;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.impl.io.jaxb.TimefoldXmlSerializationException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="plannerBenchmark")
@XmlType(propOrder={"name", "benchmarkDirectory", "threadFactoryClass", "parallelBenchmarkCount", "warmUpMillisecondsSpentLimit", "warmUpSecondsSpentLimit", "warmUpMinutesSpentLimit", "warmUpHoursSpentLimit", "warmUpDaysSpentLimit", "benchmarkReportConfig", "inheritedSolverBenchmarkConfig", "solverBenchmarkBluePrintConfigList", "solverBenchmarkConfigList"})
public class PlannerBenchmarkConfig {
    public static final String SOLVER_NAMESPACE_PREFIX = "solver";
    public static final String XML_ELEMENT_NAME = "plannerBenchmark";
    public static final String XML_NAMESPACE = "https://timefold.ai/xsd/benchmark";
    public static final String PARALLEL_BENCHMARK_COUNT_AUTO = "AUTO";
    @XmlTransient
    private ClassLoader classLoader = null;
    private String name = null;
    private File benchmarkDirectory = null;
    private Class<? extends ThreadFactory> threadFactoryClass = null;
    private String parallelBenchmarkCount = null;
    private Long warmUpMillisecondsSpentLimit = null;
    private Long warmUpSecondsSpentLimit = null;
    private Long warmUpMinutesSpentLimit = null;
    private Long warmUpHoursSpentLimit = null;
    private Long warmUpDaysSpentLimit = null;
    @XmlElement(name="benchmarkReport")
    private BenchmarkReportConfig benchmarkReportConfig = null;
    @XmlElement(name="inheritedSolverBenchmark")
    private SolverBenchmarkConfig inheritedSolverBenchmarkConfig = null;
    @XmlElement(name="solverBenchmarkBluePrint")
    private List<SolverBenchmarkBluePrintConfig> solverBenchmarkBluePrintConfigList = null;
    @XmlElement(name="solverBenchmark")
    private List<SolverBenchmarkConfig> solverBenchmarkConfigList = null;

    public static @NonNull PlannerBenchmarkConfig createFromSolverConfig(@NonNull SolverConfig solverConfig) {
        return PlannerBenchmarkConfig.createFromSolverConfig(solverConfig, new File("local/benchmarkReport"));
    }

    public static @NonNull PlannerBenchmarkConfig createFromSolverConfig(@NonNull SolverConfig solverConfig, @NonNull File benchmarkDirectory) {
        PlannerBenchmarkConfig plannerBenchmarkConfig = new PlannerBenchmarkConfig();
        plannerBenchmarkConfig.setBenchmarkDirectory(benchmarkDirectory);
        SolverBenchmarkConfig solverBenchmarkConfig = new SolverBenchmarkConfig();
        solverBenchmarkConfig.setSolverConfig(new SolverConfig(solverConfig));
        plannerBenchmarkConfig.setInheritedSolverBenchmarkConfig(solverBenchmarkConfig);
        plannerBenchmarkConfig.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        return plannerBenchmarkConfig;
    }

    public static @NonNull PlannerBenchmarkConfig createFromXmlResource(@NonNull String benchmarkConfigResource) {
        return PlannerBenchmarkConfig.createFromXmlResource(benchmarkConfigResource, null);
    }

    public static @NonNull PlannerBenchmarkConfig createFromXmlResource(@NonNull String benchmarkConfigResource, @Nullable ClassLoader classLoader) {
        PlannerBenchmarkConfig plannerBenchmarkConfig;
        block11: {
            ClassLoader actualClassLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
            InputStream in = actualClassLoader.getResourceAsStream(benchmarkConfigResource);
            try {
                if (in == null) {
                    String errorMessage = "The benchmarkConfigResource (" + benchmarkConfigResource + ") does not exist as a classpath resource in the classLoader (" + String.valueOf(actualClassLoader) + ").";
                    if (benchmarkConfigResource.startsWith("/")) {
                        errorMessage = errorMessage + "\nA classpath resource should not start with a slash (/). A benchmarkConfigResource adheres to ClassLoader.getResource(String). Maybe remove the leading slash from the benchmarkConfigResource.";
                    }
                    throw new IllegalArgumentException(errorMessage);
                }
                plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromXmlInputStream(in, classLoader);
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TimefoldXmlSerializationException e) {
                    throw new IllegalArgumentException("Unmarshalling of benchmarkConfigResource (" + benchmarkConfigResource + ") fails.", e);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Reading the benchmarkConfigResource (" + benchmarkConfigResource + ") fails.", e);
                }
            }
            in.close();
        }
        return plannerBenchmarkConfig;
    }

    public static @NonNull PlannerBenchmarkConfig createFromXmlFile(@NonNull File benchmarkConfigFile) {
        return PlannerBenchmarkConfig.createFromXmlFile(benchmarkConfigFile, null);
    }

    public static @NonNull PlannerBenchmarkConfig createFromXmlFile(@NonNull File benchmarkConfigFile, @Nullable ClassLoader classLoader) {
        PlannerBenchmarkConfig plannerBenchmarkConfig;
        FileInputStream in = new FileInputStream(benchmarkConfigFile);
        try {
            plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromXmlInputStream(in, classLoader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (TimefoldXmlSerializationException e) {
                throw new IllegalArgumentException("Unmarshalling the benchmarkConfigFile (" + String.valueOf(benchmarkConfigFile) + ") fails.", e);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("The benchmarkConfigFile (" + String.valueOf(benchmarkConfigFile) + ") was not found.", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Reading the benchmarkConfigFile (" + String.valueOf(benchmarkConfigFile) + ") fails.", e);
            }
        }
        ((InputStream)in).close();
        return plannerBenchmarkConfig;
    }

    public static @NonNull PlannerBenchmarkConfig createFromXmlInputStream(@NonNull InputStream in) {
        return PlannerBenchmarkConfig.createFromXmlInputStream(in, null);
    }

    public static @NonNull PlannerBenchmarkConfig createFromXmlInputStream(@NonNull InputStream in, @Nullable ClassLoader classLoader) {
        PlannerBenchmarkConfig plannerBenchmarkConfig;
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        try {
            plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromXmlReader(reader, classLoader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("This vm does not support the charset (" + String.valueOf(StandardCharsets.UTF_8) + ").", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Reading fails.", e);
            }
        }
        ((Reader)reader).close();
        return plannerBenchmarkConfig;
    }

    public static @NonNull PlannerBenchmarkConfig createFromXmlReader(@NonNull Reader reader) {
        return PlannerBenchmarkConfig.createFromXmlReader(reader, null);
    }

    public static @NonNull PlannerBenchmarkConfig createFromXmlReader(@NonNull Reader reader, @Nullable ClassLoader classLoader) {
        PlannerBenchmarkConfigIO xmlIO = new PlannerBenchmarkConfigIO();
        PlannerBenchmarkConfig benchmarkConfigObject = xmlIO.read(reader);
        if (!(benchmarkConfigObject instanceof PlannerBenchmarkConfig)) {
            throw new IllegalArgumentException("The " + PlannerBenchmarkConfig.class.getSimpleName() + "'s XML root element resolves to a different type (" + (benchmarkConfigObject == null ? null : benchmarkConfigObject.getClass().getSimpleName()) + ")." + (String)(benchmarkConfigObject instanceof SolverConfig ? "\nMaybe use " + PlannerBenchmarkFactory.class.getSimpleName() + ".createFromSolverConfigXmlResource() instead." : ""));
        }
        PlannerBenchmarkConfig benchmarkConfig = benchmarkConfigObject;
        benchmarkConfig.setClassLoader(classLoader);
        return benchmarkConfig;
    }

    public static @NonNull PlannerBenchmarkConfig createFromFreemarkerXmlResource(@NonNull String templateResource) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlResource(templateResource, null);
    }

    public static @NonNull PlannerBenchmarkConfig createFromFreemarkerXmlResource(@NonNull String templateResource, @Nullable ClassLoader classLoader) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlResource(templateResource, null, classLoader);
    }

    public static @NonNull PlannerBenchmarkConfig createFromFreemarkerXmlResource(@NonNull String templateResource, @Nullable Object model) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlResource(templateResource, model, null);
    }

    public static @NonNull PlannerBenchmarkConfig createFromFreemarkerXmlResource(@NonNull String templateResource, @Nullable Object model, @Nullable ClassLoader classLoader) {
        PlannerBenchmarkConfig plannerBenchmarkConfig;
        block10: {
            ClassLoader actualClassLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
            InputStream templateIn = actualClassLoader.getResourceAsStream(templateResource);
            try {
                if (templateIn == null) {
                    String errorMessage = "The templateResource (" + templateResource + ") does not exist as a classpath resource in the classLoader (" + String.valueOf(actualClassLoader) + ").";
                    if (templateResource.startsWith("/")) {
                        errorMessage = errorMessage + "\nA classpath resource should not start with a slash (/). A templateResource adheres to ClassLoader.getResource(String). Maybe remove the leading slash from the templateResource.";
                    }
                    throw new IllegalArgumentException(errorMessage);
                }
                plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlInputStream(templateIn, model, classLoader);
                if (templateIn == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (templateIn != null) {
                        try {
                            templateIn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Reading the templateResource (" + templateResource + ") fails.", e);
                }
            }
            templateIn.close();
        }
        return plannerBenchmarkConfig;
    }

    public static @NonNull PlannerBenchmarkConfig createFromFreemarkerXmlFile(@NonNull File templateFile) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlFile(templateFile, null);
    }

    public static @NonNull PlannerBenchmarkConfig createFromFreemarkerXmlFile(@NonNull File templateFile, @Nullable ClassLoader classLoader) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlFile(templateFile, null, classLoader);
    }

    public static @NonNull PlannerBenchmarkConfig createFromFreemarkerXmlFile(@NonNull File templateFile, @Nullable Object model) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlFile(templateFile, model, null);
    }

    public static @NonNull PlannerBenchmarkConfig createFromFreemarkerXmlFile(@NonNull File templateFile, @Nullable Object model, @Nullable ClassLoader classLoader) {
        PlannerBenchmarkConfig plannerBenchmarkConfig;
        FileInputStream templateIn = new FileInputStream(templateFile);
        try {
            plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlInputStream(templateIn, model, classLoader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    templateIn.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("The templateFile (" + String.valueOf(templateFile) + ") was not found.", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Reading the templateFile (" + String.valueOf(templateFile) + ") fails.", e);
            }
        }
        templateIn.close();
        return plannerBenchmarkConfig;
    }

    public static @NonNull PlannerBenchmarkConfig createFromFreemarkerXmlInputStream(@NonNull InputStream templateIn) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlInputStream(templateIn, null);
    }

    public static @NonNull PlannerBenchmarkConfig createFromFreemarkerXmlInputStream(@NonNull InputStream templateIn, @Nullable ClassLoader classLoader) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlInputStream(templateIn, null, classLoader);
    }

    public static @NonNull PlannerBenchmarkConfig createFromFreemarkerXmlInputStream(@NonNull InputStream templateIn, @Nullable Object model) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlInputStream(templateIn, model, null);
    }

    public static @NonNull PlannerBenchmarkConfig createFromFreemarkerXmlInputStream(@NonNull InputStream templateIn, @Nullable Object model, @Nullable ClassLoader classLoader) {
        PlannerBenchmarkConfig plannerBenchmarkConfig;
        InputStreamReader reader = new InputStreamReader(templateIn, StandardCharsets.UTF_8);
        try {
            plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromFreemarkerXmlReader(reader, model, classLoader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("This vm does not support the charset (" + String.valueOf(StandardCharsets.UTF_8) + ").", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Reading fails.", e);
            }
        }
        ((Reader)reader).close();
        return plannerBenchmarkConfig;
    }

    public static @NonNull PlannerBenchmarkConfig createFromFreemarkerXmlReader(@NonNull Reader templateReader) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlReader(templateReader, null);
    }

    public static @NonNull PlannerBenchmarkConfig createFromFreemarkerXmlReader(@NonNull Reader templateReader, @Nullable ClassLoader classLoader) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlReader(templateReader, null, classLoader);
    }

    public static @NonNull PlannerBenchmarkConfig createFromFreemarkerXmlReader(@NonNull Reader templateReader, @Nullable Object model) {
        return PlannerBenchmarkConfig.createFromFreemarkerXmlReader(templateReader, model, null);
    }

    public static @NonNull PlannerBenchmarkConfig createFromFreemarkerXmlReader(@NonNull Reader templateReader, @Nullable Object model, @Nullable ClassLoader classLoader) {
        String xmlContent;
        Configuration freemarkerConfiguration = BenchmarkReport.createFreeMarkerConfiguration();
        freemarkerConfiguration.setNumberFormat("computer");
        freemarkerConfiguration.setDateFormat("yyyy-mm-dd");
        freemarkerConfiguration.setDateTimeFormat("yyyy-mm-dd HH:mm:ss.SSS z");
        freemarkerConfiguration.setTimeFormat("HH:mm:ss.SSS");
        try (StringWriter xmlContentWriter = new StringWriter();){
            Template template = new Template("benchmarkTemplate.ftl", templateReader, freemarkerConfiguration, freemarkerConfiguration.getDefaultEncoding());
            template.process(model, (Writer)xmlContentWriter);
            xmlContent = xmlContentWriter.toString();
        }
        catch (TemplateException | IOException e) {
            throw new IllegalArgumentException("Can not process the Freemarker template into xmlContentWriter.", e);
        }
        try (StringReader configReader = new StringReader(xmlContent);){
            PlannerBenchmarkConfig plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromXmlReader(configReader, classLoader);
            return plannerBenchmarkConfig;
        }
    }

    public PlannerBenchmarkConfig() {
    }

    public PlannerBenchmarkConfig(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public @Nullable ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public @Nullable File getBenchmarkDirectory() {
        return this.benchmarkDirectory;
    }

    public void setBenchmarkDirectory(@Nullable File benchmarkDirectory) {
        this.benchmarkDirectory = benchmarkDirectory;
    }

    public @Nullable Class<? extends ThreadFactory> getThreadFactoryClass() {
        return this.threadFactoryClass;
    }

    public void setThreadFactoryClass(@Nullable Class<? extends ThreadFactory> threadFactoryClass) {
        this.threadFactoryClass = threadFactoryClass;
    }

    public @Nullable String getParallelBenchmarkCount() {
        return this.parallelBenchmarkCount;
    }

    public void setParallelBenchmarkCount(@Nullable String parallelBenchmarkCount) {
        this.parallelBenchmarkCount = parallelBenchmarkCount;
    }

    public @Nullable Long getWarmUpMillisecondsSpentLimit() {
        return this.warmUpMillisecondsSpentLimit;
    }

    public void setWarmUpMillisecondsSpentLimit(@Nullable Long warmUpMillisecondsSpentLimit) {
        this.warmUpMillisecondsSpentLimit = warmUpMillisecondsSpentLimit;
    }

    public @Nullable Long getWarmUpSecondsSpentLimit() {
        return this.warmUpSecondsSpentLimit;
    }

    public void setWarmUpSecondsSpentLimit(@Nullable Long warmUpSecondsSpentLimit) {
        this.warmUpSecondsSpentLimit = warmUpSecondsSpentLimit;
    }

    public @Nullable Long getWarmUpMinutesSpentLimit() {
        return this.warmUpMinutesSpentLimit;
    }

    public void setWarmUpMinutesSpentLimit(@Nullable Long warmUpMinutesSpentLimit) {
        this.warmUpMinutesSpentLimit = warmUpMinutesSpentLimit;
    }

    public @Nullable Long getWarmUpHoursSpentLimit() {
        return this.warmUpHoursSpentLimit;
    }

    public void setWarmUpHoursSpentLimit(@Nullable Long warmUpHoursSpentLimit) {
        this.warmUpHoursSpentLimit = warmUpHoursSpentLimit;
    }

    public @Nullable Long getWarmUpDaysSpentLimit() {
        return this.warmUpDaysSpentLimit;
    }

    public void setWarmUpDaysSpentLimit(@Nullable Long warmUpDaysSpentLimit) {
        this.warmUpDaysSpentLimit = warmUpDaysSpentLimit;
    }

    public @Nullable BenchmarkReportConfig getBenchmarkReportConfig() {
        return this.benchmarkReportConfig;
    }

    public void setBenchmarkReportConfig(@Nullable BenchmarkReportConfig benchmarkReportConfig) {
        this.benchmarkReportConfig = benchmarkReportConfig;
    }

    public @Nullable SolverBenchmarkConfig getInheritedSolverBenchmarkConfig() {
        return this.inheritedSolverBenchmarkConfig;
    }

    public void setInheritedSolverBenchmarkConfig(@Nullable SolverBenchmarkConfig inheritedSolverBenchmarkConfig) {
        this.inheritedSolverBenchmarkConfig = inheritedSolverBenchmarkConfig;
    }

    public @Nullable List<@NonNull SolverBenchmarkBluePrintConfig> getSolverBenchmarkBluePrintConfigList() {
        return this.solverBenchmarkBluePrintConfigList;
    }

    public void setSolverBenchmarkBluePrintConfigList(@Nullable List<@NonNull SolverBenchmarkBluePrintConfig> solverBenchmarkBluePrintConfigList) {
        this.solverBenchmarkBluePrintConfigList = solverBenchmarkBluePrintConfigList;
    }

    public @Nullable List<@NonNull SolverBenchmarkConfig> getSolverBenchmarkConfigList() {
        return this.solverBenchmarkConfigList;
    }

    public void setSolverBenchmarkConfigList(@Nullable List<@NonNull SolverBenchmarkConfig> solverBenchmarkConfigList) {
        this.solverBenchmarkConfigList = solverBenchmarkConfigList;
    }

    public @NonNull PlannerBenchmarkConfig withClassLoader(@NonNull ClassLoader classLoader) {
        this.setClassLoader(classLoader);
        return this;
    }

    public @NonNull PlannerBenchmarkConfig withName(@NonNull String name) {
        this.setName(name);
        return this;
    }

    public @NonNull PlannerBenchmarkConfig withBenchmarkDirectory(@NonNull File benchmarkDirectory) {
        this.setBenchmarkDirectory(benchmarkDirectory);
        return this;
    }

    public @NonNull PlannerBenchmarkConfig withThreadFactoryClass(@NonNull Class<? extends ThreadFactory> threadFactoryClass) {
        this.setThreadFactoryClass(threadFactoryClass);
        return this;
    }

    public @NonNull PlannerBenchmarkConfig withParallelBenchmarkCount(@NonNull String parallelBenchmarkCount) {
        this.setParallelBenchmarkCount(parallelBenchmarkCount);
        return this;
    }

    public @NonNull PlannerBenchmarkConfig withWarmUpMillisecondsSpentLimit(@NonNull Long warmUpMillisecondsSpentLimit) {
        this.setWarmUpMillisecondsSpentLimit(warmUpMillisecondsSpentLimit);
        return this;
    }

    public @NonNull PlannerBenchmarkConfig withWarmUpSecondsSpentLimit(@NonNull Long warmUpSecondsSpentLimit) {
        this.setWarmUpSecondsSpentLimit(warmUpSecondsSpentLimit);
        return this;
    }

    public @NonNull PlannerBenchmarkConfig withWarmUpMinutesSpentLimit(@NonNull Long warmUpMinutesSpentLimit) {
        this.setWarmUpMinutesSpentLimit(warmUpMinutesSpentLimit);
        return this;
    }

    public @NonNull PlannerBenchmarkConfig withWarmUpHoursSpentLimit(@NonNull Long warmUpHoursSpentLimit) {
        this.setWarmUpHoursSpentLimit(warmUpHoursSpentLimit);
        return this;
    }

    public @NonNull PlannerBenchmarkConfig withWarmUpDaysSpentLimit(@NonNull Long warmUpDaysSpentLimit) {
        this.setWarmUpDaysSpentLimit(warmUpDaysSpentLimit);
        return this;
    }

    public @NonNull PlannerBenchmarkConfig withBenchmarkReportConfig(@NonNull BenchmarkReportConfig benchmarkReportConfig) {
        this.setBenchmarkReportConfig(benchmarkReportConfig);
        return this;
    }

    public @NonNull PlannerBenchmarkConfig withInheritedSolverBenchmarkConfig(@NonNull SolverBenchmarkConfig inheritedSolverBenchmarkConfig) {
        this.setInheritedSolverBenchmarkConfig(inheritedSolverBenchmarkConfig);
        return this;
    }

    public @NonNull PlannerBenchmarkConfig withSolverBenchmarkBluePrintConfigList(@NonNull List<@NonNull SolverBenchmarkBluePrintConfig> solverBenchmarkBluePrintConfigList) {
        this.setSolverBenchmarkBluePrintConfigList(solverBenchmarkBluePrintConfigList);
        return this;
    }

    public @NonNull PlannerBenchmarkConfig withSolverBenchmarkBluePrintConfigs(SolverBenchmarkBluePrintConfig ... solverBenchmarkBluePrintConfigs) {
        this.setSolverBenchmarkBluePrintConfigList(List.of(solverBenchmarkBluePrintConfigs));
        return this;
    }

    public @NonNull PlannerBenchmarkConfig withSolverBenchmarkConfigList(@NonNull List<@NonNull SolverBenchmarkConfig> solverBenchmarkConfigList) {
        this.setSolverBenchmarkConfigList(solverBenchmarkConfigList);
        return this;
    }

    public @NonNull PlannerBenchmarkConfig withSolverBenchmarkConfigs(SolverBenchmarkConfig ... solverBenchmarkConfigs) {
        this.setSolverBenchmarkConfigList(List.of(solverBenchmarkConfigs));
        return this;
    }
}

