/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.wrappers;

import ai.timefold.jpyinterpreter.CPythonBackedPythonInterpreter;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeFunction;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import ai.timefold.jpyinterpreter.types.wrappers.OpaquePythonReference;
import ai.timefold.jpyinterpreter.types.wrappers.PythonObjectWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CPythonType
extends PythonLikeType {
    private static final Map<Number, CPythonType> cpythonTypeMap = new HashMap<Number, CPythonType>();
    private final OpaquePythonReference pythonReference;
    private final Map<String, PythonLikeObject> cachedAttributeMap;

    private static String getTypeName(OpaquePythonReference pythonReference) {
        return ((PythonString)CPythonBackedPythonInterpreter.lookupAttributeOnPythonReference(pythonReference, "__name__")).getValue();
    }

    public static CPythonType lookupTypeOfPythonObject(OpaquePythonReference reference) {
        OpaquePythonReference type = CPythonBackedPythonInterpreter.getPythonReferenceType(reference);
        return cpythonTypeMap.computeIfAbsent(CPythonBackedPythonInterpreter.getPythonReferenceId(type), key -> new CPythonType(type));
    }

    public static CPythonType getType(OpaquePythonReference typeReference) {
        return cpythonTypeMap.computeIfAbsent(CPythonBackedPythonInterpreter.getPythonReferenceId(typeReference), key -> new CPythonType(typeReference));
    }

    private CPythonType(OpaquePythonReference pythonReference) {
        super(CPythonType.getTypeName(pythonReference), PythonObjectWrapper.class);
        this.pythonReference = pythonReference;
        this.cachedAttributeMap = new HashMap<String, PythonLikeObject>();
    }

    @Override
    public PythonLikeObject $getAttributeOrNull(String attributeName) {
        switch (attributeName) {
            case "__eq__": {
                return this.cachedAttributeMap.computeIfAbsent(attributeName, key -> {
                    PythonLikeObject equals = CPythonBackedPythonInterpreter.lookupAttributeOnPythonReference(this.pythonReference, attributeName);
                    if (equals instanceof PythonLikeFunction) {
                        PythonLikeFunction function = (PythonLikeFunction)equals;
                        return (pos, named, callerInstance) -> {
                            PythonLikeObject result = function.$call(pos, named, null);
                            if (result instanceof PythonBoolean) {
                                return result;
                            }
                            return PythonBoolean.valueOf(pos.get(0) == pos.get(1));
                        };
                    }
                    return equals;
                });
            }
            case "__ne__": {
                return this.cachedAttributeMap.computeIfAbsent(attributeName, key -> {
                    PythonLikeObject notEquals = CPythonBackedPythonInterpreter.lookupAttributeOnPythonReference(this.pythonReference, attributeName);
                    if (notEquals instanceof PythonLikeFunction) {
                        PythonLikeFunction function = (PythonLikeFunction)notEquals;
                        return (pos, named, callerInstance) -> {
                            PythonLikeObject result = function.$call(pos, named, null);
                            if (result instanceof PythonBoolean) {
                                return result;
                            }
                            return PythonBoolean.valueOf(pos.get(0) != pos.get(1));
                        };
                    }
                    return notEquals;
                });
            }
            case "__hash__": {
                return this.cachedAttributeMap.computeIfAbsent(attributeName, key -> {
                    PythonLikeObject hash = CPythonBackedPythonInterpreter.lookupAttributeOnPythonReference(this.pythonReference, attributeName);
                    if (hash instanceof PythonLikeFunction) {
                        PythonLikeFunction function = (PythonLikeFunction)hash;
                        return (pos, named, callerInstance) -> {
                            PythonLikeObject result = function.$call(pos, named, null);
                            if (result instanceof PythonInteger) {
                                return result;
                            }
                            return PythonInteger.valueOf(System.identityHashCode(pos.get(0)));
                        };
                    }
                    return hash;
                });
            }
        }
        return this.cachedAttributeMap.computeIfAbsent(attributeName, key -> CPythonBackedPythonInterpreter.lookupAttributeOnPythonReference(this.pythonReference, attributeName));
    }

    @Override
    public void $setAttribute(String attributeName, PythonLikeObject value) {
        this.cachedAttributeMap.put(attributeName, value);
        CPythonBackedPythonInterpreter.setAttributeOnPythonReference(this.pythonReference, null, attributeName, value);
    }

    @Override
    public void $deleteAttribute(String attributeName) {
        this.cachedAttributeMap.remove(attributeName);
        CPythonBackedPythonInterpreter.deleteAttributeOnPythonReference(this.pythonReference, attributeName);
    }

    @Override
    public PythonLikeType $getType() {
        return BuiltinTypes.TYPE_TYPE;
    }

    @Override
    public PythonLikeObject $call(List<PythonLikeObject> positionalArguments, Map<PythonString, PythonLikeObject> namedArguments, PythonLikeObject callerInstance) {
        return CPythonBackedPythonInterpreter.callPythonReference(this.pythonReference, positionalArguments, namedArguments);
    }

    public OpaquePythonReference getPythonReference() {
        return this.pythonReference;
    }
}

