/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.datetime;

import ai.timefold.jpyinterpreter.types.errors.ValueError;
import java.time.DayOfWeek;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PythonDateTimeFormatter {
    private static final Pattern DIRECTIVE_PATTERN = Pattern.compile("([^%]*)%(.)");

    static DateTimeFormatter getDateTimeFormatter(String pattern) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        Matcher matcher = DIRECTIVE_PATTERN.matcher(pattern);
        int endIndex = 0;
        block29: while (matcher.find()) {
            String literalPart = matcher.group(1);
            builder.appendLiteral(literalPart);
            endIndex = matcher.end();
            char directive = matcher.group(2).charAt(0);
            switch (directive) {
                case 'a': {
                    builder.appendText((TemporalField)ChronoField.DAY_OF_WEEK, TextStyle.SHORT);
                    continue block29;
                }
                case 'A': {
                    builder.appendText((TemporalField)ChronoField.DAY_OF_WEEK, TextStyle.FULL);
                    continue block29;
                }
                case 'w': {
                    builder.appendValue(ChronoField.DAY_OF_WEEK);
                    continue block29;
                }
                case 'd': {
                    builder.appendValue(ChronoField.DAY_OF_MONTH, 2);
                    continue block29;
                }
                case 'b': {
                    builder.appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.SHORT);
                    continue block29;
                }
                case 'B': {
                    builder.appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.FULL);
                    continue block29;
                }
                case 'm': {
                    builder.appendValue(ChronoField.MONTH_OF_YEAR, 2);
                    continue block29;
                }
                case 'y': {
                    builder.appendPattern("uu");
                    continue block29;
                }
                case 'Y': {
                    builder.appendValue(ChronoField.YEAR);
                    continue block29;
                }
                case 'H': {
                    builder.appendValue(ChronoField.HOUR_OF_DAY, 2);
                    continue block29;
                }
                case 'I': {
                    builder.appendValue(ChronoField.HOUR_OF_AMPM, 2);
                    continue block29;
                }
                case 'p': {
                    builder.appendText(ChronoField.AMPM_OF_DAY);
                    continue block29;
                }
                case 'M': {
                    builder.appendValue(ChronoField.MINUTE_OF_HOUR, 2);
                    continue block29;
                }
                case 'S': {
                    builder.appendValue(ChronoField.SECOND_OF_MINUTE, 2);
                    continue block29;
                }
                case 'f': {
                    builder.appendValue(ChronoField.MICRO_OF_SECOND, 6);
                    continue block29;
                }
                case 'z': {
                    builder.appendOffset("+HHmmss", "");
                    continue block29;
                }
                case 'Z': {
                    builder.appendZoneOrOffsetId();
                    continue block29;
                }
                case 'j': {
                    builder.appendValue(ChronoField.DAY_OF_YEAR, 3);
                    continue block29;
                }
                case 'U': {
                    builder.appendValue(WeekFields.of(DayOfWeek.SUNDAY, 7).weekOfYear(), 2);
                    continue block29;
                }
                case 'W': {
                    builder.appendValue(WeekFields.of(DayOfWeek.MONDAY, 7).weekOfYear(), 2);
                    continue block29;
                }
                case 'c': {
                    builder.appendLocalized(FormatStyle.MEDIUM, FormatStyle.MEDIUM);
                    continue block29;
                }
                case 'x': {
                    builder.appendLocalized(FormatStyle.MEDIUM, null);
                    continue block29;
                }
                case 'X': {
                    builder.appendLocalized(null, FormatStyle.MEDIUM);
                    continue block29;
                }
                case '%': {
                    builder.appendLiteral("%");
                    continue block29;
                }
                case 'G': {
                    builder.appendValue(WeekFields.of(DayOfWeek.MONDAY, 4).weekBasedYear());
                    continue block29;
                }
                case 'u': {
                    builder.appendValue(WeekFields.of(DayOfWeek.MONDAY, 4).dayOfWeek(), 1);
                    continue block29;
                }
                case 'V': {
                    builder.appendValue(WeekFields.of(DayOfWeek.MONDAY, 4).weekOfYear(), 2);
                    continue block29;
                }
            }
            throw new ValueError("Invalid directive (" + directive + ") in format string (" + pattern + ").");
        }
        builder.appendLiteral(pattern.substring(endIndex));
        return builder.toFormatter();
    }
}

