/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.opcodes.descriptor;

import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.opcodes.Opcode;
import ai.timefold.jpyinterpreter.opcodes.collection.BuildConstantKeyMapOpcode;
import ai.timefold.jpyinterpreter.opcodes.collection.BuildListOpcode;
import ai.timefold.jpyinterpreter.opcodes.collection.BuildMapOpcode;
import ai.timefold.jpyinterpreter.opcodes.collection.BuildSetOpcode;
import ai.timefold.jpyinterpreter.opcodes.collection.BuildSliceOpcode;
import ai.timefold.jpyinterpreter.opcodes.collection.BuildTupleOpcode;
import ai.timefold.jpyinterpreter.opcodes.collection.CollectionAddAllOpcode;
import ai.timefold.jpyinterpreter.opcodes.collection.CollectionAddOpcode;
import ai.timefold.jpyinterpreter.opcodes.collection.ContainsOpcode;
import ai.timefold.jpyinterpreter.opcodes.collection.DeleteItemOpcode;
import ai.timefold.jpyinterpreter.opcodes.collection.GetIterOpcode;
import ai.timefold.jpyinterpreter.opcodes.collection.ListToTupleOpcode;
import ai.timefold.jpyinterpreter.opcodes.collection.MapMergeOpcode;
import ai.timefold.jpyinterpreter.opcodes.collection.MapPutAllOpcode;
import ai.timefold.jpyinterpreter.opcodes.collection.MapPutOpcode;
import ai.timefold.jpyinterpreter.opcodes.collection.SetItemOpcode;
import ai.timefold.jpyinterpreter.opcodes.collection.UnpackSequenceOpcode;
import ai.timefold.jpyinterpreter.opcodes.collection.UnpackSequenceWithTailOpcode;
import ai.timefold.jpyinterpreter.opcodes.descriptor.OpcodeDescriptor;
import ai.timefold.jpyinterpreter.opcodes.descriptor.VersionMapping;
import java.util.function.Function;

public enum CollectionOpDescriptor implements OpcodeDescriptor
{
    GET_ITER(GetIterOpcode::new),
    STORE_SUBSCR(SetItemOpcode::new),
    DELETE_SUBSCR(DeleteItemOpcode::new),
    CONTAINS_OP(ContainsOpcode::new),
    UNPACK_SEQUENCE(UnpackSequenceOpcode::new),
    UNPACK_EX(UnpackSequenceWithTailOpcode::new),
    BUILD_SLICE(BuildSliceOpcode::new),
    BUILD_TUPLE(BuildTupleOpcode::new),
    BUILD_LIST(BuildListOpcode::new),
    BUILD_SET(BuildSetOpcode::new),
    BUILD_MAP(BuildMapOpcode::new),
    BUILD_CONST_KEY_MAP(BuildConstantKeyMapOpcode::new),
    LIST_TO_TUPLE(ListToTupleOpcode::new),
    SET_ADD(CollectionAddOpcode::new),
    LIST_APPEND(CollectionAddOpcode::new),
    MAP_ADD(MapPutOpcode::new),
    LIST_EXTEND(CollectionAddAllOpcode::new),
    SET_UPDATE(CollectionAddAllOpcode::new),
    DICT_UPDATE(MapPutAllOpcode::new),
    DICT_MERGE(MapMergeOpcode::new);

    final VersionMapping versionLookup;

    private CollectionOpDescriptor(Function<PythonBytecodeInstruction, Opcode> instructionToOpcode) {
        this.versionLookup = VersionMapping.constantMapping(instructionToOpcode);
    }

    @Override
    public VersionMapping getVersionMapping() {
        return this.versionLookup;
    }
}

