/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.util;

import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.errors.ValueError;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultFormatSpec {
    static final String FILL = "(?<fill>.)?";
    static final String ALIGN = "(?:(?<fill>.)?(?<align>[<>=^]))?";
    static final String SIGN = "(?<sign>[+\\- ])?";
    static final String ALTERNATE_FORM = "(?<alternateForm>#)?";
    static final String SIGN_AWARE_ZERO_FILL = "(?<signAwareZeroFill>0)?";
    static final String WIDTH = "(?<width>\\d+)?";
    static final String GROUPING_OPTION = "(?<groupingOption>[_,])?";
    static final String PRECISION = "(?:\\.(?<precision>\\d+))?";
    static final String TYPE = "(?<type>[bcdeEfFgGnosxX%])?";
    static final String DEFAULT_FORMAT_SPEC = "(?:(?<fill>.)?(?<align>[<>=^]))?(?<sign>[+\\- ])?(?<alternateForm>#)?(?<signAwareZeroFill>0)?(?<width>\\d+)?(?<groupingOption>[_,])?(?:\\.(?<precision>\\d+))?(?<type>[bcdeEfFgGnosxX%])?";
    static final Pattern DEFAULT_FORMAT_SPEC_PATTERN = Pattern.compile("(?:(?<fill>.)?(?<align>[<>=^]))?(?<sign>[+\\- ])?(?<alternateForm>#)?(?<signAwareZeroFill>0)?(?<width>\\d+)?(?<groupingOption>[_,])?(?:\\.(?<precision>\\d+))?(?<type>[bcdeEfFgGnosxX%])?");
    public final String fillCharacter;
    public final boolean useAlternateForm;
    public final Optional<AlignmentOption> alignment;
    public final Optional<SignOption> signOption;
    public final Optional<Integer> width;
    public final Optional<GroupingOption> groupingOption;
    public final Optional<Integer> precision;
    public final Optional<ConversionType> conversionType;

    private DefaultFormatSpec(String fillCharacter, boolean useAlternateForm, Optional<AlignmentOption> alignment, Optional<SignOption> signOption, Optional<Integer> width, Optional<GroupingOption> groupingOption, Optional<Integer> precision, Optional<ConversionType> conversionType) {
        this.fillCharacter = fillCharacter;
        this.useAlternateForm = useAlternateForm;
        this.alignment = alignment;
        this.signOption = signOption;
        this.width = width;
        this.groupingOption = groupingOption;
        this.precision = precision;
        this.conversionType = conversionType;
    }

    public static DefaultFormatSpec fromSpec(PythonString formatSpec) {
        Matcher matcher = DEFAULT_FORMAT_SPEC_PATTERN.matcher(formatSpec.value);
        if (!matcher.matches()) {
            throw new ValueError("Invalid format spec: " + formatSpec.value);
        }
        Optional<String> signAwareZeroFill = Optional.ofNullable(matcher.group("signAwareZeroFill"));
        return new DefaultFormatSpec(Optional.ofNullable(matcher.group("fill")).or(() -> signAwareZeroFill).orElse(" "), Optional.ofNullable(matcher.group("alternateForm")).isPresent(), Optional.ofNullable(matcher.group("align")).map(AlignmentOption::fromString).or(() -> signAwareZeroFill.map(ignored -> AlignmentOption.RESPECT_SIGN_RIGHT_ALIGN)), Optional.ofNullable(matcher.group("sign")).map(SignOption::fromString), Optional.ofNullable(matcher.group("width")).map(Integer::parseInt), Optional.ofNullable(matcher.group("groupingOption")).map(GroupingOption::fromString), Optional.ofNullable(matcher.group("precision")).map(Integer::parseInt), Optional.ofNullable(matcher.group("type")).map(ConversionType::fromString));
    }

    public static DefaultFormatSpec fromStringSpec(PythonString formatSpec) {
        Matcher matcher = DEFAULT_FORMAT_SPEC_PATTERN.matcher(formatSpec.value);
        if (!matcher.matches()) {
            throw new ValueError("Invalid format spec: " + formatSpec.value);
        }
        Optional<String> signAwareZeroFill = Optional.ofNullable(matcher.group("signAwareZeroFill"));
        return new DefaultFormatSpec(Optional.ofNullable(matcher.group("fill")).or(() -> signAwareZeroFill).orElse(" "), Optional.ofNullable(matcher.group("alternateForm")).isPresent(), Optional.ofNullable(matcher.group("align")).map(AlignmentOption::fromString), Optional.ofNullable(matcher.group("sign")).map(SignOption::fromString), Optional.ofNullable(matcher.group("width")).map(Integer::parseInt), Optional.ofNullable(matcher.group("groupingOption")).map(GroupingOption::fromString), Optional.ofNullable(matcher.group("precision")).map(Integer::parseInt), Optional.ofNullable(matcher.group("type")).map(ConversionType::fromString));
    }

    public int getPrecisionOrDefault() {
        return this.precision.orElse(6);
    }

    public static enum AlignmentOption {
        LEFT_ALIGN("<"),
        RIGHT_ALIGN(">"),
        RESPECT_SIGN_RIGHT_ALIGN("="),
        CENTER_ALIGN("^");

        final String matchCharacter;

        private AlignmentOption(String matchCharacter) {
            this.matchCharacter = matchCharacter;
        }

        public static AlignmentOption fromString(String text) {
            for (AlignmentOption alignmentOption : AlignmentOption.values()) {
                if (!alignmentOption.matchCharacter.equals(text)) continue;
                return alignmentOption;
            }
            throw new IllegalArgumentException("\"" + text + "\" does not match any alignment option");
        }
    }

    public static enum ConversionType {
        STRING("s"),
        BINARY("b"),
        CHARACTER("c"),
        DECIMAL("d"),
        OCTAL("o"),
        LOWERCASE_HEX("x"),
        UPPERCASE_HEX("X"),
        LOWERCASE_SCIENTIFIC_NOTATION("e"),
        UPPERCASE_SCIENTIFIC_NOTATION("E"),
        LOWERCASE_FIXED_POINT("f"),
        UPPERCASE_FIXED_POINT("F"),
        LOWERCASE_GENERAL("g"),
        UPPERCASE_GENERAL("G"),
        LOCALE_SENSITIVE("n"),
        PERCENTAGE("%");

        final String matchCharacter;

        private ConversionType(String matchCharacter) {
            this.matchCharacter = matchCharacter;
        }

        public static ConversionType fromString(String text) {
            for (ConversionType conversionType : ConversionType.values()) {
                if (!conversionType.matchCharacter.equals(text)) continue;
                return conversionType;
            }
            throw new IllegalArgumentException("\"" + text + "\" does not match any conversion type");
        }
    }

    public static enum GroupingOption {
        COMMA(","),
        UNDERSCORE("_");

        final String matchCharacter;

        private GroupingOption(String matchCharacter) {
            this.matchCharacter = matchCharacter;
        }

        public static GroupingOption fromString(String text) {
            for (GroupingOption groupingOption : GroupingOption.values()) {
                if (!groupingOption.matchCharacter.equals(text)) continue;
                return groupingOption;
            }
            throw new IllegalArgumentException("\"" + text + "\" does not match any grouping option");
        }
    }

    public static enum SignOption {
        ALWAYS_SIGN("+"),
        ONLY_NEGATIVE_NUMBERS("-"),
        SPACE_FOR_POSITIVE_NUMBERS(" ");

        final String matchCharacter;

        private SignOption(String matchCharacter) {
            this.matchCharacter = matchCharacter;
        }

        public static SignOption fromString(String text) {
            for (SignOption signOption : SignOption.values()) {
                if (!signOption.matchCharacter.equals(text)) continue;
                return signOption;
            }
            throw new IllegalArgumentException("\"" + text + "\" does not match any sign option");
        }
    }
}

