/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.numeric;

import ai.timefold.jpyinterpreter.MethodDescriptor;
import ai.timefold.jpyinterpreter.PythonFunctionSignature;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.builtins.GlobalBuiltins;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeFunction;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonNone;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.errors.ValueError;
import ai.timefold.jpyinterpreter.types.numeric.PythonFloat;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PythonBoolean
extends PythonInteger {
    public static final PythonBoolean TRUE = new PythonBoolean(true);
    public static final PythonBoolean FALSE = new PythonBoolean(false);
    private final boolean booleanValue;

    public static PythonLikeType registerMethods() {
        try {
            BuiltinTypes.BOOLEAN_TYPE.addUnaryMethod(PythonUnaryOperator.AS_BOOLEAN, new PythonFunctionSignature(new MethodDescriptor(PythonBoolean.class.getMethod("asBoolean", new Class[0])), BuiltinTypes.BOOLEAN_TYPE, new PythonLikeType[0]));
            BuiltinTypes.BOOLEAN_TYPE.addUnaryMethod(PythonUnaryOperator.AS_STRING, new PythonFunctionSignature(new MethodDescriptor(PythonBoolean.class.getMethod("asString", new Class[0])), BuiltinTypes.STRING_TYPE, new PythonLikeType[0]));
            BuiltinTypes.BOOLEAN_TYPE.addUnaryMethod(PythonUnaryOperator.REPRESENTATION, new PythonFunctionSignature(new MethodDescriptor(PythonBoolean.class.getMethod("asString", new Class[0])), BuiltinTypes.STRING_TYPE, new PythonLikeType[0]));
            BuiltinTypes.BOOLEAN_TYPE.setConstructor((positionalArguments, namedArguments, callerInstance) -> {
                if (namedArguments.size() > 1) {
                    throw new ValueError("bool does not take named arguments");
                }
                if (positionalArguments.isEmpty()) {
                    return FALSE;
                }
                if (positionalArguments.size() == 1) {
                    return PythonBoolean.valueOf(PythonBoolean.isTruthful((PythonLikeObject)positionalArguments.get(0)));
                }
                throw new ValueError("bool expects 0 or 1 arguments, got " + positionalArguments.size());
            });
            GlobalBuiltins.addBuiltinConstant("True", TRUE);
            GlobalBuiltins.addBuiltinConstant("False", FALSE);
            return BuiltinTypes.BOOLEAN_TYPE;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private PythonBoolean(boolean booleanValue) {
        super(BuiltinTypes.BOOLEAN_TYPE, booleanValue ? BigInteger.ONE : BigInteger.ZERO);
        this.booleanValue = booleanValue;
    }

    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    public PythonBoolean not() {
        if (this == TRUE) {
            return FALSE;
        }
        return TRUE;
    }

    public static boolean isTruthful(PythonLikeObject tested) {
        if (tested instanceof PythonBoolean) {
            return tested == TRUE;
        }
        if (tested instanceof PythonInteger) {
            return ((PythonInteger)tested).asBoolean() == TRUE;
        }
        if (tested instanceof PythonFloat) {
            return ((PythonFloat)tested).asBoolean() == TRUE;
        }
        if (tested instanceof PythonNone) {
            return false;
        }
        if (tested instanceof Collection) {
            return ((Collection)((Object)tested)).size() == 0;
        }
        if (tested instanceof Map) {
            return ((Map)((Object)tested)).size() == 0;
        }
        PythonLikeType testedType = tested.$getType();
        PythonLikeFunction boolMethod = (PythonLikeFunction)testedType.$getAttributeOrNull("__bool__");
        if (boolMethod != null) {
            return PythonBoolean.isTruthful(boolMethod.$call(List.of(tested), Map.of(), null));
        }
        PythonLikeFunction lenMethod = (PythonLikeFunction)testedType.$getAttributeOrNull("__len__");
        if (lenMethod != null) {
            return PythonBoolean.isTruthful(lenMethod.$call(List.of(tested), Map.of(), null));
        }
        return true;
    }

    @Override
    public PythonBoolean asBoolean() {
        return this;
    }

    public static PythonBoolean valueOf(boolean result) {
        return result ? TRUE : FALSE;
    }

    @Override
    public PythonLikeType $getType() {
        return BuiltinTypes.BOOLEAN_TYPE;
    }

    @Override
    public PythonString $method$__str__() {
        return PythonString.valueOf(this.toString());
    }

    @Override
    public String toString() {
        if (this == TRUE) {
            return "True";
        }
        return "False";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PythonBoolean that = (PythonBoolean)o;
        return this.booleanValue == that.booleanValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.booleanValue);
    }

    @Override
    public PythonString asString() {
        return PythonString.valueOf(this.toString());
    }

    static {
        PythonOverloadImplementor.deferDispatchesFor(PythonBoolean::registerMethods);
    }
}

