/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.errors;

import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonNone;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.types.wrappers.JavaObjectWrapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PythonBaseException
extends RuntimeException
implements PythonLikeObject {
    public static final PythonLikeType BASE_EXCEPTION_TYPE;
    public static final PythonLikeType $TYPE;
    Map<String, PythonLikeObject> dict;
    final PythonLikeType type;
    final List<PythonLikeObject> args;

    private static String getMessageFromArgs(List<PythonLikeObject> args) {
        if (args.size() < 1) {
            return null;
        }
        if (args.get(0) instanceof PythonString) {
            return ((PythonString)args.get(0)).getValue();
        }
        return null;
    }

    public PythonBaseException(PythonLikeType type) {
        this(type, Collections.emptyList());
    }

    public PythonBaseException(PythonLikeType type, List<PythonLikeObject> args) {
        super(PythonBaseException.getMessageFromArgs(args));
        this.type = type;
        this.args = args;
        this.dict = new HashMap<String, PythonLikeObject>();
        this.$setAttribute("args", PythonLikeTuple.fromList(args));
        this.$setAttribute("__cause__", PythonNone.INSTANCE);
    }

    public PythonBaseException(PythonLikeType type, String message) {
        super(message);
        this.type = type;
        this.args = List.of(PythonString.valueOf(message));
        this.dict = new HashMap<String, PythonLikeObject>();
        this.$setAttribute("args", PythonLikeTuple.fromList(this.args));
        this.$setAttribute("__cause__", PythonNone.INSTANCE);
    }

    @Override
    public synchronized Throwable initCause(Throwable cause) {
        super.initCause(cause);
        if (cause instanceof PythonLikeObject) {
            PythonLikeObject pythonError = (PythonLikeObject)((Object)cause);
            this.$setAttribute("__cause__", pythonError);
        } else {
            this.$setAttribute("__cause__", new JavaObjectWrapper(cause));
        }
        return this;
    }

    @Override
    public PythonLikeObject $getAttributeOrNull(String attributeName) {
        return this.dict.get(attributeName);
    }

    @Override
    public void $setAttribute(String attributeName, PythonLikeObject value) {
        this.dict.put(attributeName, value);
    }

    @Override
    public void $deleteAttribute(String attributeName) {
        this.dict.remove(attributeName);
    }

    public PythonLikeTuple $getArgs() {
        return (PythonLikeTuple)this.$getAttributeOrError("args");
    }

    @Override
    public PythonLikeType $getType() {
        return this.type;
    }

    static {
        $TYPE = BASE_EXCEPTION_TYPE = new PythonLikeType("BaseException", PythonBaseException.class);
        BASE_EXCEPTION_TYPE.setConstructor((positionalArguments, namedArguments, callerInstance) -> new PythonBaseException(BASE_EXCEPTION_TYPE, positionalArguments));
    }
}

