/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.opcodes.variable;

import ai.timefold.jpyinterpreter.FunctionMetadata;
import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.StackMetadata;
import ai.timefold.jpyinterpreter.ValueSourceInfo;
import ai.timefold.jpyinterpreter.implementors.PythonConstantsImplementor;
import ai.timefold.jpyinterpreter.opcodes.AbstractOpcode;
import ai.timefold.jpyinterpreter.opcodes.Opcode;
import ai.timefold.jpyinterpreter.types.PythonLikeType;

public class LoadConstantOpcode
extends AbstractOpcode {
    public LoadConstantOpcode(PythonBytecodeInstruction instruction) {
        super(instruction);
    }

    @Override
    protected StackMetadata getStackMetadataAfterInstruction(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        PythonLikeObject constant = functionMetadata.pythonCompiledFunction.co_constants.get(this.instruction.arg());
        PythonLikeType constantType = constant.$getGenericType();
        return stackMetadata.push(ValueSourceInfo.of((Opcode)this, constantType, new ValueSourceInfo[0]));
    }

    @Override
    public void implement(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        PythonLikeObject constant = functionMetadata.pythonCompiledFunction.co_constants.get(this.instruction.arg());
        PythonLikeType constantType = constant.$getGenericType();
        PythonConstantsImplementor.loadConstant(functionMetadata.methodVisitor, functionMetadata.className, this.instruction.arg());
        functionMetadata.methodVisitor.visitTypeInsn(192, constantType.getJavaTypeInternalName());
    }
}

