/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.opcodes;

import ai.timefold.jpyinterpreter.FunctionMetadata;
import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.PythonVersion;
import ai.timefold.jpyinterpreter.StackMetadata;
import ai.timefold.jpyinterpreter.opcodes.AbstractOpcode;
import java.util.List;

public interface Opcode {
    public int getBytecodeIndex();

    default public List<Integer> getPossibleNextBytecodeIndexList() {
        return List.of(Integer.valueOf(this.getBytecodeIndex() + 1));
    }

    public List<StackMetadata> getStackMetadataAfterInstructionForBranches(FunctionMetadata var1, StackMetadata var2);

    public void implement(FunctionMetadata var1, StackMetadata var2);

    public boolean isJumpTarget();

    default public boolean isForcedJump() {
        return false;
    }

    public static Opcode lookupOpcodeForInstruction(PythonBytecodeInstruction instruction, PythonVersion pythonVersion) {
        return AbstractOpcode.lookupInstruction(instruction.opname()).getVersionMapping().getOpcodeForVersion(instruction, pythonVersion);
    }
}

