/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.opcodes.dunder.BinaryDunderOpcode;
import java.util.Optional;

public enum PythonBinaryOperator {
    LESS_THAN("<", "__lt__", "__gt__", true),
    LESS_THAN_OR_EQUAL("<=", "__le__", "__ge__", true),
    GREATER_THAN(">", "__gt__", "__lt__", true),
    GREATER_THAN_OR_EQUAL(">=", "__ge__", "__le__", true),
    EQUAL("==", "__eq__", "__eq__", true),
    NOT_EQUAL("!=", "__ne__", "__ne__", true),
    POWER("**", "__pow__", "__rpow__"),
    MULTIPLY("*", "__mul__", "__rmul__"),
    MATRIX_MULTIPLY("@", "__matmul__", "__rmatmul__"),
    FLOOR_DIVIDE("//", "__floordiv__", "__rfloordiv__"),
    TRUE_DIVIDE("/", "__truediv__", "__rtruediv__"),
    MODULO("%", "__mod__", "__rmod__"),
    ADD("+", "__add__", "__radd__"),
    SUBTRACT("-", "__sub__", "__rsub__"),
    LSHIFT("<<", "__lshift__", "__rlshift__"),
    RSHIFT(">>", "__rshift__", "__rrshift__"),
    AND("&", "__and__", "__rand__"),
    XOR("^", "__xor__", "__rxor__"),
    OR("|", "__or__", "__ror__"),
    INPLACE_POWER("**=", "__ipow__", POWER),
    INPLACE_MULTIPLY("*=", "__imul__", MULTIPLY),
    INPLACE_MATRIX_MULTIPLY("@=", "__imatmul__", MATRIX_MULTIPLY),
    INPLACE_FLOOR_DIVIDE("//=", "__ifloordiv__", FLOOR_DIVIDE),
    INPLACE_TRUE_DIVIDE("/=", "__itruediv__", TRUE_DIVIDE),
    INPLACE_MODULO("%=", "__imod__", MODULO),
    INPLACE_ADD("+=", "__iadd__", ADD),
    INPLACE_SUBTRACT("-=", "__isub__", SUBTRACT),
    INPLACE_LSHIFT("<<=", "__ilshift__", LSHIFT),
    INPLACE_RSHIFT(">>=", "__irshift__", RSHIFT),
    INPLACE_AND("&=", "__iand__", AND),
    INPLACE_XOR("^=", "__ixor__", XOR),
    INPLACE_OR("|=", "__ior__", OR),
    GET_ITEM("", "__getitem__"),
    DELETE_ITEM("", "__delitem__"),
    SEND("", "send"),
    THROW("", "throw"),
    CONTAINS("", "__contains__"),
    DELETE("", "__delete__"),
    GET_ATTRIBUTE("", "__getattribute__"),
    GET_ATTRIBUTE_NOT_IN_SLOTS("", "__getattr__"),
    DELETE_ATTRIBUTE("", "__delattr__"),
    FORMAT("", "__format__"),
    DIVMOD("", "__divmod__");

    public final String operatorSymbol;
    public final String dunderMethod;
    public final String rightDunderMethod;
    public final boolean isComparisonMethod;
    public final PythonBinaryOperator fallbackOperation;

    private PythonBinaryOperator(String operatorSymbol, String dunderMethod) {
        this.operatorSymbol = operatorSymbol;
        this.dunderMethod = dunderMethod;
        this.rightDunderMethod = null;
        this.isComparisonMethod = false;
        this.fallbackOperation = null;
    }

    private PythonBinaryOperator(String operatorSymbol, String dunderMethod, String rightDunderMethod) {
        this.operatorSymbol = operatorSymbol;
        this.dunderMethod = dunderMethod;
        this.rightDunderMethod = rightDunderMethod;
        this.isComparisonMethod = false;
        this.fallbackOperation = null;
    }

    private PythonBinaryOperator(String operatorSymbol, String dunderMethod, String rightDunderMethod, boolean isComparisonMethod) {
        this.operatorSymbol = operatorSymbol;
        this.dunderMethod = dunderMethod;
        this.rightDunderMethod = rightDunderMethod;
        this.isComparisonMethod = isComparisonMethod;
        this.fallbackOperation = null;
    }

    private PythonBinaryOperator(String operatorSymbol, String dunderMethod, PythonBinaryOperator fallbackOperation) {
        this.operatorSymbol = operatorSymbol;
        this.dunderMethod = dunderMethod;
        this.rightDunderMethod = null;
        this.isComparisonMethod = false;
        this.fallbackOperation = fallbackOperation;
    }

    public String getOperatorSymbol() {
        return this.operatorSymbol;
    }

    public String getDunderMethod() {
        return this.dunderMethod;
    }

    public String getRightDunderMethod() {
        return this.rightDunderMethod;
    }

    public boolean hasRightDunderMethod() {
        return this.rightDunderMethod != null;
    }

    public boolean isComparisonMethod() {
        return this.isComparisonMethod;
    }

    public Optional<PythonBinaryOperator> getFallbackOperation() {
        return Optional.ofNullable(this.fallbackOperation);
    }

    public static BinaryDunderOpcode getBinaryOpcode(PythonBytecodeInstruction instruction) {
        return new BinaryDunderOpcode(instruction, switch (instruction.arg()) {
            case 0 -> ADD;
            case 1 -> AND;
            case 2 -> FLOOR_DIVIDE;
            case 3 -> LSHIFT;
            case 4 -> MATRIX_MULTIPLY;
            case 5 -> MULTIPLY;
            case 6 -> MODULO;
            case 7 -> OR;
            case 8 -> POWER;
            case 9 -> RSHIFT;
            case 10 -> SUBTRACT;
            case 11 -> TRUE_DIVIDE;
            case 12 -> XOR;
            case 13 -> INPLACE_ADD;
            case 14 -> INPLACE_AND;
            case 15 -> INPLACE_FLOOR_DIVIDE;
            case 16 -> INPLACE_LSHIFT;
            case 17 -> INPLACE_MATRIX_MULTIPLY;
            case 18 -> INPLACE_MULTIPLY;
            case 19 -> INPLACE_MODULO;
            case 20 -> INPLACE_OR;
            case 21 -> INPLACE_POWER;
            case 22 -> INPLACE_RSHIFT;
            case 23 -> INPLACE_SUBTRACT;
            case 24 -> INPLACE_TRUE_DIVIDE;
            case 25 -> INPLACE_XOR;
            default -> throw new IllegalArgumentException("Unknown binary op id: " + instruction.arg());
        });
    }
}

