/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class BytecodeSwitchImplementor {
    public static void createStringSwitch(MethodVisitor methodVisitor, Collection<String> keyNames, int switchVariable, Consumer<String> caseWriter, Runnable defaultCase, boolean doesEachCaseReturnEarly) {
        int i;
        if (keyNames.isEmpty()) {
            defaultCase.run();
            return;
        }
        TreeMap<Integer, List> hashCodeToMatchingFieldList = new TreeMap<Integer, List>();
        for (String fieldName : keyNames) {
            hashCodeToMatchingFieldList.computeIfAbsent(fieldName.hashCode(), hash -> new ArrayList()).add(fieldName);
        }
        int[] keys = new int[hashCodeToMatchingFieldList.size()];
        Label[] hashCodeLabels = new Label[keys.length];
        int keyIndex = 0;
        for (Integer key : hashCodeToMatchingFieldList.keySet()) {
            keys[keyIndex] = key;
            hashCodeLabels[keyIndex] = new Label();
            ++keyIndex;
        }
        int TOS_VARIABLE = switchVariable;
        int CASE_VARIABLE = TOS_VARIABLE + 1;
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(58, TOS_VARIABLE);
        methodVisitor.visitMethodInsn(182, Type.getInternalName(String.class), "hashCode", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), false);
        HashMap<Integer, String> switchVariableValueToField = new HashMap<Integer, String>();
        Label endOfKeySwitch = new Label();
        methodVisitor.visitLdcInsn((Object)-1);
        methodVisitor.visitVarInsn(54, CASE_VARIABLE);
        methodVisitor.visitLookupSwitchInsn(endOfKeySwitch, keys, hashCodeLabels);
        int totalEntries = 0;
        for (int i2 = 0; i2 < keys.length; ++i2) {
            methodVisitor.visitLabel(hashCodeLabels[i2]);
            List matchingFields = (List)hashCodeToMatchingFieldList.get(keys[i2]);
            for (int fieldIndex = 0; fieldIndex < matchingFields.size(); ++fieldIndex) {
                String field = (String)matchingFields.get(fieldIndex);
                Label ifDoesNotMatchLabel = new Label();
                methodVisitor.visitVarInsn(25, TOS_VARIABLE);
                methodVisitor.visitLdcInsn((Object)field);
                methodVisitor.visitMethodInsn(182, Type.getInternalName(String.class), "equals", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(Object.class)}), false);
                if (fieldIndex != matchingFields.size() - 1) {
                    methodVisitor.visitJumpInsn(153, ifDoesNotMatchLabel);
                } else {
                    methodVisitor.visitJumpInsn(153, endOfKeySwitch);
                }
                methodVisitor.visitLdcInsn((Object)totalEntries);
                methodVisitor.visitVarInsn(54, CASE_VARIABLE);
                if (fieldIndex != matchingFields.size() - 1) {
                    methodVisitor.visitJumpInsn(167, endOfKeySwitch);
                    methodVisitor.visitLabel(ifDoesNotMatchLabel);
                }
                switchVariableValueToField.put(totalEntries, field);
                ++totalEntries;
            }
            if (totalEntries == keyNames.size()) continue;
            methodVisitor.visitJumpInsn(167, endOfKeySwitch);
        }
        methodVisitor.visitLabel(endOfKeySwitch);
        Label missingField = new Label();
        Label endOfFieldsSwitch = new Label();
        Label[] fieldHandlerLabels = new Label[totalEntries];
        for (i = 0; i < fieldHandlerLabels.length; ++i) {
            fieldHandlerLabels[i] = new Label();
        }
        methodVisitor.visitVarInsn(21, CASE_VARIABLE);
        methodVisitor.visitTableSwitchInsn(0, totalEntries - 1, missingField, fieldHandlerLabels);
        for (i = 0; i < totalEntries; ++i) {
            methodVisitor.visitLabel(fieldHandlerLabels[i]);
            String field = (String)switchVariableValueToField.get(i);
            caseWriter.accept(field);
            if (doesEachCaseReturnEarly) continue;
            methodVisitor.visitJumpInsn(167, endOfFieldsSwitch);
        }
        methodVisitor.visitLabel(missingField);
        defaultCase.run();
        if (!doesEachCaseReturnEarly) {
            methodVisitor.visitLabel(endOfFieldsSwitch);
        }
    }

    public static void createIntSwitch(MethodVisitor methodVisitor, Collection<Integer> keySet, Consumer<Integer> caseWriter, Runnable defaultCase, boolean doesEachCaseReturnEarly) {
        if (keySet.isEmpty()) {
            defaultCase.run();
            return;
        }
        List sortedKeyList = keySet.stream().sorted().collect(Collectors.toList());
        int[] keys = new int[sortedKeyList.size()];
        Label[] keyLabels = new Label[keys.length];
        int keyIndex = 0;
        for (Integer key : sortedKeyList) {
            keys[keyIndex] = key;
            keyLabels[keyIndex] = new Label();
            ++keyIndex;
        }
        Label endOfKeySwitch = new Label();
        Label missingKey = new Label();
        methodVisitor.visitLookupSwitchInsn(missingKey, keys, keyLabels);
        for (int i = 0; i < keys.length; ++i) {
            methodVisitor.visitLabel(keyLabels[i]);
            Integer matchingKey = (Integer)sortedKeyList.get(i);
            caseWriter.accept(matchingKey);
            if (doesEachCaseReturnEarly) continue;
            methodVisitor.visitJumpInsn(167, endOfKeySwitch);
        }
        methodVisitor.visitLabel(missingKey);
        defaultCase.run();
        if (!doesEachCaseReturnEarly) {
            methodVisitor.visitLabel(endOfKeySwitch);
        }
    }
}

