/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.util;

import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.types.PythonString;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.OrderedMap;
import org.apache.commons.collections4.OrderedMapIterator;

public class JavaStringMapMirror
implements OrderedMap<PythonLikeObject, PythonLikeObject> {
    final Map<String, PythonLikeObject> delegate;

    public JavaStringMapMirror(Map<String, PythonLikeObject> delegate) {
        this.delegate = delegate;
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean containsKey(Object o) {
        return o instanceof PythonString && this.delegate.containsKey(((PythonString)o).value);
    }

    public boolean containsValue(Object o) {
        return this.delegate.containsValue(o);
    }

    public PythonLikeObject get(Object o) {
        if (o instanceof PythonString) {
            return this.delegate.get(((PythonString)o).value);
        }
        return null;
    }

    public PythonLikeObject put(PythonLikeObject key, PythonLikeObject value) {
        if (key instanceof PythonString) {
            return this.delegate.put(((PythonString)key).value, value);
        }
        throw new IllegalArgumentException();
    }

    public PythonLikeObject remove(Object o) {
        if (o instanceof PythonString) {
            return this.delegate.remove(((PythonString)o).value);
        }
        return this.delegate.remove(o);
    }

    public void putAll(Map<? extends PythonLikeObject, ? extends PythonLikeObject> map) {
        map.forEach(this::put);
    }

    public void clear() {
        this.delegate.clear();
    }

    public Set<PythonLikeObject> keySet() {
        return this.delegate.keySet().stream().map(PythonString::valueOf).collect(Collectors.toSet());
    }

    public Collection<PythonLikeObject> values() {
        return this.delegate.values();
    }

    public Set<Map.Entry<PythonLikeObject, PythonLikeObject>> entrySet() {
        return this.delegate.entrySet().stream().map(entry -> new Map.Entry<PythonLikeObject, PythonLikeObject>(){

            @Override
            public PythonLikeObject getKey() {
                return PythonString.valueOf((String)entry.getKey());
            }

            @Override
            public PythonLikeObject getValue() {
                return (PythonLikeObject)entry.getValue();
            }

            @Override
            public PythonLikeObject setValue(PythonLikeObject o) {
                return entry.setValue(o);
            }
        }).collect(Collectors.toSet());
    }

    public OrderedMapIterator<PythonLikeObject, PythonLikeObject> mapIterator() {
        throw new UnsupportedOperationException("mapIterator is not supported");
    }

    public PythonLikeObject firstKey() {
        if (this.delegate.isEmpty()) {
            throw new NoSuchElementException("Map is empty");
        }
        return PythonString.valueOf(this.delegate.keySet().iterator().next());
    }

    public PythonLikeObject lastKey() {
        if (this.delegate.isEmpty()) {
            throw new NoSuchElementException("Map is empty");
        }
        String lastKey = null;
        Iterator<String> iterator = this.delegate.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            lastKey = key = iterator.next();
        }
        return PythonString.valueOf(lastKey);
    }

    public PythonLikeObject nextKey(PythonLikeObject object) {
        boolean returnNextKey = false;
        for (String key : this.delegate.keySet()) {
            if (key.equals(object.toString())) {
                returnNextKey = true;
            }
            if (!returnNextKey) continue;
            return PythonString.valueOf(key);
        }
        return null;
    }

    public PythonLikeObject previousKey(PythonLikeObject object) {
        String previousKey = null;
        for (String key : this.delegate.keySet()) {
            if (key.equals(object.toString())) {
                return PythonString.valueOf(previousKey);
            }
            previousKey = key;
        }
        return null;
    }
}

