/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.datetime;

import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.types.AbstractPythonLikeObject;
import ai.timefold.jpyinterpreter.types.PythonLikeComparable;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.errors.ValueError;
import ai.timefold.jpyinterpreter.types.errors.arithmetic.ZeroDivisionError;
import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonFloat;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import ai.timefold.jpyinterpreter.types.numeric.PythonNumber;
import ai.timefold.jpyinterpreter.util.arguments.ArgumentSpec;
import ai.timefold.solver.core.impl.domain.solution.cloner.PlanningImmutable;
import java.math.BigInteger;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

public class PythonTimeDelta
extends AbstractPythonLikeObject
implements PythonLikeComparable<PythonTimeDelta>,
PlanningImmutable {
    private static final int NANOS_IN_SECOND = 1000000000;
    private static final int SECONDS_IN_DAY = 86400;
    public static PythonLikeType TIME_DELTA_TYPE;
    public static PythonLikeType $TYPE;
    final Duration duration;
    public final PythonInteger days;
    public final PythonInteger seconds;
    public final PythonInteger microseconds;

    private static void registerMethods() throws NoSuchMethodException {
        TIME_DELTA_TYPE.addConstructor(ArgumentSpec.forFunctionReturning("timedelta", PythonTimeDelta.class.getName()).addArgument("days", PythonNumber.class.getName(), PythonInteger.ZERO).addArgument("seconds", PythonNumber.class.getName(), PythonInteger.ZERO).addArgument("microseconds", PythonNumber.class.getName(), PythonInteger.ZERO).addArgument("milliseconds", PythonNumber.class.getName(), PythonInteger.ZERO).addArgument("minutes", PythonNumber.class.getName(), PythonInteger.ZERO).addArgument("hours", PythonNumber.class.getName(), PythonInteger.ZERO).addArgument("weeks", PythonNumber.class.getName(), PythonInteger.ZERO).asPythonFunctionSignature(PythonTimeDelta.class.getMethod("of", PythonNumber.class, PythonNumber.class, PythonNumber.class, PythonNumber.class, PythonNumber.class, PythonNumber.class, PythonNumber.class)));
        TIME_DELTA_TYPE.addUnaryMethod(PythonUnaryOperator.POSITIVE, PythonTimeDelta.class.getMethod("pos", new Class[0]));
        TIME_DELTA_TYPE.addUnaryMethod(PythonUnaryOperator.NEGATIVE, PythonTimeDelta.class.getMethod("negate", new Class[0]));
        TIME_DELTA_TYPE.addUnaryMethod(PythonUnaryOperator.ABS, PythonTimeDelta.class.getMethod("abs", new Class[0]));
        TIME_DELTA_TYPE.addUnaryMethod(PythonUnaryOperator.AS_BOOLEAN, PythonTimeDelta.class.getMethod("isZero", new Class[0]));
        TIME_DELTA_TYPE.addUnaryMethod(PythonUnaryOperator.AS_STRING, PythonTimeDelta.class.getMethod("toPythonString", new Class[0]));
        TIME_DELTA_TYPE.addUnaryMethod(PythonUnaryOperator.REPRESENTATION, PythonTimeDelta.class.getMethod("toPythonRepr", new Class[0]));
        TIME_DELTA_TYPE.addBinaryMethod(PythonBinaryOperator.ADD, PythonTimeDelta.class.getMethod("add_time_delta", PythonTimeDelta.class));
        TIME_DELTA_TYPE.addBinaryMethod(PythonBinaryOperator.SUBTRACT, PythonTimeDelta.class.getMethod("subtract_time_delta", PythonTimeDelta.class));
        TIME_DELTA_TYPE.addBinaryMethod(PythonBinaryOperator.MULTIPLY, PythonTimeDelta.class.getMethod("get_integer_multiple", PythonInteger.class));
        TIME_DELTA_TYPE.addBinaryMethod(PythonBinaryOperator.MULTIPLY, PythonTimeDelta.class.getMethod("get_float_multiple", PythonFloat.class));
        TIME_DELTA_TYPE.addBinaryMethod(PythonBinaryOperator.TRUE_DIVIDE, PythonTimeDelta.class.getMethod("divide_time_delta", PythonTimeDelta.class));
        TIME_DELTA_TYPE.addBinaryMethod(PythonBinaryOperator.TRUE_DIVIDE, PythonTimeDelta.class.getMethod("divide_integer", PythonInteger.class));
        TIME_DELTA_TYPE.addBinaryMethod(PythonBinaryOperator.TRUE_DIVIDE, PythonTimeDelta.class.getMethod("divide_float", PythonFloat.class));
        TIME_DELTA_TYPE.addBinaryMethod(PythonBinaryOperator.FLOOR_DIVIDE, PythonTimeDelta.class.getMethod("floor_divide_time_delta", PythonTimeDelta.class));
        TIME_DELTA_TYPE.addBinaryMethod(PythonBinaryOperator.FLOOR_DIVIDE, PythonTimeDelta.class.getMethod("floor_divide_integer", PythonInteger.class));
        TIME_DELTA_TYPE.addBinaryMethod(PythonBinaryOperator.MODULO, PythonTimeDelta.class.getMethod("remainder_time_delta", PythonTimeDelta.class));
        TIME_DELTA_TYPE.addMethod("total_seconds", PythonTimeDelta.class.getMethod("total_seconds", new Class[0]));
    }

    public PythonTimeDelta(Duration duration) {
        super(TIME_DELTA_TYPE);
        this.duration = duration;
        if (duration.isNegative()) {
            if (duration.getSeconds() % 86400L != 0L || duration.getNano() != 0) {
                this.days = PythonInteger.valueOf(duration.toDays() - 1L);
                this.seconds = PythonInteger.valueOf(86400L + duration.toSeconds() % 86400L % 86400L);
            } else {
                this.days = PythonInteger.valueOf(duration.toDays());
                this.seconds = PythonInteger.valueOf(Math.abs(duration.toSeconds() % 86400L));
            }
        } else {
            this.days = PythonInteger.valueOf(duration.toDays());
            this.seconds = PythonInteger.valueOf(Math.abs(duration.toSeconds() % 86400L));
        }
        this.microseconds = PythonInteger.valueOf(duration.toNanosPart() / 1000);
    }

    @Override
    public PythonLikeObject $getAttributeOrNull(String name) {
        switch (name) {
            case "days": {
                return this.days;
            }
            case "seconds": {
                return this.seconds;
            }
            case "microseconds": {
                return this.microseconds;
            }
        }
        return super.$getAttributeOrNull(name);
    }

    public static PythonTimeDelta of(int days, int seconds, int microseconds) {
        return new PythonTimeDelta(Duration.ofDays(days).plusSeconds(seconds).plusNanos((long)microseconds * 1000L));
    }

    public static PythonTimeDelta of(PythonNumber days, PythonNumber seconds, PythonNumber microseconds, PythonNumber milliseconds, PythonNumber minutes, PythonNumber hours, PythonNumber weeks) {
        Duration out = Duration.ZERO;
        out = PythonTimeDelta.addToDuration(out, days, ChronoUnit.DAYS);
        out = PythonTimeDelta.addToDuration(out, seconds, ChronoUnit.SECONDS);
        out = PythonTimeDelta.addToDuration(out, microseconds, ChronoUnit.MICROS);
        out = PythonTimeDelta.addToDuration(out, milliseconds, ChronoUnit.MILLIS);
        out = PythonTimeDelta.addToDuration(out, minutes, ChronoUnit.MINUTES);
        out = PythonTimeDelta.addToDuration(out, hours, ChronoUnit.HOURS);
        if (weeks instanceof PythonInteger) {
            out = out.plusDays(weeks.getValue().longValue() * 7L);
        } else if (weeks instanceof PythonFloat) {
            out = out.plusNanos(Math.round((double)Duration.ofDays(7L).toNanos() * weeks.getValue().doubleValue()));
        } else {
            throw new ValueError("Amount for weeks is not a float or integer.");
        }
        return new PythonTimeDelta(out);
    }

    private static Duration addToDuration(Duration duration, PythonNumber amount, TemporalUnit temporalUnit) {
        if (amount instanceof PythonInteger) {
            return duration.plus(amount.getValue().longValue(), temporalUnit);
        }
        if (amount instanceof PythonFloat) {
            return duration.plusNanos(Math.round((double)temporalUnit.getDuration().toNanos() * amount.getValue().doubleValue()));
        }
        throw new IllegalArgumentException("Amount for " + temporalUnit.toString() + " is not a float or integer.");
    }

    public PythonFloat total_seconds() {
        return PythonFloat.valueOf((double)this.duration.toNanos() / 1.0E9);
    }

    public PythonTimeDelta add_time_delta(PythonTimeDelta other) {
        return new PythonTimeDelta(this.duration.plus(other.duration));
    }

    public PythonTimeDelta subtract_time_delta(PythonTimeDelta other) {
        return new PythonTimeDelta(this.duration.minus(other.duration));
    }

    public PythonTimeDelta get_integer_multiple(PythonInteger multiple) {
        return new PythonTimeDelta(this.duration.multipliedBy(multiple.getValue().longValue()));
    }

    public PythonTimeDelta get_float_multiple(PythonFloat multiple) {
        double multipleAsDouble = multiple.getValue().doubleValue();
        long flooredMultiple = (long)Math.floor(multipleAsDouble);
        double fractionalPart = multipleAsDouble - (double)flooredMultiple;
        long nanos = this.duration.toNanos();
        double fractionalNanos = fractionalPart * (double)nanos;
        long fractionalNanosInMicroResolution = Math.round(fractionalNanos / 1000.0) * 1000L;
        return new PythonTimeDelta(this.duration.multipliedBy(flooredMultiple).plus(Duration.ofNanos(fractionalNanosInMicroResolution)));
    }

    public PythonFloat divide_time_delta(PythonTimeDelta divisor) {
        if (divisor.duration.equals(Duration.ZERO)) {
            throw new ZeroDivisionError("timedelta division or modulo by zero");
        }
        return PythonFloat.valueOf((double)this.duration.toNanos() / (double)divisor.duration.toNanos());
    }

    public PythonTimeDelta divide_integer(PythonInteger divisor) {
        if (divisor.value.equals(BigInteger.ZERO)) {
            throw new ZeroDivisionError("timedelta division or modulo by zero");
        }
        return new PythonTimeDelta(this.duration.dividedBy(divisor.getValue().longValue()));
    }

    public PythonTimeDelta divide_float(PythonFloat divisor) {
        if (divisor.value == 0.0) {
            throw new ZeroDivisionError("timedelta division or modulo by zero");
        }
        double fractionalNanos = (double)this.duration.toNanos() / divisor.getValue().doubleValue();
        return new PythonTimeDelta(Duration.ofNanos(Math.round(fractionalNanos / 1000.0) * 1000L));
    }

    public PythonInteger floor_divide_time_delta(PythonTimeDelta divisor) {
        if (divisor.duration.equals(Duration.ZERO)) {
            throw new ZeroDivisionError("timedelta division or modulo by zero");
        }
        long amount = this.duration.dividedBy(divisor.duration);
        if (divisor.duration.multipliedBy(amount).equals(this.duration)) {
            return PythonInteger.valueOf(amount);
        }
        if (this.duration.isNegative() == divisor.duration.isNegative()) {
            return PythonInteger.valueOf(amount);
        }
        return PythonInteger.valueOf(amount - 1L);
    }

    public PythonTimeDelta floor_divide_integer(PythonInteger divisor) {
        if (divisor.value.equals(BigInteger.ZERO)) {
            throw new ZeroDivisionError("timedelta division or modulo by zero");
        }
        return new PythonTimeDelta(this.duration.dividedBy(divisor.getValue().longValue()));
    }

    public PythonTimeDelta remainder_time_delta(PythonTimeDelta divisor) {
        boolean leftIsNegative = this.duration.isNegative();
        int rightHandSign = divisor.duration.compareTo(Duration.ZERO);
        if (rightHandSign == 0) {
            throw new ZeroDivisionError("timedelta division or modulo by zero");
        }
        long floorDivisionResult = this.duration.abs().dividedBy(divisor.abs().duration);
        Duration remainder = rightHandSign > 0 ? (leftIsNegative ? divisor.duration.plus(this.duration.plus(divisor.duration.multipliedBy(floorDivisionResult))) : this.duration.minus(divisor.duration.multipliedBy(floorDivisionResult))) : (leftIsNegative ? this.duration.minus(divisor.duration.multipliedBy(floorDivisionResult)) : divisor.duration.plus(this.duration.plus(divisor.duration.multipliedBy(floorDivisionResult))));
        return new PythonTimeDelta(remainder);
    }

    public PythonTimeDelta pos() {
        return this;
    }

    public PythonTimeDelta negate() {
        return new PythonTimeDelta(this.duration.negated());
    }

    public PythonTimeDelta abs() {
        return new PythonTimeDelta(this.duration.abs());
    }

    public PythonString toPythonString() {
        return new PythonString(this.toString());
    }

    public PythonString toPythonRepr() {
        StringBuilder out = new StringBuilder("datetime.timedelta(");
        if (!this.days.value.equals(BigInteger.ZERO)) {
            out.append("days=").append(this.days);
        }
        if (!this.seconds.value.equals(BigInteger.ZERO)) {
            if (out.charAt(out.length() - 1) != '(') {
                out.append(", ");
            }
            out.append("seconds=").append(this.seconds);
        }
        if (!this.microseconds.value.equals(BigInteger.ZERO)) {
            if (out.charAt(out.length() - 1) != '(') {
                out.append(", ");
            }
            out.append("microseconds=").append(this.microseconds);
        }
        if (out.charAt(out.length() - 1) == '(') {
            out.append("0");
        }
        out.append(")");
        return PythonString.valueOf(out.toString());
    }

    public PythonBoolean isZero() {
        return PythonBoolean.valueOf(this.duration.isZero());
    }

    @Override
    public PythonString $method$__str__() {
        return PythonString.valueOf(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder();
        long daysPart = this.duration.toDaysPart();
        Duration durationAfterDay = this.duration.minusDays(daysPart);
        if (this.duration.isNegative() && !Duration.ofDays(1L).multipliedBy(daysPart).equals(this.duration)) {
            --daysPart;
            durationAfterDay = durationAfterDay.plus(Duration.ofDays(1L));
        }
        if (daysPart != 0L) {
            out.append(daysPart);
            out.append(" day");
            if (daysPart > 1L || daysPart < -1L) {
                out.append('s');
            }
            out.append(", ");
        }
        int hours = durationAfterDay.toHoursPart();
        out.append(hours);
        out.append(':');
        int minutes = durationAfterDay.toMinutesPart();
        out.append(String.format("%02d", minutes));
        out.append(':');
        int seconds = durationAfterDay.toSecondsPart();
        out.append(String.format("%02d", seconds));
        int micros = durationAfterDay.toNanosPart() / 1000;
        if (micros != 0) {
            out.append(String.format(".%06d", micros));
        }
        return out.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PythonTimeDelta that = (PythonTimeDelta)o;
        return this.duration.equals(that.duration);
    }

    public int hashCode() {
        return this.duration.hashCode();
    }

    @Override
    public PythonString $method$__repr__() {
        return this.toPythonRepr();
    }

    @Override
    public PythonInteger $method$__hash__() {
        return PythonInteger.valueOf(this.hashCode());
    }

    @Override
    public int compareTo(PythonTimeDelta pythonTimeDelta) {
        return this.duration.compareTo(pythonTimeDelta.duration);
    }

    static {
        $TYPE = TIME_DELTA_TYPE = new PythonLikeType("timedelta", PythonTimeDelta.class);
        try {
            PythonLikeComparable.setup(TIME_DELTA_TYPE);
            PythonTimeDelta.registerMethods();
            TIME_DELTA_TYPE.$setAttribute("min", new PythonTimeDelta(Duration.ofDays(-999999999L)));
            TIME_DELTA_TYPE.$setAttribute("max", new PythonTimeDelta(Duration.ofDays(1000000000L).minusNanos(1000L)));
            TIME_DELTA_TYPE.$setAttribute("resolution", new PythonTimeDelta(Duration.ofNanos(1000L)));
            PythonOverloadImplementor.createDispatchesFor(TIME_DELTA_TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

