/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types;

import ai.timefold.jpyinterpreter.FieldDescriptor;
import ai.timefold.jpyinterpreter.PythonClassTranslator;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonKnownFunctionType;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import java.util.Optional;

public class PythonLikeGenericType
extends PythonLikeType {
    final PythonLikeType origin;

    public PythonLikeGenericType(PythonLikeType origin) {
        super(BuiltinTypes.TYPE_TYPE.getTypeName(), PythonLikeType.class);
        this.origin = origin;
    }

    public PythonLikeType getOrigin() {
        return this.origin;
    }

    @Override
    public Optional<FieldDescriptor> getInstanceFieldDescriptor(String fieldName) {
        Optional<PythonKnownFunctionType> maybeMethodType = this.getMethodType(fieldName);
        if (maybeMethodType.isEmpty()) {
            return BuiltinTypes.TYPE_TYPE.getInstanceFieldDescriptor(fieldName);
        }
        PythonKnownFunctionType knownFunctionType = maybeMethodType.get();
        FieldDescriptor out = new FieldDescriptor(fieldName, PythonClassTranslator.getJavaMethodName(fieldName), this.origin.getJavaTypeInternalName(), knownFunctionType.getJavaTypeDescriptor(), knownFunctionType, false, false);
        return Optional.of(out);
    }

    @Override
    public Optional<PythonKnownFunctionType> getMethodType(String methodName) {
        Optional<PythonKnownFunctionType> originKnownFunctionType = this.origin.getMethodType(methodName);
        if (originKnownFunctionType.isEmpty()) {
            return originKnownFunctionType;
        }
        PythonKnownFunctionType knownFunctionType = originKnownFunctionType.get();
        if (knownFunctionType.isStaticMethod() || knownFunctionType.isClassMethod()) {
            return originKnownFunctionType;
        }
        return Optional.empty();
    }

    @Override
    public Optional<PythonClassTranslator.PythonMethodKind> getMethodKind(String methodName) {
        Optional<PythonClassTranslator.PythonMethodKind> originMethodKind = this.origin.getMethodKind(methodName);
        if (originMethodKind.isEmpty()) {
            return originMethodKind;
        }
        switch (originMethodKind.get()) {
            case STATIC_METHOD: 
            case CLASS_METHOD: {
                return originMethodKind;
            }
        }
        return Optional.empty();
    }

    @Override
    public String toString() {
        return "<class type[" + this.origin.getTypeName() + "]>";
    }
}

