/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.opcodes.descriptor;

import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.PythonVersion;
import ai.timefold.jpyinterpreter.opcodes.Opcode;
import ai.timefold.jpyinterpreter.opcodes.descriptor.OpcodeDescriptor;
import ai.timefold.jpyinterpreter.opcodes.descriptor.VersionMapping;
import ai.timefold.jpyinterpreter.opcodes.generator.GeneratorStartOpcode;
import ai.timefold.jpyinterpreter.opcodes.generator.GetYieldFromIterOpcode;
import ai.timefold.jpyinterpreter.opcodes.generator.ResumeOpcode;
import ai.timefold.jpyinterpreter.opcodes.generator.SendOpcode;
import ai.timefold.jpyinterpreter.opcodes.generator.YieldFromOpcode;
import ai.timefold.jpyinterpreter.opcodes.generator.YieldValueOpcode;
import ai.timefold.jpyinterpreter.opcodes.meta.NopOpcode;
import ai.timefold.jpyinterpreter.opcodes.meta.ReturnGeneratorOpcode;
import ai.timefold.jpyinterpreter.util.JumpUtils;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntBiFunction;

public enum GeneratorOpDescriptor implements OpcodeDescriptor
{
    RESUME(ResumeOpcode::new),
    YIELD_VALUE(YieldValueOpcode::new),
    YIELD_FROM(YieldFromOpcode::new),
    GET_YIELD_FROM_ITER(GetYieldFromIterOpcode::new),
    GEN_START(GeneratorStartOpcode::new),
    SEND(SendOpcode::new, JumpUtils::getRelativeTarget),
    END_SEND(NopOpcode::new),
    RETURN_GENERATOR(ReturnGeneratorOpcode::new);

    final VersionMapping versionLookup;

    private GeneratorOpDescriptor(Function<PythonBytecodeInstruction, Opcode> opcodeFunction) {
        this.versionLookup = VersionMapping.constantMapping(opcodeFunction);
    }

    private GeneratorOpDescriptor(BiFunction<PythonBytecodeInstruction, Integer, Opcode> opcodeConstructor, ToIntBiFunction<PythonBytecodeInstruction, PythonVersion> labelFunction) {
        this.versionLookup = VersionMapping.constantMapping((instruction, pythonVersion) -> (Opcode)opcodeConstructor.apply((PythonBytecodeInstruction)instruction, labelFunction.applyAsInt((PythonBytecodeInstruction)instruction, (PythonVersion)pythonVersion)));
    }

    @Override
    public VersionMapping getVersionMapping() {
        return this.versionLookup;
    }
}

