/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.collections.view;

import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.builtins.UnaryDunderBuiltin;
import ai.timefold.jpyinterpreter.types.AbstractPythonLikeObject;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.DelegatePythonIterator;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeDict;
import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import ai.timefold.jpyinterpreter.util.IteratorUtils;
import java.util.Collection;

public class DictValueView
extends AbstractPythonLikeObject {
    public static final PythonLikeType $TYPE = BuiltinTypes.DICT_VALUE_VIEW_TYPE;
    final PythonLikeDict mapping;
    final Collection<PythonLikeObject> valueCollection;

    private static PythonLikeType registerMethods() throws NoSuchMethodException {
        BuiltinTypes.DICT_VALUE_VIEW_TYPE.addUnaryMethod(PythonUnaryOperator.LENGTH, DictValueView.class.getMethod("getValuesSize", new Class[0]));
        BuiltinTypes.DICT_VALUE_VIEW_TYPE.addUnaryMethod(PythonUnaryOperator.ITERATOR, DictValueView.class.getMethod("getValueIterator", new Class[0]));
        BuiltinTypes.DICT_VALUE_VIEW_TYPE.addUnaryMethod(PythonUnaryOperator.REVERSED, DictValueView.class.getMethod("getReversedValueIterator", new Class[0]));
        BuiltinTypes.DICT_VALUE_VIEW_TYPE.addUnaryMethod(PythonUnaryOperator.AS_STRING, DictValueView.class.getMethod("toRepresentation", new Class[0]));
        BuiltinTypes.DICT_VALUE_VIEW_TYPE.addUnaryMethod(PythonUnaryOperator.REPRESENTATION, DictValueView.class.getMethod("toRepresentation", new Class[0]));
        BuiltinTypes.DICT_VALUE_VIEW_TYPE.addBinaryMethod(PythonBinaryOperator.CONTAINS, DictValueView.class.getMethod("containsValue", PythonLikeObject.class));
        return BuiltinTypes.DICT_VALUE_VIEW_TYPE;
    }

    public DictValueView(PythonLikeDict mapping) {
        super(BuiltinTypes.DICT_VALUE_VIEW_TYPE);
        this.mapping = mapping;
        this.valueCollection = mapping.delegate.values();
        this.$setAttribute("mapping", mapping);
    }

    public PythonInteger getValuesSize() {
        return PythonInteger.valueOf(this.valueCollection.size());
    }

    public DelegatePythonIterator<PythonLikeObject> getValueIterator() {
        return new DelegatePythonIterator<PythonLikeObject>(this.valueCollection.iterator());
    }

    public PythonBoolean containsValue(PythonLikeObject value) {
        return PythonBoolean.valueOf(this.valueCollection.contains(value));
    }

    public DelegatePythonIterator<PythonLikeObject> getReversedValueIterator() {
        return new DelegatePythonIterator<PythonLikeObject>(IteratorUtils.iteratorMap(this.mapping.reversed(), this.mapping::get));
    }

    public PythonString toRepresentation() {
        return PythonString.valueOf(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder("dict_values([");
        for (PythonLikeObject value : this.valueCollection) {
            out.append(UnaryDunderBuiltin.REPRESENTATION.invoke(value));
            out.append(", ");
        }
        out.delete(out.length() - 2, out.length());
        out.append("])");
        return out.toString();
    }

    static {
        PythonOverloadImplementor.deferDispatchesFor(DictValueView::registerMethods);
    }
}

