/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.opcodes;

import ai.timefold.jpyinterpreter.FunctionMetadata;
import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.StackMetadata;
import ai.timefold.jpyinterpreter.opcodes.Opcode;
import ai.timefold.jpyinterpreter.opcodes.descriptor.OpcodeDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractOpcode
implements Opcode {
    protected PythonBytecodeInstruction instruction;
    private static final Map<String, OpcodeDescriptor> opcodeNameToInstructionMap = AbstractOpcode.getOpcodeNameToInstructionMap();

    private static Map<String, OpcodeDescriptor> getOpcodeNameToInstructionMap() {
        HashMap<String, OpcodeDescriptor> out = new HashMap<String, OpcodeDescriptor>();
        for (Class<?> subclass : OpcodeDescriptor.class.getPermittedSubclasses()) {
            if (!subclass.isEnum()) {
                throw new IllegalStateException("%s is a subclass of %s and is not an enum.".formatted(subclass, OpcodeDescriptor.class.getSimpleName()));
            }
            Class<?> enumSubclass = subclass;
            for (Enum constant : (Enum[])enumSubclass.getEnumConstants()) {
                String name = constant.name();
                if (out.containsKey(name)) {
                    throw new IllegalStateException("Duplicate identifier %s present in both %s and %s.".formatted(name, ((OpcodeDescriptor)out.get(name)).getClass(), enumSubclass));
                }
                out.put(name, (OpcodeDescriptor)((Object)constant));
            }
        }
        return out;
    }

    public AbstractOpcode(PythonBytecodeInstruction instruction) {
        this.instruction = instruction;
    }

    public PythonBytecodeInstruction getInstruction() {
        return this.instruction;
    }

    @Override
    public int getBytecodeIndex() {
        return this.instruction.offset();
    }

    @Override
    public boolean isJumpTarget() {
        return this.instruction.isJumpTarget();
    }

    @Override
    public List<StackMetadata> getStackMetadataAfterInstructionForBranches(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        return List.of(this.getStackMetadataAfterInstruction(functionMetadata, stackMetadata));
    }

    protected abstract StackMetadata getStackMetadataAfterInstruction(FunctionMetadata var1, StackMetadata var2);

    public static OpcodeDescriptor lookupInstruction(String name) {
        OpcodeDescriptor out = opcodeNameToInstructionMap.get(name);
        if (out == null) {
            throw new IllegalArgumentException("Invalid opcode identifier %s.".formatted(name));
        }
        return out;
    }

    public String toString() {
        return this.instruction.toString();
    }
}

