/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.implementors;

import ai.timefold.jpyinterpreter.FunctionMetadata;
import ai.timefold.jpyinterpreter.LocalVariableHelper;
import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.PythonCompiledFunction;
import ai.timefold.jpyinterpreter.PythonInterpreter;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonVersion;
import ai.timefold.jpyinterpreter.StackMetadata;
import ai.timefold.jpyinterpreter.ValueSourceInfo;
import ai.timefold.jpyinterpreter.implementors.CollectionImplementor;
import ai.timefold.jpyinterpreter.implementors.KnownCallImplementor;
import ai.timefold.jpyinterpreter.implementors.ObjectImplementor;
import ai.timefold.jpyinterpreter.implementors.PythonConstantsImplementor;
import ai.timefold.jpyinterpreter.implementors.StackManipulationImplementor;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonCode;
import ai.timefold.jpyinterpreter.types.PythonKnownFunctionType;
import ai.timefold.jpyinterpreter.types.PythonLikeFunction;
import ai.timefold.jpyinterpreter.types.PythonLikeGenericType;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeDict;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class FunctionImplementor {
    public static void callBinaryMethod(FunctionMetadata functionMetadata, StackMetadata stackMetadata, MethodVisitor methodVisitor, String methodName) {
        methodVisitor.visitInsn(95);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
        methodVisitor.visitLdcInsn((Object)methodName);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getAttributeOrError", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), true);
        methodVisitor.visitInsn(91);
        methodVisitor.visitInsn(87);
        methodVisitor.visitInsn(95);
        CollectionImplementor.buildCollection(PythonLikeTuple.class, methodVisitor, 2);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(Collections.class), "emptyMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), false);
        FunctionImplementor.getCallerInstance(functionMetadata, stackMetadata);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeFunction.class), "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), true);
    }

    public static void callBinaryMethod(MethodVisitor methodVisitor, String methodName) {
        methodVisitor.visitInsn(95);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
        methodVisitor.visitLdcInsn((Object)methodName);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getAttributeOrError", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), true);
        methodVisitor.visitInsn(91);
        methodVisitor.visitInsn(87);
        methodVisitor.visitInsn(95);
        CollectionImplementor.buildCollection(PythonLikeTuple.class, methodVisitor, 2);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(Collections.class), "emptyMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), false);
        methodVisitor.visitInsn(1);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeFunction.class), "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), true);
    }

    public static void loadMethod(FunctionMetadata functionMetadata, StackMetadata stackMetadata, int nameIndex) {
        boolean isTosType;
        PythonLikeType tosType;
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        PythonCompiledFunction function = functionMetadata.pythonCompiledFunction;
        String className = functionMetadata.className;
        PythonLikeType stackTosType = stackMetadata.getTOSType();
        if (stackTosType instanceof PythonLikeGenericType) {
            tosType = ((PythonLikeGenericType)stackTosType).getOrigin();
            isTosType = true;
        } else {
            tosType = stackTosType;
            isTosType = false;
        }
        tosType.getMethodType(functionMetadata.pythonCompiledFunction.co_names.get(nameIndex)).ifPresentOrElse(knownFunctionType -> {
            if (isTosType && knownFunctionType.isStaticMethod()) {
                methodVisitor.visitLdcInsn((Object)function.co_names.get(nameIndex));
                methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getAttributeOrNull", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), true);
                methodVisitor.visitInsn(1);
                if (functionMetadata.pythonCompiledFunction.pythonVersion.isAtLeast(PythonVersion.PYTHON_3_11)) {
                    methodVisitor.visitInsn(90);
                    methodVisitor.visitInsn(87);
                }
            } else if (!isTosType && knownFunctionType.isStaticMethod()) {
                methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
                methodVisitor.visitLdcInsn((Object)function.co_names.get(nameIndex));
                methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getAttributeOrNull", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), true);
                methodVisitor.visitInsn(1);
                if (functionMetadata.pythonCompiledFunction.pythonVersion.isAtLeast(PythonVersion.PYTHON_3_11)) {
                    methodVisitor.visitInsn(90);
                    methodVisitor.visitInsn(87);
                }
            } else if (isTosType && knownFunctionType.isClassMethod()) {
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn((Object)function.co_names.get(nameIndex));
                methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getAttributeOrNull", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), true);
                methodVisitor.visitInsn(95);
            } else if (!isTosType && knownFunctionType.isClassMethod()) {
                methodVisitor.visitInsn(89);
                methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
                methodVisitor.visitLdcInsn((Object)function.co_names.get(nameIndex));
                methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getAttributeOrNull", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), true);
                methodVisitor.visitInsn(95);
            } else if (isTosType) {
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn((Object)function.co_names.get(nameIndex));
                methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getAttributeOrNull", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), true);
                methodVisitor.visitInsn(95);
            } else {
                methodVisitor.visitInsn(89);
                methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
                methodVisitor.visitLdcInsn((Object)function.co_names.get(nameIndex));
                methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getAttributeOrNull", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), true);
                methodVisitor.visitInsn(95);
            }
        }, () -> FunctionImplementor.loadGenericMethod(functionMetadata, methodVisitor, className, function, stackMetadata, nameIndex));
    }

    private static void loadGenericMethod(FunctionMetadata functionMetadata, MethodVisitor methodVisitor, String className, PythonCompiledFunction function, StackMetadata stackMetadata, int nameIndex) {
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
        methodVisitor.visitLdcInsn((Object)function.co_names.get(nameIndex));
        methodVisitor.visitMethodInsn(182, Type.getInternalName(PythonLikeType.class), "loadMethod", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), false);
        methodVisitor.visitInsn(89);
        methodVisitor.visitInsn(1);
        Label blockEnd = new Label();
        methodVisitor.visitJumpInsn(166, blockEnd);
        methodVisitor.visitInsn(87);
        ObjectImplementor.getAttribute(functionMetadata, stackMetadata, nameIndex);
        methodVisitor.visitInsn(1);
        if (functionMetadata.pythonCompiledFunction.pythonVersion.isBefore(PythonVersion.PYTHON_3_11)) {
            methodVisitor.visitInsn(95);
        }
        methodVisitor.visitLabel(blockEnd);
        methodVisitor.visitInsn(95);
    }

    public static void setCallKeywordNameTuple(FunctionMetadata functionMetadata, StackMetadata stackMetadata, int constantIndex) {
        LocalVariableHelper localVariableHelper = stackMetadata.localVariableHelper;
        PythonConstantsImplementor.loadConstant(functionMetadata.methodVisitor, functionMetadata.className, constantIndex);
        localVariableHelper.writeCallKeywords(functionMetadata.methodVisitor);
    }

    public static void call(FunctionMetadata functionMetadata, StackMetadata stackMetadata, int argumentCount) {
        PythonLikeType functionType = stackMetadata.getTypeAtStackIndex(argumentCount + 1);
        if (functionType instanceof PythonLikeGenericType) {
            functionType = ((PythonLikeGenericType)functionType).getOrigin().getConstructorType().orElse(null);
        }
        if (functionType instanceof PythonKnownFunctionType) {
            PythonKnownFunctionType knownFunctionType = (PythonKnownFunctionType)functionType;
            List<String> keywordArgumentNameList = stackMetadata.getCallKeywordNameList();
            List<PythonLikeType> callStackParameterTypes = stackMetadata.getValueSourcesUpToStackIndex(argumentCount).stream().map(ValueSourceInfo::getValueType).collect(Collectors.toList());
            knownFunctionType.getFunctionForParameters(argumentCount - keywordArgumentNameList.size(), keywordArgumentNameList, callStackParameterTypes).ifPresentOrElse(functionSignature -> KnownCallImplementor.callPython311andAbove(functionSignature, functionMetadata, stackMetadata, argumentCount, stackMetadata.getCallKeywordNameList()), () -> FunctionImplementor.callGeneric(functionMetadata, stackMetadata, argumentCount));
        } else {
            functionType = stackMetadata.getTypeAtStackIndex(argumentCount);
            if (functionType instanceof PythonLikeGenericType) {
                functionType = ((PythonLikeGenericType)functionType).getOrigin().getConstructorType().orElse(null);
            }
            if (functionType instanceof PythonKnownFunctionType) {
                PythonKnownFunctionType knownFunctionType = (PythonKnownFunctionType)functionType;
                List<String> keywordArgumentNameList = stackMetadata.getCallKeywordNameList();
                List<PythonLikeType> callStackParameterTypes = stackMetadata.getValueSourcesUpToStackIndex(argumentCount).stream().map(ValueSourceInfo::getValueType).collect(Collectors.toList());
                knownFunctionType.getFunctionForParameters(argumentCount - keywordArgumentNameList.size(), keywordArgumentNameList, callStackParameterTypes).ifPresentOrElse(functionSignature -> KnownCallImplementor.callPython311andAbove(functionSignature, functionMetadata, stackMetadata, argumentCount, stackMetadata.getCallKeywordNameList()), () -> FunctionImplementor.callGeneric(functionMetadata, stackMetadata, argumentCount));
            } else {
                FunctionImplementor.callGeneric(functionMetadata, stackMetadata, argumentCount);
            }
        }
    }

    private static void callGeneric(FunctionMetadata functionMetadata, StackMetadata stackMetadata, int argumentCount) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        LocalVariableHelper localVariableHelper = stackMetadata.localVariableHelper;
        int keywordArgs = localVariableHelper.newLocal();
        int positionalArgs = localVariableHelper.newLocal();
        localVariableHelper.readCallKeywords(methodVisitor);
        CollectionImplementor.buildCollection(TupleMapPair.class, methodVisitor, argumentCount + 1);
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(180, Type.getInternalName(TupleMapPair.class), "tuple", Type.getDescriptor(PythonLikeTuple.class));
        localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeTuple.class), positionalArgs);
        methodVisitor.visitFieldInsn(180, Type.getInternalName(TupleMapPair.class), "map", Type.getDescriptor(PythonLikeDict.class));
        localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeDict.class), keywordArgs);
        methodVisitor.visitInsn(95);
        Label ifNullStart = new Label();
        Label blockEnd = new Label();
        methodVisitor.visitInsn(89);
        methodVisitor.visitInsn(1);
        methodVisitor.visitJumpInsn(165, ifNullStart);
        StackManipulationImplementor.swap(methodVisitor);
        localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeTuple.class), positionalArgs);
        methodVisitor.visitInsn(95);
        methodVisitor.visitInsn(3);
        methodVisitor.visitInsn(95);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "add", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.getType(Object.class)}), true);
        localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeTuple.class), positionalArgs);
        methodVisitor.visitJumpInsn(167, blockEnd);
        methodVisitor.visitLabel(ifNullStart);
        methodVisitor.visitInsn(87);
        localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeTuple.class), positionalArgs);
        methodVisitor.visitLabel(blockEnd);
        localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeDict.class), keywordArgs);
        FunctionImplementor.getCallerInstance(functionMetadata, stackMetadata);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeFunction.class), "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), true);
        localVariableHelper.resetCallKeywords(methodVisitor);
        localVariableHelper.freeLocal();
        localVariableHelper.freeLocal();
    }

    public static void callMethod(FunctionMetadata functionMetadata, StackMetadata stackMetadata, MethodVisitor methodVisitor, PythonBytecodeInstruction instruction, LocalVariableHelper localVariableHelper) {
        PythonLikeType functionType = stackMetadata.getTypeAtStackIndex(instruction.arg() + 1);
        if (functionType instanceof PythonKnownFunctionType) {
            PythonKnownFunctionType knownFunctionType = (PythonKnownFunctionType)functionType;
            PythonLikeType[] parameterTypes = new PythonLikeType[instruction.arg()];
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameterTypes[parameterTypes.length - i - 1] = stackMetadata.getTypeAtStackIndex(i);
            }
            knownFunctionType.getFunctionForParameters(parameterTypes).ifPresentOrElse(functionSignature -> {
                KnownCallImplementor.callMethod(functionSignature, methodVisitor, localVariableHelper, instruction.arg());
                methodVisitor.visitInsn(95);
                methodVisitor.visitInsn(87);
                if (knownFunctionType.isStaticMethod()) {
                    methodVisitor.visitInsn(95);
                    methodVisitor.visitInsn(87);
                }
            }, () -> FunctionImplementor.callGenericMethod(functionMetadata, stackMetadata, methodVisitor, instruction, localVariableHelper));
        } else {
            FunctionImplementor.callGenericMethod(functionMetadata, stackMetadata, methodVisitor, instruction, localVariableHelper);
        }
    }

    private static void callGenericMethod(FunctionMetadata functionMetadata, StackMetadata stackMetadata, MethodVisitor methodVisitor, PythonBytecodeInstruction instruction, LocalVariableHelper localVariableHelper) {
        CollectionImplementor.buildCollection(PythonLikeTuple.class, methodVisitor, instruction.arg());
        methodVisitor.visitInsn(95);
        Label ifNullStart = new Label();
        Label blockEnd = new Label();
        methodVisitor.visitInsn(89);
        methodVisitor.visitInsn(1);
        methodVisitor.visitJumpInsn(165, ifNullStart);
        StackManipulationImplementor.duplicateToTOS(functionMetadata, stackMetadata, 1);
        StackManipulationImplementor.swap(methodVisitor);
        methodVisitor.visitInsn(3);
        methodVisitor.visitInsn(95);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "add", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.getType(Object.class)}), true);
        methodVisitor.visitJumpInsn(167, blockEnd);
        methodVisitor.visitLabel(ifNullStart);
        methodVisitor.visitInsn(87);
        methodVisitor.visitLabel(blockEnd);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(Collections.class), "emptyMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), false);
        FunctionImplementor.getCallerInstance(functionMetadata, stackMetadata);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeFunction.class), "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), true);
    }

    public static void callFunction(FunctionMetadata functionMetadata, StackMetadata stackMetadata, MethodVisitor methodVisitor, PythonBytecodeInstruction instruction) {
        PythonLikeType functionType = stackMetadata.getTypeAtStackIndex(instruction.arg());
        if (functionType instanceof PythonLikeGenericType) {
            functionType = ((PythonLikeGenericType)functionType).getOrigin().getConstructorType().orElse(null);
        }
        if (functionType instanceof PythonKnownFunctionType) {
            PythonKnownFunctionType knownFunctionType = (PythonKnownFunctionType)functionType;
            knownFunctionType.getDefaultFunctionSignature().ifPresentOrElse(functionSignature -> {
                KnownCallImplementor.callWithoutKeywords(functionSignature, functionMetadata, stackMetadata, instruction.arg());
                methodVisitor.visitInsn(95);
                methodVisitor.visitInsn(87);
            }, () -> FunctionImplementor.callGenericFunction(functionMetadata, stackMetadata, methodVisitor, instruction));
        } else {
            FunctionImplementor.callGenericFunction(functionMetadata, stackMetadata, methodVisitor, instruction);
        }
    }

    public static void callGenericFunction(FunctionMetadata functionMetadata, StackMetadata stackMetadata, MethodVisitor methodVisitor, PythonBytecodeInstruction instruction) {
        FunctionImplementor.callGenericFunction(functionMetadata, stackMetadata, methodVisitor, instruction.arg());
    }

    public static void callGenericFunction(MethodVisitor methodVisitor, int argCount) {
        CollectionImplementor.buildCollection(PythonLikeTuple.class, methodVisitor, argCount);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(Collections.class), "emptyMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), false);
        methodVisitor.visitInsn(1);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeFunction.class), "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), true);
    }

    public static void callGenericFunction(FunctionMetadata functionMetadata, StackMetadata stackMetadata, MethodVisitor methodVisitor, int argCount) {
        CollectionImplementor.buildCollection(PythonLikeTuple.class, methodVisitor, argCount);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(Collections.class), "emptyMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), false);
        FunctionImplementor.getCallerInstance(functionMetadata, stackMetadata);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeFunction.class), "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), true);
    }

    public static void callFunctionWithKeywords(FunctionMetadata functionMetadata, StackMetadata stackMetadata, MethodVisitor methodVisitor, PythonBytecodeInstruction instruction) {
        PythonLikeType functionType = stackMetadata.getTypeAtStackIndex(instruction.arg() + 1);
        if (functionType instanceof PythonLikeGenericType) {
            functionType = ((PythonLikeGenericType)functionType).getOrigin().getConstructorType().orElse(null);
        }
        if (functionType instanceof PythonKnownFunctionType) {
            PythonKnownFunctionType knownFunctionType = (PythonKnownFunctionType)functionType;
            knownFunctionType.getDefaultFunctionSignature().ifPresentOrElse(functionSignature -> {
                KnownCallImplementor.callWithKeywordsAndUnwrapSelf(functionSignature, functionMetadata, stackMetadata, instruction.arg());
                methodVisitor.visitInsn(95);
                methodVisitor.visitInsn(87);
            }, () -> FunctionImplementor.callGenericFunction(functionMetadata, stackMetadata, methodVisitor, instruction));
        } else {
            FunctionImplementor.callGenericFunctionWithKeywords(functionMetadata, stackMetadata, methodVisitor, instruction);
        }
    }

    public static void callGenericFunctionWithKeywords(FunctionMetadata functionMetadata, StackMetadata stackMetadata, MethodVisitor methodVisitor, PythonBytecodeInstruction instruction) {
        CollectionImplementor.buildCollection(TupleMapPair.class, methodVisitor, instruction.arg() + 1);
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(180, Type.getInternalName(TupleMapPair.class), "tuple", Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitInsn(95);
        methodVisitor.visitFieldInsn(180, Type.getInternalName(TupleMapPair.class), "map", Type.getDescriptor(PythonLikeDict.class));
        FunctionImplementor.getCallerInstance(functionMetadata, stackMetadata);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeFunction.class), "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), true);
    }

    public static void callFunctionUnpack(FunctionMetadata functionMetadata, StackMetadata stackMetadata, PythonBytecodeInstruction instruction) {
        if ((instruction.arg() & 1) == 1) {
            FunctionImplementor.callFunctionUnpackMapAndIterable(functionMetadata, stackMetadata, functionMetadata.methodVisitor);
        } else {
            FunctionImplementor.callFunctionUnpackIterable(functionMetadata, stackMetadata, functionMetadata.methodVisitor);
        }
    }

    public static void callFunctionUnpackMapAndIterable(FunctionMetadata functionMetadata, StackMetadata stackMetadata, MethodVisitor methodVisitor) {
        FunctionImplementor.getCallerInstance(functionMetadata, stackMetadata);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeFunction.class), "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), true);
        if (functionMetadata.pythonCompiledFunction.pythonVersion.isAtLeast(PythonVersion.PYTHON_3_11)) {
            methodVisitor.visitInsn(95);
            methodVisitor.visitInsn(87);
        }
    }

    public static void callFunctionUnpackIterable(FunctionMetadata functionMetadata, StackMetadata stackMetadata, MethodVisitor methodVisitor) {
        methodVisitor.visitMethodInsn(184, Type.getInternalName(Collections.class), "emptyMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), false);
        FunctionImplementor.getCallerInstance(functionMetadata, stackMetadata);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeFunction.class), "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), true);
        if (functionMetadata.pythonCompiledFunction.pythonVersion.isAtLeast(PythonVersion.PYTHON_3_11)) {
            methodVisitor.visitInsn(95);
            methodVisitor.visitInsn(87);
        }
    }

    private static void getCallerInstance(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        if (functionMetadata.pythonCompiledFunction.totalArgCount() > 0) {
            stackMetadata.localVariableHelper.readLocal(methodVisitor, 0);
        } else {
            methodVisitor.visitInsn(1);
        }
    }

    public static void createFunction(FunctionMetadata functionMetadata, StackMetadata stackMetadata, PythonBytecodeInstruction instruction) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        String className = functionMetadata.className;
        if (functionMetadata.pythonCompiledFunction.pythonVersion.isAtLeast(PythonVersion.PYTHON_3_11)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonCode.class));
            methodVisitor.visitInsn(89);
            methodVisitor.visitFieldInsn(180, Type.getInternalName(PythonCode.class), "functionClass", Type.getDescriptor(Class.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Class.class), "getName", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]), false);
            methodVisitor.visitMethodInsn(184, Type.getInternalName(PythonString.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(PythonString.class), (Type[])new Type[]{Type.getType(String.class)}), false);
            stackMetadata = stackMetadata.pushTemp(BuiltinTypes.STRING_TYPE);
        }
        int providedOptionalArgs = Integer.bitCount(instruction.arg());
        StackMetadata tempStackmetadata = stackMetadata;
        if ((instruction.arg() & 1) != 1) {
            CollectionImplementor.buildCollection(PythonLikeTuple.class, methodVisitor, 0);
            tempStackmetadata = tempStackmetadata.pushTemp(BuiltinTypes.TUPLE_TYPE);
            tempStackmetadata = StackManipulationImplementor.shiftTOSDownBy(functionMetadata, tempStackmetadata, 2 + providedOptionalArgs);
        } else {
            --providedOptionalArgs;
        }
        if ((instruction.arg() & 2) != 2) {
            CollectionImplementor.buildMap(PythonLikeDict.class, methodVisitor, 0);
            tempStackmetadata = tempStackmetadata.pushTemp(BuiltinTypes.DICT_TYPE);
            tempStackmetadata = StackManipulationImplementor.shiftTOSDownBy(functionMetadata, tempStackmetadata, 2 + providedOptionalArgs);
        } else {
            --providedOptionalArgs;
        }
        if ((instruction.arg() & 4) != 4) {
            if (functionMetadata.pythonCompiledFunction.pythonVersion.isBefore(PythonVersion.PYTHON_3_10)) {
                CollectionImplementor.buildMap(PythonLikeDict.class, methodVisitor, 0);
                tempStackmetadata = tempStackmetadata.pushTemp(BuiltinTypes.DICT_TYPE);
                tempStackmetadata = StackManipulationImplementor.shiftTOSDownBy(functionMetadata, tempStackmetadata, 2 + providedOptionalArgs);
            } else {
                CollectionImplementor.buildCollection(PythonLikeTuple.class, methodVisitor, 0);
                tempStackmetadata = tempStackmetadata.pushTemp(BuiltinTypes.TUPLE_TYPE);
                tempStackmetadata = StackManipulationImplementor.shiftTOSDownBy(functionMetadata, tempStackmetadata, 2 + providedOptionalArgs);
            }
        } else {
            --providedOptionalArgs;
        }
        if ((instruction.arg() & 8) != 8) {
            CollectionImplementor.buildCollection(PythonLikeTuple.class, methodVisitor, 0);
            tempStackmetadata = tempStackmetadata.pushTemp(BuiltinTypes.TUPLE_TYPE);
            tempStackmetadata = StackManipulationImplementor.shiftTOSDownBy(functionMetadata, tempStackmetadata, 2 + providedOptionalArgs);
        }
        methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonString.class));
        methodVisitor.visitInsn(95);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonCode.class));
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, className, "__interpreter__", Type.getDescriptor(PythonInterpreter.class));
        if (functionMetadata.pythonCompiledFunction.pythonVersion.isBefore(PythonVersion.PYTHON_3_10)) {
            methodVisitor.visitMethodInsn(184, Type.getInternalName(FunctionImplementor.class), "createInstance", Type.getMethodDescriptor((Type)Type.getType(PythonLikeFunction.class), (Type[])new Type[]{Type.getType(PythonLikeTuple.class), Type.getType(PythonLikeDict.class), Type.getType(PythonLikeDict.class), Type.getType(PythonLikeTuple.class), Type.getType(PythonString.class), Type.getType(PythonCode.class), Type.getType(PythonInterpreter.class)}), false);
        } else {
            methodVisitor.visitMethodInsn(184, Type.getInternalName(FunctionImplementor.class), "createInstance", Type.getMethodDescriptor((Type)Type.getType(PythonLikeFunction.class), (Type[])new Type[]{Type.getType(PythonLikeTuple.class), Type.getType(PythonLikeDict.class), Type.getType(PythonLikeTuple.class), Type.getType(PythonLikeTuple.class), Type.getType(PythonString.class), Type.getType(PythonCode.class), Type.getType(PythonInterpreter.class)}), false);
        }
    }

    public static PythonLikeFunction createInstance(PythonLikeTuple defaultPositionalArgs, PythonLikeDict defaultKeywordArgs, PythonLikeDict annotationDict, PythonLikeTuple closure, PythonString functionName, PythonCode code, PythonInterpreter pythonInterpreter) {
        return FunctionImplementor.createInstance(defaultPositionalArgs, defaultKeywordArgs, annotationDict.toFlattenKeyValueTuple(), closure, functionName, code.functionClass, pythonInterpreter);
    }

    public static PythonLikeFunction createInstance(PythonLikeTuple defaultPositionalArgs, PythonLikeDict defaultKeywordArgs, PythonLikeTuple annotationTuple, PythonLikeTuple closure, PythonString functionName, PythonCode code, PythonInterpreter pythonInterpreter) {
        return FunctionImplementor.createInstance(defaultPositionalArgs, defaultKeywordArgs, annotationTuple, closure, functionName, code.functionClass, pythonInterpreter);
    }

    public static <T> T createInstance(PythonLikeTuple defaultPositionalArgs, PythonLikeDict defaultKeywordArgs, PythonLikeTuple annotationTuple, PythonLikeTuple closure, PythonString functionName, Class<T> functionClass, PythonInterpreter pythonInterpreter) {
        PythonLikeDict annotationDirectory = new PythonLikeDict();
        for (int i = 0; i < annotationTuple.size() >> 1; ++i) {
            annotationDirectory.put((PythonLikeObject)annotationTuple.get(i * 2), (PythonLikeObject)annotationTuple.get(i * 2 + 1));
        }
        try {
            Constructor<T> constructor = functionClass.getConstructor(PythonLikeTuple.class, PythonLikeDict.class, PythonLikeDict.class, PythonLikeTuple.class, PythonString.class, PythonInterpreter.class);
            return constructor.newInstance(defaultPositionalArgs, defaultKeywordArgs, annotationDirectory, closure, functionName, pythonInterpreter);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static class TupleMapPair {
        public PythonLikeTuple tuple = null;
        public PythonLikeDict map = new PythonLikeDict();
        List<PythonLikeObject> mapKeyTuple = null;
        final int totalNumberOfPositionalAndKeywordArguments;

        public TupleMapPair(int itemsToPop) {
            this.totalNumberOfPositionalAndKeywordArguments = itemsToPop - 1;
        }

        public void reverseAdd(PythonLikeObject object) {
            if (this.mapKeyTuple == null) {
                this.mapKeyTuple = (List)((Object)object);
                this.tuple = new PythonLikeTuple(this.totalNumberOfPositionalAndKeywordArguments - this.mapKeyTuple.size());
                return;
            }
            if (this.map.size() < this.mapKeyTuple.size()) {
                this.map.put(this.mapKeyTuple.get(this.mapKeyTuple.size() - this.map.size() - 1), object);
            } else {
                this.tuple.reverseAdd(object);
            }
        }
    }
}

