package com.particles.mes.android.data

import com.particles.mes.protos.ErrorCode
import com.particles.mes.protos.SdkPlatform

enum class ConnectionType {
    CONNECTION_TYPE_UNKNOWN,
    CONNECTION_TYPE_ETHERNET,   // Ethernet; Wired connection
    CONNECTION_TYPE_WIFI,       // WiFi
    CONNECTION_TYPE_CELL_UNKNOWN, // Mobile Network - Unknown Generation
    CONNECTION_TYPE_CELL_2G,    // Mobile Network - 2G
    CONNECTION_TYPE_CELL_3G,    // Mobile Network - 3G
    CONNECTION_TYPE_CELL_4G,    // Mobile Network - 4G
    CONNECTION_TYPE_CELL_5G,    // Mobile Network - 5G
}

enum class UserSignalType {
    USER_SIGNAL_TYPE_INTO_FOREGROUND,
    USER_SIGNAL_TYPE_INTO_BACKGROUND,
    USER_SIGNAL_TYPE_INTO_ATTRIBUTION
}

data class DeviceSignal(
    val make: String,
    val model: String,
    val os: String,
    val osv: String,
    val kernelv: String,
    val w: Int,
    val h: Int,
    val orientation: String,
    val volumeLevel: Int,
    val brightness: Int,
    val batteryLevel: Int,
    val batteryStatus: String,   // unplugged, charging, full
    val thermalStatus: String,
    val totalMemoryBytes: Long,
    val availableMemoryBytes: Long,
    val totalStorageBytes: Long,
    val availableStorageBytes: Long,
    val isLowPowerMode: Boolean = false,
    val isLowDataMode: Boolean = false,
    val fontSize: String,
    val theme: String,           // light, dark, system
    val carrier: String,
    val mccmnc: String,
    val connectionType: ConnectionType,
    val country: String,         // ISO 3166-1 region code
    val timezone: String,        // e.g. "America/Los_Angeles"
    val locale: String,          // e.g. "en-US, zh-Hans-US"
    val ua: String,              // user agent
    val ifa: String,             // IDFA, GAID, etc.
    val ifv: String,             // iOS IDFV / Android AppSetId
    val lmt: Boolean = false             // limit ad tracking
)

data class AppSignal(
    val name: String,
    val bundle: String,
    val ver: String,
    val domain: String,
    val page: String,
    val ppid: String
)

data class SdkSignal(
    val orgId: Int,
    val appId: Int,
    val mspId: String,
    val sdkVersion: String,
    val platform: SdkPlatform,
    val clientTs: Long = System.currentTimeMillis(),
    val uuid: String
)

data class MesAdImpressionEvent(
    val ts: Long = System.currentTimeMillis(),
    val adRequest: MesAdRequest,
    val adResponse: MesAdResponse,
    val mspSdkVersion: String,
)

data class MesAdHideEvent(
    val ts: Long = System.currentTimeMillis(),
    val adRequest: MesAdRequest,
    val adResponse: MesAdResponse,
    val reason: String,
    val mspSdkVersion: String,
)

data class MesAdReportEvent(
    val ts: Long = System.currentTimeMillis(),
    val adRequest: MesAdRequest,
    val adResponse: MesAdResponse,
    val reason: String,
    val description: String? = null,
    val mspSdkVersion: String,
)

data class MesSdkInitEvent(
    val clientTs: Long = System.currentTimeMillis(),
    val org: String,
    val app: String,
    val latency: Int,
    val totalCompleteTime: Int,
    val completeTimeByAdNetwork: Map<String, Int>,
    val mspSdkVersion: String,
    val mspId: String,
    val ifa: String,
    val batteryLevel: Float,
    val batteryStatus: String,
    val fontSize: String,
    val timeZone: String,
    val availableMemoryBytes: Long,
    val isLowPowerMode: Boolean,
    val isLowDataMode: Boolean,
    val ppid: String,
    val sdkSignal: SdkSignal,
    val deviceSignal: DeviceSignal,
    val appSignal: AppSignal
)

data class MesLoadAdEvent(
    val clientTs: Long = System.currentTimeMillis(),
    val adRequest: MesAdRequest?,
    val adResponse: MesAdResponse?,
    val org: String,
    val app: String,
    val latency: Int,
    val errorCode: ErrorCode,
    val errorMessage: String? = null,
    val filledFromCache: Boolean = false,
    val mspSdkVersion: String,
)

data class MesGetAdEvent(
    val clientTs: Long = System.currentTimeMillis(),
    val adRequest: MesAdRequest,
    val adResponse: MesAdResponse,
    val errorCode: ErrorCode,
    val errorMessage: String? = null,
    val mspSdkVersion: String,
)

data class MesAdRequestEvent(
    val clientTs: Long = System.currentTimeMillis(),
    val adRequest: MesAdRequest,
    val mspSdkVersion: String,
)

data class MesAdResponseEvent(
    val clientTs: Long = System.currentTimeMillis(),
    val adRequest: MesAdRequest,
    val adResponse: MesAdResponse?,
    val latency: Int,
    val errorCode: ErrorCode,
    val errorMessage: String? = null,
    val mspSdkVersion: String,
)

data class MesAdClickEvent(
    val ts: Long = System.currentTimeMillis(),
    val adRequest: MesAdRequest,
    val adResponse: MesAdResponse,
    val mspSdkVersion: String,
)

data class MesUserSignalEvent(
    val type: UserSignalType,
    val sdkSignal: SdkSignal,
    val deviceSignal: DeviceSignal,
    val appSignal: AppSignal
)
