package com.particles.mes.android.data.mapper

import com.particles.mes.protos.openrtb.CreativeAttribute
import com.particles.mes.protos.openrtb.Protocol
import org.json.JSONObject
import com.particles.mes.protos.openrtb.BidResponse as BidResponseProto
import org.prebid.mobile.rendering.bidding.data.bid.Bid
import org.prebid.mobile.rendering.bidding.data.bid.Seatbid

object BidResponseMapper {

    fun map(source: Seatbid): BidResponseProto.SeatBid {
        return BidResponseProto.SeatBid.newBuilder()
            .apply {
                source.seat?.let { seat = it }
                source.bids.forEach { addBid(map(it)) }
                group = source.group != 0
            }
            .build()
    }

    fun map(source: Bid): BidResponseProto.SeatBid.Bid {
        return BidResponseProto.SeatBid.Bid.newBuilder()
            .apply {
                source.id?.let { id = it }
                source.impId?.let { impid = it }
                source.adid?.let { adid = it }
                source.adomain.forEach { addAdomain(it) }
                price = source.price
                source.adm?.let { adm = it }
                source.bundle?.let { bundle = it }
                source.cid?.let { cid = it }
                source.crid?.let { crid = it }
                source.tactic?.let { tactic = it }
                source.cat.forEach { addCat(it) }
                source.attr.forEach { CreativeAttribute.forNumber(it)?.let { attr -> addAttr(attr) } }
                Protocol.forNumber(source.protocol)?.let { protocol = it }
                source.language?.let { language = it }
                source.dealId?.let { dealid = it }
            }
            .build()
    }
}
