/*
 * Decompiled with CFR 0.152.
 */
package ai.seventhsense.facedetection;

import ai.seventhsense.facedetection.Detection;
import android.content.Context;
import android.graphics.Bitmap;
import java.util.ArrayList;
import java.util.HashMap;

public class LFDDetector {
    private long nativeHandle;
    private static HashMap<Long, LFDDetector> instances;
    private Context mContext;

    private native void initialize(int var1);

    public native void close();

    private native float[] detectNative(Bitmap var1, Bitmap var2);

    private LFDDetector(Context context) {
        this.mContext = context;
    }

    public static synchronized LFDDetector getInstance(Context context, int maxSide) {
        Long threadId = Thread.currentThread().getId();
        if (!instances.containsKey(threadId)) {
            LFDDetector detector = new LFDDetector(context);
            instances.put(threadId, detector);
            detector.initialize(maxSide);
        }
        return instances.get(threadId);
    }

    public static synchronized LFDDetector getInstance(Context context) {
        return LFDDetector.getInstance(context, 160);
    }

    public Detection detect(Bitmap image) {
        Bitmap.Config conf = Bitmap.Config.ARGB_8888;
        Bitmap thumbnail = Bitmap.createBitmap((int)112, (int)112, (Bitmap.Config)conf);
        float[] results = this.detectNative(image, thumbnail);
        ArrayList<Detection> detections = new ArrayList<Detection>();
        for (int index = 0; index < results.length; index += 15) {
            float left = results[index];
            float top = results[index + 1];
            float right = results[index + 2];
            float bottom = results[index + 3];
            float l1x = results[index + 4];
            float l1y = results[index + 5];
            float l2x = results[index + 6];
            float l2y = results[index + 7];
            float l3x = results[index + 8];
            float l3y = results[index + 9];
            float l4x = results[index + 10];
            float l4y = results[index + 11];
            float l5x = results[index + 12];
            float l5y = results[index + 13];
            float score = results[index + 14];
            Detection detection = new Detection(left, top, right, bottom, l1x, l1y, l2x, l2y, l3x, l3y, l4x, l4y, l5x, l5y, score, thumbnail);
            detections.add(detection);
        }
        if (detections.size() != 0) {
            return (Detection)detections.get(0);
        }
        return null;
    }

    static {
        System.loadLibrary("seventh-sense-ai-facedetection");
        instances = new HashMap();
    }
}

