/*
 * Decompiled with CFR 0.152.
 */
package ai.rev.speechtotext;

import ai.rev.speechtotext.ApiInterceptor;
import ai.rev.speechtotext.ErrorInterceptor;
import ai.rev.speechtotext.RevAiWebSocketListener;
import ai.rev.speechtotext.helpers.SDKHelper;
import ai.rev.speechtotext.models.streaming.ConnectedMessage;
import ai.rev.speechtotext.models.streaming.Hypothesis;
import ai.rev.speechtotext.models.streaming.SessionConfig;
import ai.rev.speechtotext.models.streaming.StreamContentType;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public class StreamingClient {
    private String accessToken;
    private OkHttpClient client;
    private WebSocket webSocket;
    private String scheme;
    private String host;
    private Integer port;

    public StreamingClient(String accessToken) {
        this.accessToken = accessToken;
        this.client = this.setClient();
    }

    public void setScheme(String scheme) {
        switch (scheme.toLowerCase()) {
            case "wss": 
            case "https": {
                this.scheme = "https";
                break;
            }
            case "ws": 
            case "http": {
                this.scheme = "http";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scheme: " + scheme);
            }
        }
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void connect(RevAiWebSocketListener revAiWebSocketListener, StreamContentType streamContentType, String metadata, SessionConfig sessionConfig) {
        Listener listener = new Listener(revAiWebSocketListener);
        String url = this.buildURL(metadata, streamContentType, sessionConfig);
        this.createWebSocketConnection(url, listener);
    }

    public void connect(RevAiWebSocketListener revAiWebSocketListener, StreamContentType streamContentType) {
        Listener listener = new Listener(revAiWebSocketListener);
        String url = this.buildURL(null, streamContentType, null);
        this.createWebSocketConnection(url, listener);
    }

    public void connect(RevAiWebSocketListener revAiWebSocketListener, StreamContentType streamContentType, String metadata) {
        Listener listener = new Listener(revAiWebSocketListener);
        String url = this.buildURL(metadata, streamContentType, null);
        this.createWebSocketConnection(url, listener);
    }

    public void connect(RevAiWebSocketListener revAiWebSocketListener, StreamContentType streamContentType, SessionConfig sessionConfig) {
        Listener listener = new Listener(revAiWebSocketListener);
        String url = this.buildURL(null, streamContentType, sessionConfig);
        this.createWebSocketConnection(url, listener);
    }

    public void sendAudioData(ByteString byteString) {
        this.webSocket.send(byteString);
    }

    public void close() {
        this.webSocket.send("EOS");
    }

    private void createWebSocketConnection(String url, Listener listener) {
        Request request = new Request.Builder().url(url).build();
        this.webSocket = this.client.newWebSocket(request, (WebSocketListener)listener);
    }

    private String buildURL(String metadata, StreamContentType streamContentType, SessionConfig sessionConfig) {
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder();
        if (this.scheme != null) {
            urlBuilder.scheme(this.scheme);
        } else {
            urlBuilder.scheme("https");
        }
        if (this.host != null) {
            urlBuilder.host(this.host);
        } else {
            urlBuilder.host("api.rev.ai");
        }
        if (this.port != null) {
            urlBuilder.port(this.port.intValue());
        }
        urlBuilder.addPathSegments("speechtotext/v1/stream");
        urlBuilder.addQueryParameter("access_token", this.accessToken);
        if (metadata != null) {
            urlBuilder.addQueryParameter("metadata", metadata);
        }
        if (sessionConfig != null) {
            if (sessionConfig.getCustomVocabularyId() != null) {
                urlBuilder.addQueryParameter("custom_vocabulary_id", sessionConfig.getCustomVocabularyId());
            }
            if (sessionConfig.getFilterProfanity() != null) {
                urlBuilder.addQueryParameter("filter_profanity", String.valueOf(sessionConfig.getFilterProfanity()));
            }
            if (sessionConfig.getRemoveDisfluencies() != null) {
                urlBuilder.addQueryParameter("remove_disfluencies", String.valueOf(sessionConfig.getRemoveDisfluencies()));
            }
            if (sessionConfig.getDeleteAfterSeconds() != null) {
                urlBuilder.addQueryParameter("delete_after_seconds", String.valueOf(sessionConfig.getDeleteAfterSeconds()));
            }
            if (sessionConfig.getDetailedPartials() != null) {
                urlBuilder.addQueryParameter("detailed_partials", String.valueOf(sessionConfig.getDetailedPartials()));
            }
            if (sessionConfig.getStartTs() != null) {
                urlBuilder.addQueryParameter("start_ts", String.valueOf(sessionConfig.getStartTs()));
            }
            if (sessionConfig.getTranscriber() != null) {
                urlBuilder.addQueryParameter("transcriber", sessionConfig.getTranscriber());
            }
        }
        return urlBuilder.build().toString() + "&content_type=" + streamContentType.buildContentString();
    }

    private OkHttpClient setClient() {
        return new OkHttpClient.Builder().addNetworkInterceptor((Interceptor)new ApiInterceptor(this.accessToken, SDKHelper.getSdkVersion())).addNetworkInterceptor((Interceptor)new ErrorInterceptor()).build();
    }

    private static class Listener
    extends WebSocketListener {
        private Gson gson = new Gson();
        private RevAiWebSocketListener revAiWebsocketListener;

        public Listener(RevAiWebSocketListener revAiWebsocketListener) {
            this.revAiWebsocketListener = revAiWebsocketListener;
        }

        public void onOpen(WebSocket webSocket, Response response) {
            this.revAiWebsocketListener.onOpen(response);
        }

        public void onMessage(WebSocket webSocket, String text) {
            JsonObject jsonObject = (JsonObject)this.gson.fromJson(text, JsonObject.class);
            String type = jsonObject.get("type").getAsString();
            if (type.equals("connected")) {
                this.revAiWebsocketListener.onConnected((ConnectedMessage)this.gson.fromJson(text, ConnectedMessage.class));
            } else if (type.equals("partial") || type.equals("final")) {
                this.revAiWebsocketListener.onHypothesis((Hypothesis)this.gson.fromJson(text, Hypothesis.class));
            }
        }

        public void onClosing(WebSocket webSocket, int code, String reason) {
            this.revAiWebsocketListener.onClose(code, reason);
        }

        public void onClosed(WebSocket webSocket, int code, String reason) {
            this.revAiWebsocketListener.onClose(code, reason);
        }

        public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            this.revAiWebsocketListener.onError(t, response);
        }
    }
}

