/*
 * Decompiled with CFR 0.152.
 */
package ai.pubtech.pubconsent.utility;

import ai.pubtech.pubconsent.utility.CmpLogger;
import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0012\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\n\u001a\u0012\u0010\u000b\u001a\u00020\u00072\n\u0010\f\u001a\u00060\tj\u0002`\n\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0001\u001a\u0012\u0010\u0011\u001a\u00020\u000e2\n\u0010\f\u001a\u00060\tj\u0002`\n\u00a8\u0006\u0012"}, d2={"buildJavaScriptForWebView", "", "consentSharingDTO", "buildQueryStringForCustomTab", "encodeURIComponent", "value", "handleMissingWebViewException", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handleWebViewException", "exception", "isNetworkAvailable", "", "context", "Landroid/content/Context;", "isWebViewMissingException", "pubconsent_release"})
public final class CmpUtilsKt {
    @SuppressLint(value={"ServiceCast"})
    public static final boolean isNetworkAvailable(@NotNull Context context) {
        boolean bl;
        ConnectivityManager connManager;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        ConnectivityManager connectivityManager = connManager = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
        if (Build.VERSION.SDK_INT >= 23) {
            NetworkCapabilities networkCapabilities;
            ConnectivityManager connectivityManager2 = connManager;
            NetworkCapabilities networkCapabilities2 = networkCapabilities = connectivityManager2 != null ? connectivityManager2.getNetworkCapabilities(connManager.getActiveNetwork()) : null;
            bl = networkCapabilities2 != null ? networkCapabilities2.hasCapability(12) : false;
        } else {
            NetworkInfo activeNetwork;
            ConnectivityManager connectivityManager3 = connManager;
            NetworkInfo networkInfo = activeNetwork = connectivityManager3 != null ? connectivityManager3.getActiveNetworkInfo() : null;
            bl = (networkInfo != null ? networkInfo.isConnectedOrConnecting() : false) && activeNetwork.isAvailable();
        }
        return bl;
    }

    public static final boolean isWebViewMissingException(@NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        String string = exception.getMessage();
        if (string == null) {
            return false;
        }
        String message = string;
        return exception instanceof RuntimeException && (StringsKt.contains$default((CharSequence)message, (CharSequence)"WebView provider", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)message, (CharSequence)"No WebView installed", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)message, (CharSequence)"Cannot load WebView", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)message, (CharSequence)"disableWebView", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)message, (CharSequence)"WebView is disabled", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)message, (CharSequence)"Error inflating class android.webkit.WebView", (boolean)false, (int)2, null));
    }

    public static final void handleWebViewException(@NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (!CmpUtilsKt.isWebViewMissingException(exception)) {
            throw exception;
        }
        CmpUtilsKt.handleMissingWebViewException(exception);
    }

    public static final void handleMissingWebViewException(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = e.getMessage();
        if (string == null) {
            string = "Error initializing WebView";
        }
        CmpLogger.INSTANCE.e(string);
    }

    @NotNull
    public static final String encodeURIComponent(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        return string;
    }

    @NotNull
    public static final String buildJavaScriptForWebView(@NotNull String consentSharingDTO) {
        Intrinsics.checkNotNullParameter((Object)consentSharingDTO, (String)"consentSharingDTO");
        return StringsKt.trimMargin$default((String)("\n            |window.PubConsentSharingAPI = {\n            |   getConsent: function fromAndroidAppSDK() {\n            |       return '" + consentSharingDTO + "';\n            |   }\n            |};\n            |const event = new Event(\"PubConsentSharingAPIReady\");\n            |window.dispatchEvent(event);\n        "), null, (int)1, null);
    }

    @NotNull
    public static final String buildQueryStringForCustomTab(@NotNull String consentSharingDTO) {
        Intrinsics.checkNotNullParameter((Object)consentSharingDTO, (String)"consentSharingDTO");
        return "pubconsent.externalConsent=" + CmpUtilsKt.encodeURIComponent(consentSharingDTO);
    }
}

