/*
 * Decompiled with CFR 0.152.
 */
package ai.pubtech.pubconsent.utility;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.preference.PreferenceManager;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000fJ\u0016\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\rJ\u0016\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0012J\u0016\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0014J\u0016\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fR\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lai/pubtech/pubconsent/utility/CmpPreferences;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "dateFormat", "Ljava/text/DateFormat;", "kotlin.jvm.PlatformType", "sharedPreferences", "Landroid/content/SharedPreferences;", "clear", "", "getBoolean", "", "key", "", "defaultValue", "getDate", "Ljava/util/Date;", "getInt", "", "getString", "removeKey", "removeKeyByRegex", "regex", "setBoolean", "value", "setDate", "date", "setInt", "setString", "pubconsent_release"})
@SourceDebugExtension(value={"SMAP\nCmpPreferences.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CmpPreferences.kt\nai/pubtech/pubconsent/utility/CmpPreferences\n+ 2 SharedPreferences.kt\nandroidx/core/content/SharedPreferencesKt\n*L\n1#1,90:1\n43#2,8:91\n43#2,8:99\n43#2,8:107\n43#2,8:115\n43#2,8:123\n43#2,8:131\n*S KotlinDebug\n*F\n+ 1 CmpPreferences.kt\nai/pubtech/pubconsent/utility/CmpPreferences\n*L\n20#1:91,8\n30#1:99,8\n40#1:107,8\n46#1:115,8\n52#1:123,8\n73#1:131,8\n*E\n"})
public final class CmpPreferences {
    private final SharedPreferences sharedPreferences;
    private final DateFormat dateFormat;

    public CmpPreferences(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.dateFormat = DateFormat.getDateInstance();
    }

    @NotNull
    public final String getString(@NotNull String key, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        String string = this.sharedPreferences.getString(key, defaultValue);
        if (string == null) {
            string = defaultValue;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void setString(@NotNull String key, @NotNull String value) {
        void $this$edit$iv;
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SharedPreferences sharedPreferences = this.sharedPreferences;
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"sharedPreferences");
        SharedPreferences sharedPreferences2 = sharedPreferences;
        boolean commit$iv = true;
        boolean $i$f$edit = false;
        SharedPreferences.Editor $this$setString_u24lambda_u240 = editor$iv = $this$edit$iv.edit();
        boolean bl = false;
        $this$setString_u24lambda_u240.putString(key, value);
        editor$iv.commit();
    }

    public final int getInt(@NotNull String key, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sharedPreferences.getInt(key, defaultValue);
    }

    /*
     * WARNING - void declaration
     */
    public final void setInt(@NotNull String key, int value) {
        void $this$edit$iv;
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences sharedPreferences = this.sharedPreferences;
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"sharedPreferences");
        SharedPreferences sharedPreferences2 = sharedPreferences;
        boolean commit$iv = true;
        boolean $i$f$edit = false;
        SharedPreferences.Editor $this$setInt_u24lambda_u241 = editor$iv = $this$edit$iv.edit();
        boolean bl = false;
        $this$setInt_u24lambda_u241.putInt(key, value);
        editor$iv.commit();
    }

    public final boolean getBoolean(@NotNull String key, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sharedPreferences.getBoolean(key, defaultValue);
    }

    /*
     * WARNING - void declaration
     */
    public final void setBoolean(@NotNull String key, boolean value) {
        void $this$edit$iv;
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences sharedPreferences = this.sharedPreferences;
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"sharedPreferences");
        SharedPreferences sharedPreferences2 = sharedPreferences;
        boolean commit$iv = true;
        boolean $i$f$edit = false;
        SharedPreferences.Editor $this$setBoolean_u24lambda_u242 = editor$iv = $this$edit$iv.edit();
        boolean bl = false;
        $this$setBoolean_u24lambda_u242.putBoolean(key, value);
        editor$iv.commit();
    }

    /*
     * WARNING - void declaration
     */
    public final void clear() {
        void $this$edit$iv;
        SharedPreferences.Editor editor$iv;
        SharedPreferences sharedPreferences = this.sharedPreferences;
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"sharedPreferences");
        SharedPreferences sharedPreferences2 = sharedPreferences;
        boolean commit$iv = true;
        boolean $i$f$edit = false;
        SharedPreferences.Editor $this$clear_u24lambda_u243 = editor$iv = $this$edit$iv.edit();
        boolean bl = false;
        $this$clear_u24lambda_u243.clear();
        editor$iv.commit();
    }

    /*
     * WARNING - void declaration
     */
    public final void removeKey(@NotNull String key) {
        void $this$edit$iv;
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences sharedPreferences = this.sharedPreferences;
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"sharedPreferences");
        SharedPreferences sharedPreferences2 = sharedPreferences;
        boolean commit$iv = true;
        boolean $i$f$edit = false;
        SharedPreferences.Editor $this$removeKey_u24lambda_u244 = editor$iv = $this$edit$iv.edit();
        boolean bl = false;
        $this$removeKey_u24lambda_u244.remove(key);
        editor$iv.commit();
    }

    public final void removeKeyByRegex(@NotNull String regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Map allEntries = this.sharedPreferences.getAll();
        Pattern pattern = Pattern.compile(regex);
        for (String key : allEntries.keySet()) {
            if (!pattern.matcher(key).matches()) continue;
            Intrinsics.checkNotNull((Object)key);
            this.removeKey(key);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setDate(@NotNull String key, @NotNull Date date) {
        void $this$edit$iv;
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        String dateString = this.dateFormat.format(date);
        SharedPreferences sharedPreferences = this.sharedPreferences;
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"sharedPreferences");
        SharedPreferences sharedPreferences2 = sharedPreferences;
        boolean commit$iv = true;
        boolean $i$f$edit = false;
        SharedPreferences.Editor $this$setDate_u24lambda_u245 = editor$iv = $this$edit$iv.edit();
        boolean bl = false;
        $this$setDate_u24lambda_u245.putString(key, dateString);
        editor$iv.commit();
    }

    @Nullable
    public final Date getDate(@NotNull String key, @Nullable Date defaultValue) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String dateString = this.sharedPreferences.getString(key, null);
        if (dateString != null) {
            Date date2;
            try {
                Date date3 = this.dateFormat.parse(dateString);
                if (date3 == null) {
                    date3 = defaultValue;
                }
                date2 = date3;
            }
            catch (Exception e) {
                date2 = defaultValue;
            }
            date = date2;
        } else {
            date = defaultValue;
        }
        return date;
    }

    public static /* synthetic */ Date getDate$default(CmpPreferences cmpPreferences, String string, Date date, int n, Object object) {
        if ((n & 2) != 0) {
            date = null;
        }
        return cmpPreferences.getDate(string, date);
    }
}

