/*
 * Decompiled with CFR 0.152.
 */
package ai.pubtech.pubconsent.repository;

import ai.pubtech.pubconsent.dto.incoming.CustomPurpose;
import ai.pubtech.pubconsent.dto.incoming.TCF;
import ai.pubtech.pubconsent.repository.IabTcfRepositoryKt;
import ai.pubtech.pubconsent.utility.CmpPreferences;
import android.content.Context;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/pubtech/pubconsent/repository/IabTcfRepository;", "", "()V", "Companion", "pubconsent_release"})
public final class IabTcfRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J&\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lai/pubtech/pubconsent/repository/IabTcfRepository$Companion;", "", "()V", "clear", "", "context", "Landroid/content/Context;", "getPurposeConsentsString", "", "getVendorConsentsString", "persistToSharedPreferences", "dto", "Lai/pubtech/pubconsent/dto/incoming/TCF;", "additionalConsent", "googleConsentMode", "", "pubconsent_release"})
    @SourceDebugExtension(value={"SMAP\nIabTcfRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IabTcfRepository.kt\nai/pubtech/pubconsent/repository/IabTcfRepository$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,80:1\n215#2,2:81\n*S KotlinDebug\n*F\n+ 1 IabTcfRepository.kt\nai/pubtech/pubconsent/repository/IabTcfRepository$Companion\n*L\n57#1:81,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void persistToSharedPreferences(@NotNull Context context, @NotNull TCF dto, @NotNull String additionalConsent, boolean googleConsentMode) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                Intrinsics.checkNotNullParameter((Object)additionalConsent, (String)"additionalConsent");
                CmpPreferences cmpPreferences = new CmpPreferences(context);
                cmpPreferences.setInt("IABTCF_CmpSdkID", dto.getCmpId());
                cmpPreferences.setInt("IABTCF_CmpSdkVersion", dto.getCmpVersion());
                cmpPreferences.setInt("IABTCF_PolicyVersion", dto.getTcfPolicyVersion());
                cmpPreferences.setInt("IABTCF_gdprApplies", IabTcfRepositoryKt.toInt(dto.getGdprApplies()));
                cmpPreferences.setInt("IABTCF_EnableAdvertiserConsentMode", IabTcfRepositoryKt.toInt(googleConsentMode));
                cmpPreferences.setInt("IABTCF_PurposeOneTreatment", IabTcfRepositoryKt.toInt(dto.getPurposeOneTreatment()));
                cmpPreferences.setInt("IABTCF_UseNonStandardTexts", IabTcfRepositoryKt.toInt(dto.getUseNonStandardTexts()));
                cmpPreferences.setString("IABTCF_AddtlConsent", additionalConsent);
                cmpPreferences.setString("IABTCF_PublisherCC", dto.getPublisherCC());
                cmpPreferences.setString("IABTCF_TCString", dto.getTcString());
                cmpPreferences.setString("IABTCF_VendorConsents", dto.getVendor().getConsents());
                cmpPreferences.setString("IABTCF_VendorLegitimateInterests", dto.getVendor().getLegitimateInterests());
                cmpPreferences.setString("IABTCF_PurposeConsents", dto.getPurpose().getConsents());
                cmpPreferences.setString("IABTCF_PurposeLegitimateInterests", dto.getPurpose().getLegitimateInterests());
                cmpPreferences.setString("IABTCF_SpecialFeaturesOptIns", dto.getSpecialFeatureOptins());
                cmpPreferences.setString("IABTCF_PublisherConsent", dto.getPublisher().getConsents());
                cmpPreferences.setString("IABTCF_PublisherLegitimateInterests", dto.getPublisher().getLegitimateInterests());
                Object object = dto.getPublisher().getCustomPurpose();
                if (object == null || (object = ((CustomPurpose)object).getConsents()) == null) {
                    object = "";
                }
                cmpPreferences.setString("IABTCF_PublisherCustomPurposesConsents", (String)object);
                Object object2 = dto.getPublisher().getCustomPurpose();
                if (object2 == null || (object2 = ((CustomPurpose)object2).getLegitimateInterests()) == null) {
                    object2 = "";
                }
                cmpPreferences.setString("IABTCF_PublisherCustomPurposesLegitimateInterests", (String)object2);
                Map<String, String> map = dto.getPublisher().getRestrictions();
                if (map == null) break block3;
                Map<String, String> $this$forEach$iv = map;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> element$iv;
                    Map.Entry<String, String> it = element$iv = iterator.next();
                    boolean bl = false;
                    cmpPreferences.setString("IABTCF_PublisherRestrictions" + it.getKey(), it.getValue());
                }
            }
        }

        @NotNull
        public final String getVendorConsentsString(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            CmpPreferences cmpPreferences = new CmpPreferences(context);
            return cmpPreferences.getString("IABTCF_VendorConsents", "");
        }

        @NotNull
        public final String getPurposeConsentsString(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            CmpPreferences cmpPreferences = new CmpPreferences(context);
            return cmpPreferences.getString("IABTCF_PurposeConsents", "");
        }

        public final void clear(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            CmpPreferences cmpPreferences = new CmpPreferences(context);
            cmpPreferences.removeKeyByRegex("IABTCF_.*");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

