/*
 * Decompiled with CFR 0.152.
 */
package ai.pubtech.pubconsent;

import ai.pubtech.pubconsent.CmpType;
import ai.pubtech.pubconsent.ConsentApiInterface;
import ai.pubtech.pubconsent.dto.GoogleConsentModeStatus;
import ai.pubtech.pubconsent.dto.GoogleConsentModeType;
import ai.pubtech.pubconsent.dto.incoming.CookiesChoices;
import ai.pubtech.pubconsent.dto.outgoing.consentSharing.TCFGdprConsentSharingDTO;
import ai.pubtech.pubconsent.repository.CmpTcfGdprConsent;
import ai.pubtech.pubconsent.repository.CmpTcfGdprConsentRepository;
import ai.pubtech.pubconsent.repository.GoogleConsentModeRepository;
import ai.pubtech.pubconsent.repository.IabTcfRepository;
import android.content.Context;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u000fJ\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lai/pubtech/pubconsent/TCFGDPRConsentApi;", "Lai/pubtech/pubconsent/ConsentApiInterface;", "applicationContext", "Landroid/content/Context;", "appName", "", "(Landroid/content/Context;Ljava/lang/String;)V", "getCmpType", "Lai/pubtech/pubconsent/CmpType;", "getConsentSharingDTO", "getGoogleConsentMode", "", "Lai/pubtech/pubconsent/dto/GoogleConsentModeType;", "Lai/pubtech/pubconsent/dto/GoogleConsentModeStatus;", "isFeatureCookiesEnabled", "", "isMeasurementCookiesEnabled", "isPurposeConsentEnabled", "purposeId", "", "isUserExperienceCookiesEnabled", "isVendorConsentEnabled", "vendorId", "pubconsent_release"})
public final class TCFGDPRConsentApi
implements ConsentApiInterface {
    @NotNull
    private final Context applicationContext;
    @NotNull
    private final String appName;

    public TCFGDPRConsentApi(@NotNull Context applicationContext, @NotNull String appName) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        this.applicationContext = applicationContext;
        this.appName = appName;
    }

    public final boolean isVendorConsentEnabled(int vendorId) {
        int vendorIdToVerify = vendorId - 1;
        String vendorConsentsString = IabTcfRepository.Companion.getVendorConsentsString(this.applicationContext);
        if (StringsKt.getLastIndex((CharSequence)vendorConsentsString) >= vendorIdToVerify) {
            return vendorConsentsString.charAt(vendorIdToVerify) == '1';
        }
        return false;
    }

    public final boolean isPurposeConsentEnabled(int purposeId) {
        int purposeIdToVerify = purposeId - 1;
        String purposeConsentsString = IabTcfRepository.Companion.getPurposeConsentsString(this.applicationContext);
        if (StringsKt.getLastIndex((CharSequence)purposeConsentsString) >= purposeIdToVerify) {
            return purposeConsentsString.charAt(purposeIdToVerify) == '1';
        }
        return false;
    }

    public final boolean isFeatureCookiesEnabled() {
        CookiesChoices cookiesChoices = CmpTcfGdprConsentRepository.Companion.getCookieChoices(this.applicationContext);
        return cookiesChoices != null ? cookiesChoices.getFeatureCookiesChoice() : false;
    }

    public final boolean isUserExperienceCookiesEnabled() {
        CookiesChoices cookiesChoices = CmpTcfGdprConsentRepository.Companion.getCookieChoices(this.applicationContext);
        return cookiesChoices != null ? cookiesChoices.getUserExperienceCookiesChoice() : false;
    }

    public final boolean isMeasurementCookiesEnabled() {
        CookiesChoices cookiesChoices = CmpTcfGdprConsentRepository.Companion.getCookieChoices(this.applicationContext);
        return cookiesChoices != null ? cookiesChoices.getMeasurementCookiesChoice() : false;
    }

    @Nullable
    public final Map<GoogleConsentModeType, GoogleConsentModeStatus> getGoogleConsentMode() {
        return GoogleConsentModeRepository.Companion.getGoogleConsentMode(this.applicationContext);
    }

    @Override
    @NotNull
    public CmpType getCmpType() {
        return CmpType.TCF_V2_GDPR;
    }

    @Override
    @NotNull
    public String getConsentSharingDTO() {
        CmpTcfGdprConsent cmpTcfGdprConsent = CmpTcfGdprConsentRepository.Companion.getCmpConsent(this.applicationContext);
        Intrinsics.checkNotNull((Object)cmpTcfGdprConsent);
        CmpTcfGdprConsent strings = cmpTcfGdprConsent;
        return new TCFGdprConsentSharingDTO(this.appName, strings.getTcString(), strings.getAcString(), strings.getPcString()).toJson();
    }

    @Override
    @NotNull
    public String getJavaScriptForWebView() {
        return ConsentApiInterface.DefaultImpls.getJavaScriptForWebView(this);
    }

    @Override
    @NotNull
    public String getQueryStringForCustomTab() {
        return ConsentApiInterface.DefaultImpls.getQueryStringForCustomTab(this);
    }
}

