/*
 * Decompiled with CFR 0.152.
 */
package ai.pubtech.pubconsent;

import ai.pubtech.pubconsent.CmpType;
import ai.pubtech.pubconsent.ConsentApiInterface;
import ai.pubtech.pubconsent.dto.GoogleConsentModeStatus;
import ai.pubtech.pubconsent.dto.GoogleConsentModeType;
import ai.pubtech.pubconsent.dto.outgoing.consentSharing.GcmConsentSharingDTO;
import ai.pubtech.pubconsent.repository.CmpGcmConsent;
import ai.pubtech.pubconsent.repository.CmpGcmConsentRepository;
import ai.pubtech.pubconsent.repository.GoogleConsentModeRepository;
import android.content.Context;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lai/pubtech/pubconsent/GCMConsentApi;", "Lai/pubtech/pubconsent/ConsentApiInterface;", "applicationContext", "Landroid/content/Context;", "appName", "", "(Landroid/content/Context;Ljava/lang/String;)V", "getCmpType", "Lai/pubtech/pubconsent/CmpType;", "getConsentSharingDTO", "getGoogleConsentMode", "", "Lai/pubtech/pubconsent/dto/GoogleConsentModeType;", "Lai/pubtech/pubconsent/dto/GoogleConsentModeStatus;", "pubconsent_release"})
public final class GCMConsentApi
implements ConsentApiInterface {
    @NotNull
    private final Context applicationContext;
    @NotNull
    private final String appName;

    public GCMConsentApi(@NotNull Context applicationContext, @NotNull String appName) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        this.applicationContext = applicationContext;
        this.appName = appName;
    }

    @Nullable
    public final Map<GoogleConsentModeType, GoogleConsentModeStatus> getGoogleConsentMode() {
        return GoogleConsentModeRepository.Companion.getGoogleConsentMode(this.applicationContext);
    }

    @Override
    @NotNull
    public CmpType getCmpType() {
        return CmpType.GOOGLE_CONSENT_MODE;
    }

    @Override
    @NotNull
    public String getConsentSharingDTO() {
        CmpGcmConsent cmpGcmConsent = CmpGcmConsentRepository.Companion.getCmpConsent(this.applicationContext);
        Intrinsics.checkNotNull((Object)cmpGcmConsent);
        CmpGcmConsent strings = cmpGcmConsent;
        return new GcmConsentSharingDTO(this.appName, strings.getGcmString()).toJson();
    }

    @Override
    @NotNull
    public String getJavaScriptForWebView() {
        return ConsentApiInterface.DefaultImpls.getJavaScriptForWebView(this);
    }

    @Override
    @NotNull
    public String getQueryStringForCustomTab() {
        return ConsentApiInterface.DefaultImpls.getQueryStringForCustomTab(this);
    }
}

