/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import water.DTask;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.RPC;
import water.util.LinuxProcFileReader;
import water.util.Log;

public class WaterMeterCpuTicks
extends Iced {
    public int nodeidx;
    public long[][] cpu_ticks;

    public void doIt() {
        H2ONode node = H2O.CLOUD._memary[this.nodeidx];
        GetTicksTask ppt = new GetTicksTask();
        Log.trace("GetTicksTask starting to node " + this.nodeidx + "...");
        new RPC<GetTicksTask>(node, ppt).call().get();
        Log.trace("GetTicksTask completed to node " + this.nodeidx);
        this.cpu_ticks = ppt._cpuTicks;
    }

    private static class GetTicksTask
    extends DTask<GetTicksTask> {
        private long[][] _cpuTicks = null;

        public GetTicksTask() {
            super((byte)119);
        }

        @Override
        public void compute2() {
            LinuxProcFileReader lpfr = new LinuxProcFileReader();
            lpfr.read();
            this._cpuTicks = lpfr.valid() ? lpfr.getCpuTicks() : new long[0][0];
            this.tryComplete();
        }
    }
}

