/*
 * Decompiled with CFR 0.152.
 */
package water.server;

import java.util.Objects;
import javax.servlet.http.HttpServlet;

public class ServletMeta {
    private String _contextPath;
    private Class<? extends HttpServlet> _servletClass;
    private boolean _alwaysEnabled;

    public ServletMeta(String contextPath, Class<? extends HttpServlet> servletClass) {
        Objects.requireNonNull(contextPath);
        Objects.requireNonNull(servletClass);
        this._contextPath = contextPath;
        this._servletClass = servletClass;
        this._alwaysEnabled = false;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public Class<? extends HttpServlet> getServletClass() {
        return this._servletClass;
    }

    public boolean isAlwaysEnabled() {
        return this._alwaysEnabled;
    }

    public static class Builder {
        private final ServletMeta servletMeta;

        public Builder(String contextPath, Class<? extends HttpServlet> servletClass) {
            Objects.requireNonNull(contextPath);
            Objects.requireNonNull(servletClass);
            this.servletMeta = new ServletMeta(contextPath, servletClass);
        }

        public ServletMeta build() {
            return this.servletMeta;
        }

        public Builder withAlwaysEnabled(boolean alwaysEnabled) {
            this.servletMeta._alwaysEnabled = alwaysEnabled;
            return this;
        }
    }
}

