/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.testing;

import water.MRTask;
import water.rapids.Val;
import water.rapids.ast.AstBuiltin;
import water.rapids.vals.ValStr;
import water.testing.SandboxSecurityManager;

public class AstSetReadForbidden
extends AstBuiltin<AstSetReadForbidden> {
    @Override
    public String[] args() {
        return new String[]{"forbidden"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "testing.setreadforbidden";
    }

    @Override
    protected ValStr exec(Val[] args) {
        CharSequence[] forbidden = args[1].getStrs();
        if (forbidden.length > 0) {
            new SetForbiddenTask((String[])forbidden).doAllNodes();
        } else {
            new ClearForbiddenTask().doAllNodes();
        }
        return new ValStr(String.join((CharSequence)", ", forbidden));
    }

    private static class ClearForbiddenTask
    extends MRTask<SetForbiddenTask> {
        private ClearForbiddenTask() {
        }

        @Override
        protected void setupLocal() {
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                return;
            }
            if (!(sm instanceof SandboxSecurityManager)) {
                throw new IllegalStateException("Unexpected Security Manager: " + sm);
            }
            System.setSecurityManager(null);
        }
    }

    private static class SetForbiddenTask
    extends MRTask<SetForbiddenTask> {
        private final String[] _forbidden;

        private SetForbiddenTask(String[] forbidden) {
            this._forbidden = forbidden;
        }

        @Override
        protected void setupLocal() {
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                System.setSecurityManager(new SandboxSecurityManager());
                sm = System.getSecurityManager();
            }
            if (!(sm instanceof SandboxSecurityManager)) {
                throw new IllegalStateException("Unexpected Security Manager: " + sm);
            }
            ((SandboxSecurityManager)sm).setForbiddenReadPrefixes(this._forbidden);
        }
    }
}

