/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.filters.dropduplicates;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;

public class DropDuplicateRowsTask
extends MRTask<DropDuplicateRowsTask> {
    final Frame chunkBoundaries;
    private final int[] comparedColumnIndices;

    public DropDuplicateRowsTask(Frame chunkBoundaries, int[] comparedColumnIndices) {
        this.chunkBoundaries = chunkBoundaries;
        this.comparedColumnIndices = comparedColumnIndices;
    }

    @Override
    public void map(Chunk[] chunks, NewChunk[] newChunks) {
        int chunkLength = chunks[0].len();
        int chunkId = chunks[0].cidx();
        for (int row = 0; row < chunkLength; ++row) {
            int columnIndex;
            if (chunkId == 0 && row == 0) {
                for (columnIndex = 0; columnIndex < chunks.length; ++columnIndex) {
                    chunks[columnIndex].extractRows(newChunks[columnIndex], row);
                }
                continue;
            }
            boolean equal = chunkId != 0 && row == 0 ? this.compareFirstRowWithPreviousChunk(chunks, row, chunkId) : this.compareRows(chunks, row, chunks, row - 1);
            if (equal) continue;
            for (columnIndex = 0; columnIndex < chunks.length; ++columnIndex) {
                chunks[columnIndex].extractRows(newChunks[columnIndex], row);
            }
        }
    }

    private boolean compareFirstRowWithPreviousChunk(Chunk[] chunks, int row, int chunkId) {
        Chunk[] previousRowChunks = new Chunk[this.chunkBoundaries.numCols()];
        for (int column = 0; column < this.chunkBoundaries.numCols(); ++column) {
            previousRowChunks[column] = this.chunkBoundaries.vec(column).chunkForChunkIdx(chunkId - 1);
        }
        return this.compareRows(chunks, row, previousRowChunks, 0);
    }

    private boolean compareRows(Chunk[] chunksA, int rowA, Chunk[] chunksB, int rowB) {
        block4: for (int column : this.comparedColumnIndices) {
            boolean isPreviousNA = chunksA[column].isNA(rowA);
            boolean isCurrentNA = chunksB[column].isNA(rowB);
            if (isPreviousNA || isCurrentNA) {
                return isPreviousNA && isCurrentNA;
            }
            switch (chunksA[column].vec().get_type()) {
                case 3: {
                    double previousDoubleValue = chunksA[column].atd(rowA);
                    double currentDoubleValue = chunksB[column].atd(rowB);
                    if (previousDoubleValue == currentDoubleValue) continue block4;
                    return false;
                }
                case 4: 
                case 5: {
                    long previousTimeValue = chunksA[column].at8(rowA);
                    long currentTimeValue = chunksB[column].at8(rowB);
                    if (previousTimeValue == currentTimeValue) continue block4;
                    return false;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + chunksA[column].vec().get_type());
                }
            }
        }
        return true;
    }
}

