/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.filters.dropduplicates;

import java.util.Arrays;
import water.Key;
import water.Scope;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Merge;
import water.rapids.ast.prims.filters.dropduplicates.CollectChunkBorderValuesTask;
import water.rapids.ast.prims.filters.dropduplicates.DropDuplicateRowsTask;
import water.rapids.ast.prims.filters.dropduplicates.KeepOrder;
import water.util.ArrayUtils;

public class DropDuplicateRows {
    private static final String LABEL_COLUMN_NAME = "label";
    final Frame sourceFrame;
    final int[] comparedColumnIndices;
    final KeepOrder keepOrder;

    public DropDuplicateRows(Frame sourceFrame, int[] comparedColumnIndices, KeepOrder keepOrder) {
        this.sourceFrame = sourceFrame;
        this.comparedColumnIndices = comparedColumnIndices;
        this.keepOrder = keepOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame dropDuplicates() {
        Frame outputFrame = null;
        try {
            Scope.enter();
            Vec labelVec = Scope.track(Vec.makeSeq(1L, this.sourceFrame.numRows()));
            Frame fr = new Frame(this.sourceFrame);
            fr.add(LABEL_COLUMN_NAME, labelVec);
            Frame sortedFrame = Scope.track(this.sortByComparedColumns(fr));
            Frame chunkBoundaries = Scope.track(((CollectChunkBorderValuesTask)new CollectChunkBorderValuesTask().doAll(sortedFrame.types(), sortedFrame)).outputFrame(null, sortedFrame.names(), sortedFrame.domains()));
            Frame deDuplicatedFrame = Scope.track(((DropDuplicateRowsTask)new DropDuplicateRowsTask(chunkBoundaries, this.comparedColumnIndices).doAll(sortedFrame.types(), sortedFrame)).outputFrame(null, sortedFrame.names(), sortedFrame.domains()));
            chunkBoundaries.remove();
            sortedFrame.remove();
            outputFrame = Scope.track(Merge.sort(deDuplicatedFrame, deDuplicatedFrame.numCols() - 1));
            outputFrame.remove(outputFrame.numCols() - 1).remove();
            Frame frame = outputFrame;
            return frame;
        }
        finally {
            if (outputFrame != null) {
                Scope.exit(outputFrame.keys());
            } else {
                Scope.exit(new Key[0]);
            }
        }
    }

    private Frame sortByComparedColumns(Frame fr) {
        int labelColumnIndex = fr.find(LABEL_COLUMN_NAME);
        int[] sortByColumns = ArrayUtils.append(this.comparedColumnIndices, labelColumnIndex);
        boolean ascendingSort = KeepOrder.First == this.keepOrder;
        int[] sortOrder = new int[sortByColumns.length];
        Arrays.fill(sortOrder, 0, sortOrder.length - 1, Merge.ASCENDING);
        sortOrder[sortOrder.length - 1] = ascendingSort ? Merge.ASCENDING : Merge.DESCENDING;
        return Merge.sort(fr, sortByColumns, sortOrder);
    }
}

