/*
 * Decompiled with CFR 0.152.
 */
package water.network;

import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import water.util.Log;

class SSLSocketChannel
implements ByteChannel {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private ByteBuffer netInBuffer;
    private ByteBuffer netOutBuffer;
    private ByteBuffer peerAppData;
    private SocketChannel channel = null;
    private SSLEngine sslEngine = null;
    private boolean closing = false;
    private boolean closed = false;
    private boolean handshakeComplete = false;
    private SSLEngineResult.HandshakeStatus hs;

    SSLSocketChannel(SocketChannel channel, SSLEngine sslEngine) throws IOException {
        this.channel = channel;
        this.sslEngine = sslEngine;
        sslEngine.setEnableSessionCreation(true);
        SSLSession session = sslEngine.getSession();
        this.prepareBuffers(session);
        this.handshake();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.closing = true;
        this.sslEngine.closeOutbound();
        this.sslEngine.getSession().invalidate();
        this.netOutBuffer.clear();
        this.channel.close();
        this.closed = true;
    }

    private void prepareBuffers(SSLSession session) throws SocketException {
        int appBufferSize = session.getApplicationBufferSize();
        this.peerAppData = ByteBuffer.allocate(appBufferSize + 64);
        int netBufferSize = session.getPacketBufferSize();
        this.netInBuffer = ByteBuffer.allocate(netBufferSize);
        this.netOutBuffer = ByteBuffer.allocate(netBufferSize);
    }

    private void handshake() throws IOException {
        Log.debug("Starting SSL handshake...");
        this.sslEngine.beginHandshake();
        this.hs = this.sslEngine.getHandshakeStatus();
        while (!this.handshakeComplete) {
            switch (this.hs) {
                case NOT_HANDSHAKING: {
                    throw new IOException("NOT_HANDSHAKING during handshake");
                }
                case FINISHED: {
                    this.handshakeComplete = !this.netOutBuffer.hasRemaining();
                    break;
                }
                case NEED_WRAP: {
                    SSLEngineResult initHandshakeStatus = this.handshakeWrap();
                    if (initHandshakeStatus.getStatus() != SSLEngineResult.Status.OK || this.hs != SSLEngineResult.HandshakeStatus.NEED_TASK) break;
                    this.tasks();
                    break;
                }
                case NEED_UNWRAP: {
                    SSLEngineResult initHandshakeStatus = this.handshakeUnwrap();
                    if (initHandshakeStatus.getStatus() != SSLEngineResult.Status.OK || this.hs != SSLEngineResult.HandshakeStatus.NEED_TASK) break;
                    this.tasks();
                    break;
                }
                case NEED_TASK: {
                    this.tasks();
                }
            }
        }
        Log.debug("SSL handshake finished successfully!");
    }

    private synchronized SSLEngineResult handshakeWrap() throws IOException {
        this.netOutBuffer.clear();
        SSLEngineResult wrapResult = this.sslEngine.wrap(EMPTY_BUFFER, this.netOutBuffer);
        this.netOutBuffer.flip();
        this.hs = wrapResult.getHandshakeStatus();
        this.channel.write(this.netOutBuffer);
        return wrapResult;
    }

    private synchronized SSLEngineResult handshakeUnwrap() throws IOException {
        SSLEngineResult unwrapResult;
        if (this.netInBuffer.position() == this.netInBuffer.limit()) {
            this.netInBuffer.clear();
        }
        this.channel.read(this.netInBuffer);
        this.peerAppData.clear();
        block4: do {
            this.netInBuffer.flip();
            unwrapResult = this.sslEngine.unwrap(this.netInBuffer, this.peerAppData);
            this.netInBuffer.compact();
            this.hs = unwrapResult.getHandshakeStatus();
            switch (unwrapResult.getStatus()) {
                case OK: 
                case BUFFER_UNDERFLOW: {
                    if (unwrapResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue block4;
                    this.tasks();
                    break;
                }
                case BUFFER_OVERFLOW: {
                    int applicationBufferSize = this.sslEngine.getSession().getApplicationBufferSize();
                    if (applicationBufferSize > this.peerAppData.capacity()) {
                        ByteBuffer b = ByteBuffer.allocate(applicationBufferSize + this.peerAppData.position());
                        this.peerAppData.flip();
                        b.put(this.peerAppData);
                        this.peerAppData = b;
                        break;
                    }
                    this.peerAppData.compact();
                    break;
                }
                default: {
                    throw new IOException("Failed to SSL unwrap with status " + (Object)((Object)unwrapResult.getStatus()));
                }
            }
        } while (unwrapResult.getStatus() == SSLEngineResult.Status.OK && this.hs == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
        return unwrapResult;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.closing || this.closed) {
            return -1;
        }
        return this.unwrap(dst);
    }

    private synchronized int unwrap(ByteBuffer dst) throws IOException {
        int read = 0;
        if (!dst.hasRemaining()) {
            return 0;
        }
        if (this.peerAppData.position() != 0) {
            return read += this.copy(this.peerAppData, dst);
        }
        if (this.netInBuffer.position() == 0) {
            this.channel.read(this.netInBuffer);
        }
        block5: while (this.netInBuffer.position() != 0) {
            this.netInBuffer.flip();
            if (this.peerAppData.position() != 0) {
                this.peerAppData.compact();
            }
            SSLEngineResult unwrapResult = this.sslEngine.unwrap(this.netInBuffer, this.peerAppData);
            switch (unwrapResult.getStatus()) {
                case OK: {
                    unwrapResult.bytesProduced();
                    if (unwrapResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) break;
                    this.tasks();
                    break;
                }
                case BUFFER_OVERFLOW: {
                    ByteBuffer b;
                    int applicationBufferSize = this.sslEngine.getSession().getApplicationBufferSize();
                    if (applicationBufferSize > this.peerAppData.capacity()) {
                        int appSize = applicationBufferSize;
                        b = ByteBuffer.allocate(appSize + this.peerAppData.position());
                        this.peerAppData.flip();
                        b.put(this.peerAppData);
                        this.peerAppData = b;
                        break;
                    }
                    this.netInBuffer.position(this.netInBuffer.limit());
                    this.netInBuffer.limit(this.netInBuffer.capacity());
                    this.peerAppData.compact();
                    if (dst.hasRemaining()) break;
                    return read;
                }
                case BUFFER_UNDERFLOW: {
                    ByteBuffer b;
                    int packetBufferSize = this.sslEngine.getSession().getPacketBufferSize();
                    if (packetBufferSize > this.netInBuffer.capacity()) {
                        int netSize = packetBufferSize;
                        if (netSize <= this.netInBuffer.capacity()) break;
                        b = ByteBuffer.allocate(netSize);
                        this.netInBuffer.flip();
                        b.put(this.netInBuffer);
                        this.netInBuffer = b;
                        break;
                    }
                    this.netInBuffer.position(this.netInBuffer.limit());
                    this.netInBuffer.limit(this.netInBuffer.capacity());
                    this.channel.read(this.netInBuffer);
                    continue block5;
                }
                default: {
                    throw new IOException("Failed to SSL unwrap with status " + (Object)((Object)unwrapResult.getStatus()));
                }
            }
            if (this.peerAppData != dst && dst.hasRemaining()) {
                this.peerAppData.flip();
                read += this.copy(this.peerAppData, dst);
                if (!dst.hasRemaining()) {
                    this.netInBuffer.compact();
                    return read;
                }
            }
            this.netInBuffer.compact();
        }
        return read;
    }

    private int copy(ByteBuffer src, ByteBuffer dst) {
        int toCopy = Math.min(src.remaining(), dst.remaining());
        dst.put(src.array(), src.position(), toCopy);
        src.position(src.position() + toCopy);
        if (!src.hasRemaining()) {
            src.clear();
        }
        return toCopy;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.closing || this.closed) {
            throw new IOException("Cannot perform socket write, the socket is closed (or being closed).");
        }
        int wrote = 0;
        while (src.hasRemaining()) {
            this.netOutBuffer.clear();
            SSLEngineResult wrapResult = this.sslEngine.wrap(src, this.netOutBuffer);
            this.netOutBuffer.flip();
            if (wrapResult.getStatus() == SSLEngineResult.Status.OK && wrapResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                this.tasks();
            }
            while (this.netOutBuffer.hasRemaining()) {
                wrote += this.channel.write(this.netOutBuffer);
            }
        }
        return wrote;
    }

    private void tasks() {
        Runnable r;
        while ((r = this.sslEngine.getDelegatedTask()) != null) {
            r.run();
        }
        this.hs = this.sslEngine.getHandshakeStatus();
    }

    public SocketChannel channel() {
        return this.channel;
    }

    SSLEngine getEngine() {
        return this.sslEngine;
    }

    boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }
}

