/*
 * Decompiled with CFR 0.152.
 */
package water.network;

import java.io.File;
import java.util.Properties;

class SSLProperties
extends Properties {
    private final File _pathRoot;

    SSLProperties(File pathRoot) {
        this._pathRoot = pathRoot;
    }

    SSLProperties() {
        this((File)null);
    }

    String[] h2o_ssl_enabled_algorithms() {
        String algs = this.getProperty("h2o_ssl_enabled_algorithms");
        if (null != algs) {
            return algs.split(",");
        }
        return null;
    }

    String h2o_ssl_protocol(String defaultTLS) {
        return this.getProperty("h2o_ssl_protocol", defaultTLS);
    }

    String h2o_ssl_jks_internal() {
        return this.expandPath(this.getProperty("h2o_ssl_jks_internal"));
    }

    String h2o_ssl_jks_password() {
        return this.getProperty("h2o_ssl_jks_password");
    }

    String h2o_ssl_jts() {
        String jts = this.getProperty("h2o_ssl_jts");
        if (jts == null) {
            return this.h2o_ssl_jks_internal();
        }
        return this.expandPath(jts);
    }

    String h2o_ssl_jts_password() {
        return this.getProperty("h2o_ssl_jts_password") != null ? this.getProperty("h2o_ssl_jts_password") : this.getProperty("h2o_ssl_jks_password");
    }

    String expandPath(String path) {
        if (path == null) {
            return null;
        }
        if (this._pathRoot == null) {
            return path;
        }
        if (new File(path).isAbsolute()) {
            return path;
        }
        return new File(this._pathRoot, path).getAbsolutePath();
    }

    File getPathRoot() {
        return this._pathRoot;
    }
}

