/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.DKV;
import water.Futures;
import water.Key;
import water.fvec.FileVec;
import water.fvec.Frame;
import water.fvec.Vec;

public class S3FileVec
extends FileVec {
    private S3FileVec(Key key, long len) {
        super(key, len, (byte)3);
    }

    public static Key make(String path, long size) {
        Futures fs = new Futures();
        Key key = S3FileVec.make(path, size, fs);
        fs.blockForPending();
        return key;
    }

    public static Key make(String path, long size, Futures fs) {
        Key<Frame> k = Key.make(path);
        Key<Vec> k2 = Vec.newKey(k);
        new Frame(k).delete_and_lock();
        S3FileVec v = new S3FileVec(k2, size);
        DKV.put(k2, v, fs);
        Frame fr = new Frame(k, new String[]{path}, new Vec[]{v});
        fr.update();
        fr.unlock();
        return k;
    }
}

