/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.DKV;
import water.Key;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;

public class ChunkUtils {
    public static NewChunk[] createNewChunks(String name, byte[] vecTypes, int chunkId) {
        return Frame.createNewChunks(name, vecTypes, chunkId);
    }

    public static NewChunk[] createNewChunks(String name, byte[] vecTypes, int chunkId, boolean[] sparse) {
        return Frame.createNewChunks(name, vecTypes, chunkId, sparse);
    }

    public static void closeNewChunks(NewChunk[] nchks) {
        Frame.closeNewChunks(nchks);
    }

    public static Chunk[] getChunks(Frame fr, int cidx) {
        Chunk[] chunks = new Chunk[fr.vecs().length];
        for (int i = 0; i < fr.vecs().length; ++i) {
            chunks[i] = fr.vec(i).chunkForChunkIdx(cidx);
        }
        return chunks;
    }

    public static void initFrame(String keyName, String[] names) {
        Frame fr = new Frame(Key.make(keyName));
        fr.preparePartialFrame(names);
        fr.update();
    }

    public static Frame finalizeFrame(String keyName, long[] rowsPerChunk, byte[] colTypes, String[][] colDomains) {
        return ChunkUtils.finalizeFrame(keyName, rowsPerChunk, colTypes, colDomains, true);
    }

    public static Frame finalizeFrame(String keyName, long[] rowsPerChunk, byte[] colTypes, String[][] colDomains, boolean unlock) {
        Frame fr = (Frame)DKV.getGet(keyName);
        fr.finalizePartialFrame(rowsPerChunk, colDomains, colTypes, unlock);
        return fr;
    }
}

