/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.util.UnsafeUtils;

public class C8Chunk
extends Chunk {
    protected static final long _NA = Long.MIN_VALUE;

    C8Chunk(byte[] bs) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length >> 3);
    }

    @Override
    protected final long at8_impl(int i) {
        long res = UnsafeUtils.get8(this._mem, i << 3);
        if (res == Long.MIN_VALUE) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return res;
    }

    @Override
    protected final double atd_impl(int i) {
        long res = UnsafeUtils.get8(this._mem, i << 3);
        return res == Long.MIN_VALUE ? Double.NaN : (double)res;
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return UnsafeUtils.get8(this._mem, i << 3) == Long.MIN_VALUE;
    }

    @Override
    boolean set_impl(int idx, long l) {
        return false;
    }

    @Override
    boolean set_impl(int i, double d) {
        return false;
    }

    @Override
    boolean set_impl(int i, float f) {
        return false;
    }

    @Override
    boolean setNA_impl(int idx) {
        UnsafeUtils.set8(this._mem, idx << 3, Long.MIN_VALUE);
        return true;
    }

    @Override
    public final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length >> 3);
        assert (this._mem.length == this._len << 3);
    }

    @Override
    public boolean hasFloat() {
        return false;
    }

    private final void processRow(int r, ChunkVisitor v) {
        long l = UnsafeUtils.get8(this._mem, r << 3);
        if (l == Long.MIN_VALUE) {
            v.addNAs(1);
        } else {
            v.addValue(l);
        }
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v, int from, int to) {
        for (int i = from; i < to; ++i) {
            this.processRow(i, v);
        }
        return v;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v, int[] ids) {
        for (int i : ids) {
            this.processRow(i, v);
        }
        return v;
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to, double NA) {
        for (int i = from; i < to; ++i) {
            long x = UnsafeUtils.get8(this._mem, 8 * i);
            vals[i - from] = x == Long.MIN_VALUE ? NA : (double)x;
        }
        return vals;
    }

    @Override
    public double[] getDoubles(double[] vals, int[] ids) {
        int k = 0;
        for (int i : ids) {
            long x = UnsafeUtils.get8(this._mem, 8 * i);
            vals[k++] = x == Long.MIN_VALUE ? Double.NaN : (double)x;
        }
        return vals;
    }
}

