/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import com.google.gson.Gson;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.Value;
import water.api.API;
import water.api.H2oRestGsonHelper;
import water.api.SchemaMetadata;
import water.api.SchemaServer;
import water.api.schemas3.FrameV3;
import water.api.schemas3.JobV3;
import water.api.schemas3.KeyV3;
import water.api.schemas3.ModelSchemaV3;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.fvec.Frame;
import water.util.EnumUtils;
import water.util.IcedHashMapGeneric;
import water.util.Log;
import water.util.MarkdownBuilder;
import water.util.PojoUtils;
import water.util.ReflectionUtils;

public abstract class Schema<I extends Iced, S extends Schema<I, S>>
extends Iced {
    private transient Class<I> _impl_class;
    private transient int _schema_version;
    private transient String _schema_name;
    private transient String _schema_type;
    private static final transient Gson gson = H2oRestGsonHelper.createH2oCompatibleGson();

    public Schema() {
        this.init_meta();
        SchemaServer.checkIfRegistered(this);
    }

    public Schema(I impl) {
        this();
        this.fillFromImpl(impl);
    }

    public void init_meta() {
        if (this._schema_name != null) {
            return;
        }
        this._schema_name = this.getClass().getSimpleName();
        this._schema_version = Schema.extractVersionFromSchemaName(this._schema_name);
        this._schema_type = this.getImplClass().getSimpleName();
    }

    public static int extractVersionFromSchemaName(String clz_name) {
        int idx = clz_name.lastIndexOf(86);
        if (idx == -1) {
            return -1;
        }
        try {
            return Integer.valueOf(clz_name.substring(idx + 1));
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public int getSchemaVersion() {
        return this._schema_version;
    }

    public String getSchemaName() {
        return this._schema_name;
    }

    public String getSchemaType() {
        return this._schema_type;
    }

    public void setSchemaType_doNotCall(String s) {
        this._schema_type = s;
    }

    public I createImpl() {
        try {
            return (I)((Iced)this.getImplClass().newInstance());
        }
        catch (Exception e) {
            throw H2O.fail("Exception making a newInstance", e);
        }
    }

    protected I fillImpl(I impl, String[] fieldsToSkip) {
        PojoUtils.copyProperties(impl, this, PojoUtils.FieldNaming.CONSISTENT, fieldsToSkip);
        PojoUtils.copyProperties(impl, this, PojoUtils.FieldNaming.DEST_HAS_UNDERSCORES, fieldsToSkip);
        return impl;
    }

    public I fillImpl(I impl) {
        return this.fillImpl(impl, null);
    }

    public final I createAndFillImpl() {
        return this.fillImpl(this.createImpl());
    }

    public final S fillFromImpl() {
        return this.fillFromImpl(this.createImpl(), null);
    }

    public S fillFromImpl(I impl) {
        return this.fillFromImpl(impl, null);
    }

    protected S fillFromImpl(I impl, String[] fieldsToSkip) {
        PojoUtils.copyProperties(this, impl, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES, fieldsToSkip);
        PojoUtils.copyProperties(this, impl, PojoUtils.FieldNaming.CONSISTENT, fieldsToSkip);
        return (S)this;
    }

    public static Class<? extends Iced> getImplClass(Class<? extends Schema> clz) {
        Class impl_class = ReflectionUtils.findActualClassParameter(clz, 0);
        if (null == impl_class) {
            Log.warn("Failed to find an impl class for Schema: " + clz);
        }
        return impl_class;
    }

    public Class<I> getImplClass() {
        return this._impl_class != null ? this._impl_class : (this._impl_class = ReflectionUtils.findActualClassParameter(this.getClass(), 0));
    }

    public S fillFromParms(Properties parms) {
        return this.fillFromParms(parms, true);
    }

    public S fillFromParms(Properties parms, boolean checkRequiredFields) {
        return this.fillFromParms(parms, null, checkRequiredFields);
    }

    public S fillFromParms(Properties parms, Properties unknownParms, boolean checkRequiredFields) {
        Class<?> thisSchemaClass = this.getClass();
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Field current = null;
        try {
            Class<?> clz = thisSchemaClass;
            do {
                Field[] some_fields;
                Field[] fieldArray = some_fields = clz.getDeclaredFields();
                int n = fieldArray.length;
                for (int i = 0; i < n; ++i) {
                    Field f;
                    current = f = fieldArray[i];
                    if (null != fields.get(f.getName())) continue;
                    fields.put(f.getName(), f);
                }
            } while (Iced.class.isAssignableFrom((clz = clz.getSuperclass()).getSuperclass()));
        }
        catch (SecurityException e) {
            throw H2O.fail("Exception accessing field: " + current + " in class: " + this.getClass() + ": " + e);
        }
        for (String key : parms.stringPropertyNames()) {
            try {
                Field f = (Field)fields.get(key);
                if (null == f) {
                    if (unknownParms != null) {
                        unknownParms.put(key, parms.getProperty(key));
                        continue;
                    }
                    throw new H2OIllegalArgumentException("Unknown parameter: " + key, "Unknown parameter in fillFromParms: " + key + " for class: " + this.getClass().toString());
                }
                int mods = f.getModifiers();
                if (Modifier.isTransient(mods) || Modifier.isStatic(mods)) {
                    throw new H2OIllegalArgumentException("Bad parameter for field: " + key + " for class: " + this.getClass().toString(), "Bad parameter definition for field: " + key + " in fillFromParms for class: " + this.getClass().toString() + " (field was declared static or transient)");
                }
                Annotation[] apis = f.getAnnotations();
                if (apis.length == 0) {
                    throw H2O.fail("Broken internal schema; missing API annotation for field: " + key);
                }
                API api = (API)apis[0];
                if (api.direction() == API.Direction.OUTPUT) {
                    throw new H2OIllegalArgumentException("Attempting to set output field: " + key + " for class: " + this.getClass().toString(), "Attempting to set output field: " + key + " in fillFromParms for class: " + this.getClass().toString() + " (field was annotated as API.Direction.OUTPUT)");
                }
                Schema.setField(this, f, key, parms.getProperty(key), api.required(), thisSchemaClass);
            }
            catch (IllegalAccessException iae) {
                throw H2O.fail("Broken internal schema; field cannot be private nor final: " + key);
            }
        }
        if (checkRequiredFields) {
            for (Field f : fields.values()) {
                int mods = f.getModifiers();
                if (Modifier.isTransient(mods) || Modifier.isStatic(mods)) continue;
                try {
                    API api = (API)f.getAnnotations()[0];
                    if (!api.required() || parms.getProperty(f.getName()) != null) continue;
                    IcedHashMapGeneric.IcedHashMapStringObject values = new IcedHashMapGeneric.IcedHashMapStringObject();
                    values.put("schema", this.getClass().getSimpleName());
                    values.put("argument", f.getName());
                    throw new H2OIllegalArgumentException("Required field " + f.getName() + " not specified", "Required field " + f.getName() + " not specified for schema class: " + this.getClass(), values);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw H2O.fail("Missing annotation for API field: " + f.getName());
                }
            }
        }
        return (S)this;
    }

    public S fillFromBody(String body) {
        return (S)PojoUtils.fillFromJson(this, body);
    }

    public S fillFromAny(Object o) {
        throw new IllegalArgumentException("can't convert object of type " + o.getClass() + " to schema " + this.getSchemaType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends Schema> void setField(T o, Field f, String key, String value, boolean required, Class thisSchemaClass) throws IllegalAccessException {
        Object parse_result = Schema.parse(key, value, f.getType(), required, thisSchemaClass);
        if (parse_result != null && f.getType().isArray() && parse_result.getClass().isArray() && f.getType().getComponentType() != parse_result.getClass().getComponentType()) {
            if (parse_result.getClass().getComponentType() == Integer.TYPE && f.getType().getComponentType() == Integer.class) {
                int[] from = (int[])parse_result;
                Integer[] copy = new Integer[from.length];
                for (int i = 0; i < from.length; ++i) {
                    copy[i] = from[i];
                }
                f.set(o, copy);
                return;
            } else if (parse_result.getClass().getComponentType() == Integer.class && f.getType().getComponentType() == Integer.TYPE) {
                Integer[] from = (Integer[])parse_result;
                int[] copy = new int[from.length];
                for (int i = 0; i < from.length; ++i) {
                    copy[i] = from[i];
                }
                f.set(o, copy);
                return;
            } else if (parse_result.getClass().getComponentType() == Double.class && f.getType().getComponentType() == Double.TYPE) {
                Double[] from = (Double[])parse_result;
                double[] copy = new double[from.length];
                for (int i = 0; i < from.length; ++i) {
                    copy[i] = from[i];
                }
                f.set(o, copy);
                return;
            } else if (parse_result.getClass().getComponentType() == Float.class && f.getType().getComponentType() == Float.TYPE) {
                Float[] from = (Float[])parse_result;
                float[] copy = new float[from.length];
                for (int i = 0; i < from.length; ++i) {
                    copy[i] = from[i].floatValue();
                }
                f.set(o, copy);
                return;
            } else {
                if (parse_result.getClass().getComponentType() != Boolean.class || f.getType().getComponentType() != Boolean.TYPE) throw H2O.fail("Don't know how to cast an array of: " + parse_result.getClass().getComponentType() + " to an array of: " + f.getType().getComponentType());
                Boolean[] from = (Boolean[])parse_result;
                boolean[] copy = new boolean[from.length];
                for (int i = 0; i < from.length; ++i) {
                    copy[i] = from[i];
                }
                f.set(o, copy);
            }
            return;
        } else {
            f.set(o, parse_result);
        }
    }

    static <E> Object parsePrimitve(String s, Class fclz) {
        if (fclz.equals(String.class)) {
            return s;
        }
        if (fclz.equals(Integer.TYPE)) {
            return Schema.parseInteger(s, Integer.TYPE);
        }
        if (fclz.equals(Long.TYPE)) {
            return Schema.parseInteger(s, Long.TYPE);
        }
        if (fclz.equals(Short.TYPE)) {
            return Schema.parseInteger(s, Short.TYPE);
        }
        if (fclz.equals(Boolean.TYPE)) {
            if (s.equals("0")) {
                return Boolean.FALSE;
            }
            if (s.equals("1")) {
                return Boolean.TRUE;
            }
            return Boolean.valueOf(s);
        }
        if (fclz.equals(Byte.TYPE)) {
            return Schema.parseInteger(s, Byte.TYPE);
        }
        if (fclz.equals(Double.TYPE)) {
            return Double.valueOf(s);
        }
        if (fclz.equals(Float.TYPE)) {
            return Float.valueOf(s);
        }
        throw H2O.fail("Unknown primitive type to parse: " + fclz.getSimpleName());
    }

    static <E> Object parse(String field_name, String s, Class fclz, boolean required, Class schemaClass) {
        if (fclz.isPrimitive() || String.class.equals((Object)fclz)) {
            try {
                return Schema.parsePrimitve(s, fclz);
            }
            catch (NumberFormatException ne) {
                String msg = "Illegal argument for field: " + field_name + " of schema: " + schemaClass.getSimpleName() + ": cannot convert \"" + s + "\" to type " + fclz.getSimpleName();
                throw new H2OIllegalArgumentException(msg);
            }
        }
        if (fclz.isArray()) {
            String[] splits;
            Class<?> afclz = fclz.getComponentType();
            Object[] a = null;
            if (s.equals("null") || s.length() == 0) {
                return null;
            }
            if (AutoParseable.class.isAssignableFrom(afclz)) {
                return gson.fromJson(s, fclz);
            }
            if (s.startsWith("[") && s.endsWith("]")) {
                Schema.read(s, 0, '[', fclz);
                Schema.read(s, s.length() - 1, ']', fclz);
                String inside = s.substring(1, s.length() - 1).trim();
                splits = inside.length() == 0 ? new String[]{} : Schema.splitArgs(inside);
            } else {
                splits = new String[]{s.trim()};
            }
            a = afclz == Integer.TYPE ? (Object[])Array.newInstance(Integer.class, splits.length) : (afclz == Double.TYPE ? (Object[])Array.newInstance(Double.class, splits.length) : (afclz == Float.TYPE ? (Object[])Array.newInstance(Float.class, splits.length) : (afclz == Boolean.TYPE ? (Object[])Array.newInstance(Boolean.class, splits.length) : (Object[])Array.newInstance(afclz, splits.length))));
            for (int i = 0; i < splits.length; ++i) {
                if (String.class == afclz || KeyV3.class.isAssignableFrom(afclz)) {
                    String stripped = splits[i].trim();
                    if ("null".equals(stripped.toLowerCase()) || "na".equals(stripped.toLowerCase())) {
                        a[i] = null;
                        continue;
                    }
                    if (stripped.startsWith("\"") && stripped.endsWith("\"")) {
                        stripped = stripped.substring(1, stripped.length() - 1);
                    }
                    a[i] = Schema.parse(field_name, stripped, afclz, required, schemaClass);
                    continue;
                }
                a[i] = Schema.parse(field_name, splits[i].trim(), afclz, required, schemaClass);
            }
            return a;
        }
        if (!fclz.isAssignableFrom(Schema.class) && s != null && s.startsWith("{") && s.endsWith("}")) {
            return gson.fromJson(s, fclz);
        }
        if (fclz.equals(Key.class)) {
            if ((s == null || s.length() == 0) && required) {
                throw new H2OKeyNotFoundArgumentException(field_name, s);
            }
            if (!(required || s != null && s.length() != 0)) {
                return null;
            }
            return Key.make(s.startsWith("\"") ? s.substring(1, s.length() - 1) : s);
        }
        if (KeyV3.class.isAssignableFrom(fclz)) {
            if ((s == null || s.length() == 0) && required) {
                throw new H2OKeyNotFoundArgumentException(field_name, s);
            }
            if (!(required || s != null && s.length() != 0)) {
                return null;
            }
            return KeyV3.make(fclz, Key.make(s.startsWith("\"") ? s.substring(1, s.length() - 1) : s));
        }
        if (Enum.class.isAssignableFrom(fclz)) {
            return EnumUtils.valueOf(fclz, s);
        }
        if (FrameV3.class.isAssignableFrom(fclz)) {
            if ((s == null || s.length() == 0) && required) {
                throw new H2OKeyNotFoundArgumentException(field_name, s);
            }
            if (!(required || s != null && s.length() != 0)) {
                return null;
            }
            Value v = DKV.get(s);
            if (null == v) {
                return null;
            }
            if (!v.isFrame()) {
                throw H2OIllegalArgumentException.wrongKeyType(field_name, s, "Frame", v.get().getClass());
            }
            return new FrameV3((Frame)v.get());
        }
        if (JobV3.class.isAssignableFrom(fclz)) {
            if ((s == null || s.length() == 0) && required) {
                throw new H2OKeyNotFoundArgumentException(s);
            }
            if (!(required || s != null && s.length() != 0)) {
                return null;
            }
            Value v = DKV.get(s);
            if (null == v) {
                return null;
            }
            if (!v.isJob()) {
                throw H2OIllegalArgumentException.wrongKeyType(field_name, s, "Job", v.get().getClass());
            }
            return new JobV3().fillFromImpl((Job)v.get());
        }
        if (FrameV3.ColSpecifierV3.class.isAssignableFrom(fclz)) {
            return new FrameV3.ColSpecifierV3(s);
        }
        if (ModelSchemaV3.class.isAssignableFrom(fclz)) {
            throw H2O.fail("Can't yet take ModelSchemaV3 as input.");
        }
        throw H2O.fail("Unimplemented schema fill from " + fclz.getSimpleName());
    }

    private static <T> T parseInteger(String s, Class<T> return_type) {
        try {
            BigDecimal num = new BigDecimal(s);
            Object result = num.getClass().getDeclaredMethod(return_type.getSimpleName() + "ValueExact", new Class[0]).invoke((Object)num, new Object[0]);
            return (T)result;
        }
        catch (InvocationTargetException ite) {
            throw new NumberFormatException("The expression's numeric value is out of the range of type " + return_type.getSimpleName());
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException(return_type.getSimpleName() + " is not an integer data type");
        }
        catch (IllegalAccessException iae) {
            throw H2O.fail("Cannot parse expression as " + return_type.getSimpleName() + " (Illegal Access)");
        }
    }

    private static int read(String s, int x, char c, Class fclz) {
        if (Schema.peek(s, x, c)) {
            return x + 1;
        }
        throw new IllegalArgumentException("Expected '" + c + "' while reading a " + fclz.getSimpleName() + ", but found " + s);
    }

    private static boolean peek(String s, int x, char c) {
        return x < s.length() && s.charAt(x) == c;
    }

    private static String[] splitArgs(String argStr) {
        StringBuilder sb = new StringBuilder(argStr);
        StringBuilder arg = new StringBuilder();
        ArrayList<String> splitArgList = new ArrayList<String>();
        boolean inDoubleQuotes = false;
        boolean inSquareBrackets = false;
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) == '\"' && !inDoubleQuotes && !inSquareBrackets) {
                inDoubleQuotes = true;
                arg.append(sb.charAt(i));
                continue;
            }
            if (sb.charAt(i) == '\"' && inDoubleQuotes && !inSquareBrackets) {
                inDoubleQuotes = false;
                arg.append(sb.charAt(i));
                continue;
            }
            if (sb.charAt(i) == ',' && !inDoubleQuotes && !inSquareBrackets) {
                splitArgList.add(arg.toString());
                arg.setLength(0);
                continue;
            }
            if (sb.charAt(i) == '[') {
                inSquareBrackets = true;
                arg.append(sb.charAt(i));
                continue;
            }
            if (sb.charAt(i) == ']') {
                inSquareBrackets = false;
                arg.append(sb.charAt(i));
                continue;
            }
            arg.append(sb.charAt(i));
        }
        if (arg.length() > 0) {
            splitArgList.add(arg.toString());
        }
        return splitArgList.toArray(new String[splitArgList.size()]);
    }

    public static <T extends Schema> T newInstance(Class<T> clz) {
        try {
            return (T)((Schema)clz.newInstance());
        }
        catch (Exception e) {
            throw H2O.fail("Failed to instantiate schema of class: " + clz.getCanonicalName(), e);
        }
    }

    protected static Schema newInstance(String schema_name) {
        return Schema.newInstance(SchemaServer.getSchema(schema_name));
    }

    public StringBuffer markdown(boolean include_input_fields, boolean include_output_fields) {
        return this.markdown(new SchemaMetadata(this), include_input_fields, include_output_fields);
    }

    public StringBuffer markdown(SchemaMetadata meta, boolean include_input_fields, boolean include_output_fields) {
        MarkdownBuilder builder = new MarkdownBuilder();
        builder.comment("Preview with http://jbt.github.io/markdown-editor");
        builder.heading1("schema ", this.getClass().getSimpleName());
        builder.hline();
        try {
            boolean first;
            if (include_input_fields) {
                first = true;
                builder.heading2("input fields");
                for (SchemaMetadata.FieldMetadata field_meta : meta.fields) {
                    if (field_meta.direction != API.Direction.INPUT && field_meta.direction != API.Direction.INOUT) continue;
                    if (first) {
                        builder.tableHeader("name", "required?", "level", "type", "schema?", "schema", "default", "description", "values", "is member of frames", "is mutually exclusive with");
                        first = false;
                    }
                    builder.tableRow(field_meta.name, String.valueOf(field_meta.required), field_meta.level.name(), field_meta.type, String.valueOf(field_meta.is_schema), field_meta.is_schema ? field_meta.schema_name : "", null == field_meta.value ? "(null)" : field_meta.value.toString(), field_meta.help, field_meta.values == null || field_meta.values.length == 0 ? "" : Arrays.toString(field_meta.values), field_meta.is_member_of_frames == null ? "[]" : Arrays.toString(field_meta.is_member_of_frames), field_meta.is_mutually_exclusive_with == null ? "[]" : Arrays.toString(field_meta.is_mutually_exclusive_with));
                }
                if (first) {
                    builder.paragraph("(none)");
                }
            }
            if (include_output_fields) {
                first = true;
                builder.heading2("output fields");
                for (SchemaMetadata.FieldMetadata field_meta : meta.fields) {
                    if (field_meta.direction != API.Direction.OUTPUT && field_meta.direction != API.Direction.INOUT) continue;
                    if (first) {
                        builder.tableHeader("name", "type", "schema?", "schema", "default", "description", "values", "is member of frames", "is mutually exclusive with");
                        first = false;
                    }
                    builder.tableRow(field_meta.name, field_meta.type, String.valueOf(field_meta.is_schema), field_meta.is_schema ? field_meta.schema_name : "", null == field_meta.value ? "(null)" : field_meta.value.toString(), field_meta.help, field_meta.values == null || field_meta.values.length == 0 ? "" : Arrays.toString(field_meta.values), field_meta.is_member_of_frames == null ? "[]" : Arrays.toString(field_meta.is_member_of_frames), field_meta.is_mutually_exclusive_with == null ? "[]" : Arrays.toString(field_meta.is_mutually_exclusive_with));
                }
                if (first) {
                    builder.paragraph("(none)");
                }
            }
        }
        catch (Exception e) {
            IcedHashMapGeneric.IcedHashMapStringObject values = new IcedHashMapGeneric.IcedHashMapStringObject();
            values.put("schema", this);
            throw new H2OIllegalArgumentException("Caught exception using reflection on schema: " + this, "Caught exception using reflection on schema: " + this + ": " + e, values);
        }
        return builder.stringBuffer();
    }

    public static interface AutoParseable {
    }
}

