/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import water.api.SchemaServer;

public class RequestUri {
    private static Pattern version_pattern = Pattern.compile("^/(?:\\d+|EXPERIMENTAL|LATEST)/.*", 2);
    private static Set<String> http_methods = new HashSet<String>(Arrays.asList("HEAD", "GET", "POST", "DELETE"));
    private String method;
    private String url;
    private String[] path;
    private boolean is_api_url;

    public RequestUri(String request_method, String request_url) throws MalformedURLException {
        if (!http_methods.contains(request_method)) {
            throw new MalformedURLException("Bad HTTP method: " + request_method);
        }
        this.method = request_method;
        this.url = request_url;
        this.is_api_url = version_pattern.matcher(request_url).matches();
        this.path = null;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isApiUrl() {
        return this.is_api_url;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isGetMethod() {
        return this.method.equals("GET");
    }

    public boolean isPostMethod() {
        return this.method.equals("POST");
    }

    public boolean isHeadMethod() {
        return this.method.equals("HEAD");
    }

    public String[] getPath() {
        this.computePathIfNeeded();
        return this.path;
    }

    public String[] getParamsList() {
        this.computePathIfNeeded();
        ArrayList<String> params_list = new ArrayList<String>();
        for (int i = 2; i < this.path.length; ++i) {
            if (!this.path[i].startsWith("{") || !this.path[i].endsWith("}")) continue;
            params_list.add(this.path[i].substring(1, this.path[i].length() - 1));
        }
        return params_list.toArray(new String[params_list.size()]);
    }

    public int getVersion() {
        this.computePathIfNeeded();
        String ver = this.path[this.path.length - 1];
        return ver.isEmpty() ? 0 : Integer.parseInt(ver);
    }

    public String toString() {
        return this.method + " " + this.url;
    }

    private void computePathIfNeeded() {
        if (this.path == null) {
            this.path = (this.url + "/").split("/", -1);
            assert (this.path[0].isEmpty() && this.path.length >= 3);
            String ver = this.path[1].toUpperCase();
            if (ver.equals("EXPERIMENTAL")) {
                ver = Integer.valueOf(SchemaServer.getExperimentalVersion()).toString();
            }
            if (ver.equals("LATEST")) {
                ver = Integer.valueOf(SchemaServer.getLatestOrHighestSupportedVersion()).toString();
            }
            if (this.path[2].endsWith(".json")) {
                this.path[2] = this.path[2].substring(0, this.path[2].length() - 5);
            }
            this.path[1] = this.method;
            this.path[this.path.length - 1] = ver;
        }
    }
}

