/*
 * Decompiled with CFR 0.152.
 */
package water;

import water.DTask;
import water.H2O;
import water.H2ONode;
import water.Key;
import water.RPC;
import water.Value;
import water.nbhm.NonBlockingHashMap;

public class TaskGetKey
extends DTask<TaskGetKey> {
    Key _key;
    Value _val;
    transient Key _xkey;
    transient H2ONode _h2o;
    private static final NonBlockingHashMap<Key, RPC<TaskGetKey>> TGKS = new NonBlockingHashMap();

    static Value get(H2ONode target, Key key) {
        return TaskGetKey.get(TaskGetKey.start(target, key));
    }

    static Value get(RPC<TaskGetKey> rpc) {
        return ((TaskGetKey)rpc.get())._val;
    }

    static RPC<TaskGetKey> start(H2ONode target, Key key) {
        RPC<TaskGetKey> old = TGKS.get(key);
        if (old != null) {
            return old;
        }
        RPC<TaskGetKey> rpc = new RPC<TaskGetKey>(target, new TaskGetKey(key), 1.0f);
        old = TGKS.putIfMatchUnlocked(key, rpc, null);
        if (old != null) {
            return old;
        }
        rpc.setTaskNum().call();
        return rpc;
    }

    private TaskGetKey(Key key) {
        super((byte)122);
        this._key = this._xkey = key;
    }

    @Override
    public void dinvoke(H2ONode sender) {
        this._h2o = sender;
        Key k = this._key;
        this._key = null;
        assert (k.home());
        do {
            this._val = Value.STORE_get(k);
        } while (this._val != null && !this._val.setReplica(sender));
        this.tryComplete();
    }

    @Override
    public void compute2() {
        throw H2O.fail();
    }

    @Override
    public void onAck() {
        Value res;
        Value old;
        if (this._val != null) {
            assert (!this._xkey.home() && this._val._key == null);
            this._val._key = this._xkey;
        }
        if ((old = H2O.STORE.get(this._xkey)) != null && !old.isEmpty()) {
            old = null;
        }
        if ((res = H2O.putIfMatch(this._xkey, this._val, old)) != old) {
            this._val = res;
        }
        TGKS.remove(this._xkey);
    }

    @Override
    public void onAckAck() {
        if (this._val != null) {
            this._val.lowerActiveGetCount(this._h2o);
        }
    }
}

