/*
 * Decompiled with CFR 0.152.
 */
package hex.leaderboard;

import hex.Model;
import hex.leaderboard.LeaderboardCell;
import hex.leaderboard.LeaderboardColumn;
import water.Iced;
import water.Key;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;

public class ScoringTimePerRow
extends Iced<ScoringTimePerRow>
implements LeaderboardCell<Double, ScoringTimePerRow> {
    public static final LeaderboardColumn COLUMN = new LeaderboardColumn("predict_time_per_row_ms", "double", "%.6f");
    private final Key<Model> _modelId;
    private final Key<Frame> _leaderboardFrameId;
    private Double _scoringTimePerRowMillis;

    public ScoringTimePerRow(Model model, Frame leaderboardFrame) {
        this(model._key, leaderboardFrame == null ? null : leaderboardFrame._key);
    }

    public ScoringTimePerRow(Key<Model> modelId, Key<Frame> leaderboardFrameId) {
        this._modelId = modelId;
        this._leaderboardFrameId = leaderboardFrameId;
    }

    @Override
    public LeaderboardColumn getColumn() {
        return COLUMN;
    }

    @Override
    public Key<Model> getModelId() {
        return this._modelId;
    }

    @Override
    public Double getValue() {
        if (this._scoringTimePerRowMillis == null && this._leaderboardFrameId == null) {
            throw new H2OIllegalArgumentException("predict_time_per_row_ms requires a leaderboard frame!");
        }
        return this._scoringTimePerRowMillis;
    }

    @Override
    public void setValue(Double value) {
        this._scoringTimePerRowMillis = value;
    }

    @Override
    public boolean isNA() {
        return this.getValue() == null || this.getValue() < 0.0;
    }

    @Override
    public Double fetch() {
        if (this.getValue() == null) {
            try {
                Frame scoringFrame;
                Model model = this._modelId.get();
                Frame frame = scoringFrame = this._leaderboardFrameId != null ? this._leaderboardFrameId.get() : null;
                if (scoringFrame != null) {
                    long nrows = scoringFrame.numRows();
                    long start = System.nanoTime();
                    model.score(scoringFrame).delete();
                    long stop = System.nanoTime();
                    this.setValue((double)((stop - start) / nrows) / 1000000.0);
                } else {
                    this.setValue(-1.0);
                }
            }
            catch (Exception e) {
                this.setValue(-1.0);
            }
        }
        return this.getValue();
    }
}

