/*
 * Decompiled with CFR 0.152.
 */
package hex.grid;

import hex.Model;
import hex.ModelParametersBuilderFactory;
import hex.ScoreKeeper;
import hex.ScoringInfo;
import hex.grid.HyperSpaceSearchCriteria;
import hex.grid.SequentialWalker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import water.exceptions.H2OIllegalArgumentException;
import water.util.ArrayUtils;
import water.util.PojoUtils;

public interface HyperSpaceWalker<MP extends Model.Parameters, C extends HyperSpaceSearchCriteria> {
    public C search_criteria();

    public boolean stopEarly(Model var1, ScoringInfo[] var2);

    public HyperSpaceIterator<MP> iterator();

    public String[] getHyperParamNames();

    public String[] getAllHyperParamNamesInSubspaces();

    default public String[] getAllHyperParamNames() {
        String[] hyperNames;
        String[] allHyperNames = hyperNames = this.getHyperParamNames();
        String[] hyperParamNamesSubspace = this.getAllHyperParamNamesInSubspaces();
        if (hyperParamNamesSubspace.length > 0) {
            allHyperNames = ArrayUtils.append(ArrayUtils.remove(hyperNames, "subspaces"), hyperParamNamesSubspace);
        }
        return allHyperNames;
    }

    public Map<String, Object[]> getHyperParams();

    public long getMaxHyperSpaceSize();

    public MP getParams();

    default public long estimateGridWork(long maxModels) {
        HyperSpaceIterator<MP> it = this.iterator();
        long gridWork = 0L;
        if (this.getMaxHyperSpaceSize() > 0L && maxModels > 0L) {
            while (it.hasNext()) {
                try {
                    MP parms = it.nextModelParameters();
                    gridWork += (long)(((Model.Parameters)parms)._nfolds > 0 ? ((Model.Parameters)parms)._nfolds + 1 : 1) * ((Model.Parameters)parms).progressUnits();
                }
                catch (Throwable throwable) {}
            }
        } else {
            gridWork = Long.MAX_VALUE;
        }
        return gridWork;
    }

    public ModelParametersBuilderFactory<MP> getParametersBuilderFactory();

    public static class RandomDiscreteValueWalker<MP extends Model.Parameters>
    extends BaseWalker<MP, HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria> {
        private static final double MIN_NUMBER_OF_SAMPLES = 10000.0;
        private Random _random;
        private boolean _set_model_seed_from_search_seed;

        public RandomDiscreteValueWalker(MP params, Map<String, Object[]> hyperParams, ModelParametersBuilderFactory<MP> paramsBuilderFactory, HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria search_criteria) {
            super(params, hyperParams, paramsBuilderFactory, search_criteria);
            long defaultSeed = this._defaultParams._seed;
            long actualSeed = this._params._seed;
            long gridSeed = search_criteria.seed();
            this._set_model_seed_from_search_seed = defaultSeed == actualSeed && defaultSeed != gridSeed;
            this._random = gridSeed == defaultSeed ? new Random() : new Random(gridSeed);
        }

        @Override
        public boolean stopEarly(Model model, ScoringInfo[] sk) {
            return ScoreKeeper.stopEarly(ScoringInfo.scoreKeepers(sk), ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.search_criteria()).stopping_rounds(), ScoreKeeper.ProblemType.forSupervised(((Model.Output)model._output).isClassifier()), ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.search_criteria()).stopping_metric(), ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.search_criteria()).stopping_tolerance(), "grid's best", true);
        }

        @Override
        public HyperSpaceIterator<MP> iterator() {
            return new HyperSpaceIterator<MP>(){
                private final List<int[]> _visitedPermutations = new ArrayList<int[]>();
                private final Set<Integer> _visitedPermutationHashes = new LinkedHashSet<Integer>();
                private int[] _currentHyperparamIndices = null;
                private int _currentPermutationNum = 0;
                private int _currentSubspace = -1;
                private Map<String, Object[]> _currentHyperParams;
                private String[] _currentHyperParamNames;
                private boolean _exhausted;
                {
                    this._currentHyperParams = _hyperParams;
                    this._currentHyperParamNames = _hyperParamNames;
                    this._exhausted = false;
                }

                @Override
                public MP nextModelParameters() {
                    this._currentHyperparamIndices = this.nextModelIndices();
                    if (this._currentHyperparamIndices != null) {
                        this._visitedPermutations.add(this._currentHyperparamIndices);
                        this._visitedPermutationHashes.add(this.integerHash(this._currentHyperParams, this._currentHyperParamNames, this._currentHyperparamIndices, this._currentSubspace));
                        ++this._currentPermutationNum;
                        Object[] hypers = this.hypers(this._currentHyperParams, this._currentHyperParamNames, this._currentHyperparamIndices);
                        Model.Parameters commonModelParams = (Model.Parameters)_params.clone();
                        Model.Parameters params = this.getModelParams(commonModelParams, hypers, this._currentHyperParamNames);
                        if (_search_criteria != null && ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)_search_criteria).strategy() == HyperSpaceSearchCriteria.Strategy.RandomDiscrete && _set_model_seed_from_search_seed) {
                            params._seed = ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)_search_criteria).seed() + model_number++;
                        }
                        return params;
                    }
                    throw new NoSuchElementException("No more elements to explore in hyper-space!");
                }

                @Override
                public boolean hasNext() {
                    return (long)this._visitedPermutationHashes.size() < _maxHyperSpaceSize && (((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.search_criteria()).max_models() == 0 || this._currentPermutationNum < ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.search_criteria()).max_models()) && !this._exhausted;
                }

                @Override
                public void onModelFailure(Model failedModel, Consumer<Object[]> withFailedModelHyperParams) {
                    --this._currentPermutationNum;
                    withFailedModelHyperParams.accept(this.hypers(this._currentHyperParams, this._currentHyperParamNames, this._currentHyperparamIndices));
                }

                private int[] nextModelIndices() {
                    int[] hyperparamIndices = new int[this._currentHyperParamNames.length];
                    int j = 0;
                    while ((double)j < Math.max(10000.0, (double)_maxHyperSpaceSize)) {
                        if (_hyperParamSubspaces.length != 0) {
                            this._currentSubspace = _random.nextInt(_hyperParamSubspaces.length);
                            this._currentHyperParams = this.mergeHashMaps(_hyperParams, _hyperParamSubspaces[this._currentSubspace]);
                            this._currentHyperParamNames = this._currentHyperParams.keySet().toArray(new String[0]);
                            hyperparamIndices = new int[this._currentHyperParamNames.length];
                        }
                        for (int i = 0; i < this._currentHyperParamNames.length; ++i) {
                            hyperparamIndices[i] = _random.nextInt(this._currentHyperParams.get(this._currentHyperParamNames[i]).length);
                        }
                        if (!this._visitedPermutationHashes.contains(this.integerHash(this._currentHyperParams, this._currentHyperParamNames, hyperparamIndices, this._currentSubspace))) {
                            return hyperparamIndices;
                        }
                        ++j;
                    }
                    this._exhausted = true;
                    return null;
                }
            };
        }

        @Override
        public long estimateGridWork(long maxModels) {
            return Long.MAX_VALUE;
        }
    }

    public static class CartesianWalker<MP extends Model.Parameters>
    extends BaseWalker<MP, HyperSpaceSearchCriteria.CartesianSearchCriteria> {
        public CartesianWalker(MP params, Map<String, Object[]> hyperParams, ModelParametersBuilderFactory<MP> paramsBuilderFactory, HyperSpaceSearchCriteria.CartesianSearchCriteria search_criteria) {
            super(params, hyperParams, paramsBuilderFactory, search_criteria);
        }

        @Override
        public HyperSpaceIterator<MP> iterator() {
            return new HyperSpaceIterator<MP>(){
                private int[] _currentHyperparamIndices = null;
                private int _currentSubspace;
                private Map<String, Object[]> _currentHyperParams;
                private String[] _currentHyperParamNames;
                {
                    this._currentSubspace = _hyperParamSubspaces.length == 0 ? -1 : 0;
                    this._currentHyperParams = _hyperParamSubspaces.length == 0 ? _hyperParams : this.mergeHashMaps(_hyperParams, _hyperParamSubspaces[0]);
                    this._currentHyperParamNames = this._currentHyperParams.keySet().toArray(new String[0]);
                }

                @Override
                public MP nextModelParameters() {
                    int[] nArray = this._currentHyperparamIndices = this._currentHyperparamIndices == null ? new int[this._currentHyperParamNames.length] : this.nextModelIndices(this._currentHyperparamIndices);
                    if (this._currentSubspace < _hyperParamSubspaces.length - 1 && this._currentHyperparamIndices == null) {
                        this._currentHyperParams = this.mergeHashMaps(_hyperParams, _hyperParamSubspaces[++this._currentSubspace]);
                        this._currentHyperParamNames = this._currentHyperParams.keySet().toArray(new String[0]);
                        this._currentHyperparamIndices = new int[this._currentHyperParamNames.length];
                    }
                    if (this._currentHyperparamIndices != null) {
                        Object[] hypers = this.hypers(this._currentHyperParams, this._currentHyperParamNames, this._currentHyperparamIndices);
                        Model.Parameters commonModelParams = (Model.Parameters)_params.clone();
                        Model.Parameters params = this.getModelParams(commonModelParams, hypers, this._currentHyperParamNames);
                        return params;
                    }
                    throw new NoSuchElementException("No more elements to explore in hyper-space!");
                }

                @Override
                public boolean hasNext() {
                    if (this._currentHyperparamIndices != null) {
                        int[] hyperParamIndicesCopy = new int[this._currentHyperparamIndices.length];
                        System.arraycopy(this._currentHyperparamIndices, 0, hyperParamIndicesCopy, 0, this._currentHyperparamIndices.length);
                        if (this.nextModelIndices(hyperParamIndicesCopy) == null && this._currentSubspace == _hyperParamSubspaces.length - 1) {
                            return false;
                        }
                    }
                    return true;
                }

                @Override
                public void onModelFailure(Model failedModel, Consumer<Object[]> withFailedModelHyperParams) {
                    withFailedModelHyperParams.accept(this.hypers(this._currentHyperParams, this._currentHyperParamNames, this._currentHyperparamIndices));
                }

                private int[] nextModelIndices(int[] hyperparamIndices) {
                    int i;
                    for (i = 0; i < hyperparamIndices.length && hyperparamIndices[i] + 1 >= this._currentHyperParams.get(this._currentHyperParamNames[i]).length; ++i) {
                    }
                    if (i == hyperparamIndices.length) {
                        return null;
                    }
                    for (int j = 0; j < i; ++j) {
                        hyperparamIndices[j] = 0;
                    }
                    int n = i;
                    hyperparamIndices[n] = hyperparamIndices[n] + 1;
                    return hyperparamIndices;
                }
            };
        }
    }

    public static abstract class BaseWalker<MP extends Model.Parameters, C extends HyperSpaceSearchCriteria>
    implements HyperSpaceWalker<MP, C> {
        protected final C _search_criteria;
        public static final String SUBSPACES = "subspaces";
        final transient ModelParametersBuilderFactory<MP> _paramsBuilderFactory;
        final MP _params;
        final MP _defaultParams;
        protected final Map<String, Object[]> _hyperParams;
        long model_number = 0L;
        protected final String[] _hyperParamNames;
        protected final String[] _hyperParamNamesSubspace;
        protected Map<String, Object[]>[] _hyperParamSubspaces;
        protected final long _maxHyperSpaceSize;

        @Override
        public C search_criteria() {
            return this._search_criteria;
        }

        @Override
        public boolean stopEarly(Model model, ScoringInfo[] sk) {
            return false;
        }

        public BaseWalker(MP params, Map<String, Object[]> hyperParams, ModelParametersBuilderFactory<MP> paramsBuilderFactory, C search_criteria) {
            this._params = params;
            this._hyperParams = hyperParams;
            this._paramsBuilderFactory = paramsBuilderFactory;
            this._hyperParamNames = hyperParams.keySet().toArray(new String[0]);
            this._hyperParamSubspaces = this.extractSubspaces();
            this._hyperParamNamesSubspace = this.extractSubspaceNames();
            this._hyperParams.remove(SUBSPACES);
            this._search_criteria = search_criteria;
            this._maxHyperSpaceSize = this.computeMaxSizeOfHyperSpace();
            try {
                this._defaultParams = (Model.Parameters)params.getClass().newInstance();
            }
            catch (Exception e) {
                throw new H2OIllegalArgumentException("Failed to instantiate a new Model.Parameters object to get the default values.");
            }
            this.validateParams(this._hyperParams, false);
            Arrays.stream(this._hyperParamSubspaces).forEach(subspace -> this.validateParams((Map<String, Object[]>)subspace, true));
        }

        @Override
        public String[] getHyperParamNames() {
            return this._hyperParamNames;
        }

        @Override
        public String[] getAllHyperParamNamesInSubspaces() {
            return this._hyperParamNamesSubspace;
        }

        @Override
        public Map<String, Object[]> getHyperParams() {
            return this._hyperParams;
        }

        @Override
        public long getMaxHyperSpaceSize() {
            return this._maxHyperSpaceSize;
        }

        @Override
        public MP getParams() {
            return this._params;
        }

        @Override
        public ModelParametersBuilderFactory<MP> getParametersBuilderFactory() {
            return this._paramsBuilderFactory;
        }

        private Map<String, Object[]>[] extractSubspaces() {
            if (!this._hyperParams.containsKey(SUBSPACES)) {
                return new Map[0];
            }
            return (Map[])this._hyperParams.get(SUBSPACES);
        }

        private String[] extractSubspaceNames() {
            return (String[])Stream.of(this._hyperParamSubspaces).flatMap(m -> m.keySet().stream()).toArray(String[]::new);
        }

        protected MP getModelParams(MP params, Object[] hyperParams, String[] hyperParamNames) {
            ModelParametersBuilderFactory.ModelParametersBuilder<MP> paramsBuilder = this._paramsBuilderFactory.get(params);
            for (int i = 0; i < hyperParamNames.length; ++i) {
                String paramName = hyperParamNames[i];
                Object paramValue = hyperParams[i];
                if (paramName.equals("valid")) {
                    paramName = "validation_frame";
                }
                paramsBuilder.set(paramName, paramValue);
            }
            return paramsBuilder.build();
        }

        protected long computeMaxSizeOfHyperSpace() {
            long work = 0L;
            long free_param_combos = 1L;
            for (Map<String, Object[]> subspace : this._hyperParamSubspaces) {
                long subspace_param_combos = 1L;
                for (Object[] o : subspace.values()) {
                    subspace_param_combos *= (long)o.length;
                }
                work += subspace_param_combos;
            }
            for (Object[] p : this._hyperParams.values()) {
                free_param_combos *= (long)p.length;
            }
            work = work == 0L ? free_param_combos : free_param_combos * work;
            return work;
        }

        protected Map<String, Object[]> mergeHashMaps(Map<String, Object[]> hyperparams, Map<String, Object[]> subspace) {
            if (subspace == null) {
                return hyperparams;
            }
            HashMap<String, Object[]> m = new HashMap<String, Object[]>();
            m.putAll(hyperparams);
            m.putAll(subspace);
            return m;
        }

        protected Object[] hypers(Map<String, Object[]> hyperParams, String[] hyperParamNames, int[] hidx) {
            Object[] hypers = new Object[hyperParamNames.length];
            for (int i = 0; i < hidx.length; ++i) {
                hypers[i] = hyperParams.get(hyperParamNames[i])[hidx[i]];
            }
            return hypers;
        }

        protected int integerHash(Map<String, Object[]> hyperParams, String[] hyperParamNames, int[] ar, int subspaceNum) {
            Object[] hashMe = new Integer[ar.length + 1];
            for (int i = 0; i < ar.length; ++i) {
                hashMe[i] = ar[i] * hyperParams.get(hyperParamNames[i]).length;
            }
            hashMe[ar.length] = subspaceNum;
            return Arrays.deepHashCode(hashMe);
        }

        private void validateParams(Map<String, Object[]> params, boolean isSubspace) {
            for (String key : params.keySet()) {
                Object[] values = params.get(key);
                if (0 == values.length) {
                    throw new H2OIllegalArgumentException("Grid search hyperparameter value list is empty for hyperparameter: " + key);
                }
                if ("seed".equals(key) || "_seed".equals(key)) continue;
                if (isSubspace && this._hyperParams.containsKey(key)) {
                    throw new H2OIllegalArgumentException("Grid search model parameter '" + key + "' is set in both the subspaces and in the hyperparameters map.  This is ambiguous; set it in one place or the other, not both.");
                }
                this.validateParamVals(key);
            }
        }

        private void validateParamVals(String key) {
            String prefix = key.startsWith("_") ? "" : "_";
            Object defaultVal = PojoUtils.getFieldValue(this._defaultParams, prefix + key, PojoUtils.FieldNaming.CONSISTENT);
            Object actualVal = PojoUtils.getFieldValue(this._params, prefix + key, PojoUtils.FieldNaming.CONSISTENT);
            if (defaultVal != null && actualVal != null) {
                if (defaultVal.getClass().isArray() && !PojoUtils.arraysEquals(defaultVal, actualVal)) {
                    throw new H2OIllegalArgumentException("Grid search model parameter '" + key + "' is set in both the model parameters and in the hyperparameters map.  This is ambiguous; set it in one place or the other, not both.");
                }
                if (!defaultVal.getClass().isArray() && !defaultVal.equals(actualVal)) {
                    throw new H2OIllegalArgumentException("Grid search model parameter '" + key + "' is set in both the model parameters and in the hyperparameters map.  This is ambiguous; set it in one place or the other, not both.");
                }
            }
            if (defaultVal == null && actualVal != null) {
                throw new H2OIllegalArgumentException("Grid search model parameter '" + key + "' is set in both the model parameters and in the hyperparameters map.  This is ambiguous; set it in one place or the other, not both.");
            }
        }

        public static class WalkerFactory<MP extends Model.Parameters, C extends HyperSpaceSearchCriteria> {
            public static <MP extends Model.Parameters, C extends HyperSpaceSearchCriteria> HyperSpaceWalker<MP, ? extends HyperSpaceSearchCriteria> create(MP params, Map<String, Object[]> hyperParams, ModelParametersBuilderFactory<MP> paramsBuilderFactory, C search_criteria) {
                HyperSpaceSearchCriteria.Strategy strategy = search_criteria.strategy();
                switch (strategy) {
                    case Cartesian: {
                        return new CartesianWalker<MP>(params, hyperParams, paramsBuilderFactory, (HyperSpaceSearchCriteria.CartesianSearchCriteria)search_criteria);
                    }
                    case RandomDiscrete: {
                        return new RandomDiscreteValueWalker<MP>(params, hyperParams, paramsBuilderFactory, (HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)search_criteria);
                    }
                    case Sequential: {
                        return new SequentialWalker<MP>(params, hyperParams, paramsBuilderFactory, (HyperSpaceSearchCriteria.SequentialSearchCriteria)search_criteria);
                    }
                }
                throw new H2OIllegalArgumentException("strategy", "GridSearch", (Object)strategy);
            }
        }
    }

    public static interface HyperSpaceIterator<MP extends Model.Parameters> {
        public MP nextModelParameters();

        public boolean hasNext();

        public void onModelFailure(Model var1, Consumer<Object[]> var2);
    }
}

