/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Model;
import hex.genmodel.AbstractMojoWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.ZipOutputStream;
import water.api.SchemaServer;
import water.api.StreamWriteOption;
import water.api.StreamWriter;
import water.api.schemas3.ModelSchemaV3;

public abstract class ModelMojoWriter<M extends Model<M, P, O>, P extends Model.Parameters, O extends Model.Output>
extends AbstractMojoWriter
implements StreamWriter {
    protected M model;

    public ModelMojoWriter() {
        super(null);
    }

    public ModelMojoWriter(M model) {
        super(((Model)model).modelDescriptor());
        this.model = model;
    }

    @Override
    public void writeTo(OutputStream os, StreamWriteOption ... option) {
        ZipOutputStream zos = new ZipOutputStream(os);
        try {
            this.writeTo(zos);
            zos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void writeModelData() throws IOException;

    protected void writeExtraInfo() throws IOException {
        super.writeExtraInfo();
        this.writeModelDetails();
        this.writeModelDetailsReadme();
    }

    private void writeModelDetails() throws IOException {
        ModelSchemaV3 modelSchema = (ModelSchemaV3)SchemaServer.schema(3, this.model).fillFromImpl(this.model);
        this.startWritingTextFile("experimental/modelDetails.json");
        this.writeln(modelSchema.toJsonString());
        this.finishWritingTextFile();
    }

    private void writeModelDetailsReadme() throws IOException {
        this.startWritingTextFile("experimental/README.md");
        this.writeln("Outputting model information in JSON is an experimental feature and we appreciate any feedback.\nThe contents of this folder may change with another version of H2O.");
        this.finishWritingTextFile();
    }

    public void writeStringArrays(String[] sArrays, String title) throws IOException {
        this.startWritingTextFile(title);
        for (String sName : sArrays) {
            this.writeln(sName);
        }
        this.finishWritingTextFile();
    }

    public void writeRectangularDoubleArray(double[][] array, String title) throws IOException {
        assert (null != array);
        assert (null != title);
        this.writekv(title + "_size1", array.length);
        this.writekv(title + "_size2", array.length > 0 ? array[0].length : 0);
        this.writeDoubleArray(array, title);
    }

    public void writeDoubleArray(double[][] array, String title) throws IOException {
        assert (null != array);
        assert (null != title);
        this.write2DArray(array, title);
    }

    public void write2DStringArrays(String[][] sArrays, String title) throws IOException {
        this.startWritingTextFile(title);
        int numCols = sArrays.length;
        for (int index = 0; index < numCols; ++index) {
            if (sArrays[index] == null) continue;
            for (String sName : sArrays[index]) {
                this.writeln(sName);
            }
        }
        this.finishWritingTextFile();
    }

    public void write2DArray(double[][] array, String title) throws IOException {
        int totArraySize = 0;
        for (double[] row : array) {
            totArraySize += row.length;
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[totArraySize * 8]);
        double[][] dArray = array;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] row;
            for (double val : row = dArray[i]) {
                bb.putDouble(val);
            }
        }
        this.writeblob(title, bb.array());
    }

    public void write3DIntArray(int[][][] array, String title) throws IOException {
        int totArraySize = 0;
        int outDim = array.length;
        for (int index = 0; index < outDim; ++index) {
            for (int[] row : array[index]) {
                totArraySize += row.length;
            }
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[totArraySize * 4]);
        for (int index = 0; index < outDim; ++index) {
            int[][] nArray = array[index];
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] row;
                for (int val : row = nArray[i]) {
                    bb.putInt(val);
                }
            }
        }
        this.writeblob(title, bb.array());
    }

    public void write3DArray(double[][][] array, String title) throws IOException {
        int totArraySize = 0;
        int outDim = array.length;
        for (int index = 0; index < outDim; ++index) {
            for (double[] row : array[index]) {
                totArraySize += row.length;
            }
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[totArraySize * 8]);
        for (int index = 0; index < outDim; ++index) {
            double[][] dArray = array[index];
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                double[] row;
                for (double val : row = dArray[i]) {
                    bb.putDouble(val);
                }
            }
        }
        this.writeblob(title, bb.array());
    }
}

