/*
 * Decompiled with CFR 0.152.
 */
package hex;

import Jama.Matrix;
import hex.CustomMetric;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsRegression;
import java.util.Arrays;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.util.ArrayUtils;

public class ModelMetricsRegressionHGLM
extends ModelMetricsRegression {
    public static final double LOG_2PI = Math.log(Math.PI * 2);
    public final double[] _beta;
    public final double[][] _ubeta;
    public final double[] _icc;
    public final int _iterations;
    public final double[][] _tmat;
    public final double _var_residual;
    public final double _log_likelihood;
    public final double _mse_fixed;

    public ModelMetricsRegressionHGLM(Model model, Frame frame, long nobs, double sigma, double loglikelihood, CustomMetric customMetric, int iter2, double[] beta, double[][] ubeta, double[][] tmat, double varResidual, double mse, double mse_fixed, double mae, double rmlse, double meanResidualDeviance, double aic) {
        super(model, frame, nobs, mse, sigma, mae, rmlse, meanResidualDeviance, customMetric, loglikelihood, aic);
        this._beta = beta;
        this._ubeta = ubeta;
        this._iterations = iter2;
        this._tmat = tmat;
        this._var_residual = varResidual;
        this._icc = ModelMetricsRegressionHGLM.calICC(tmat, varResidual);
        this._log_likelihood = loglikelihood;
        this._mse_fixed = mse_fixed;
    }

    public static double calHGLMllg2(long nobs, double[][] tmat, double varResidual, double[][] zTTimesZ, double yMinsXFixSqure, double[][] yMinusXFixTimesZ) {
        double llg = (double)nobs * LOG_2PI;
        double oneOVar = 1.0 / varResidual;
        double oneOVarSq = oneOVar * oneOVar;
        double[][] gMat = ArrayUtils.expandMat(tmat, yMinusXFixTimesZ.length);
        double[][] tInvPlusZTT = ModelMetricsRegressionHGLM.calInnverV(gMat, zTTimesZ, oneOVar);
        llg += Math.log(varResidual * new Matrix(tInvPlusZTT).det() * new Matrix(gMat).det());
        double[] yMinusXFixTimesZVec = ArrayUtils.flattenArray(yMinusXFixTimesZ);
        Matrix yMinusXFixTimesZMat = new Matrix((double[][])new double[][]{yMinusXFixTimesZVec}).transpose();
        return -0.5 * (llg += oneOVar * yMinsXFixSqure - yMinusXFixTimesZMat.transpose().times(new Matrix(tInvPlusZTT).inverse()).times(yMinusXFixTimesZMat).times(oneOVarSq).getArray()[0][0]);
    }

    public static double[][] calInnverV(double[][] gmat, double[][] zTTimesZ, double oneOVar) {
        try {
            double[][] gmatInv = new Matrix(gmat).inverse().getArray();
            double[][] tempzTTimesZ = ArrayUtils.copy2DArray(zTTimesZ);
            ArrayUtils.mult(tempzTTimesZ, oneOVar);
            ArrayUtils.add(gmatInv, tempzTTimesZ);
            return gmatInv;
        }
        catch (Exception ex) {
            throw new RuntimeException("Tmat matrix is singular.");
        }
    }

    public static ModelMetricsRegressionHGLM getFromDKV(Model model, Frame frame) {
        ModelMetrics mm = ModelMetrics.getFromDKV(model, frame);
        if (!(mm instanceof ModelMetricsRegressionHGLM)) {
            throw new H2OIllegalArgumentException("Expected to find a HGLM ModelMetrics for model: " + model._key.toString() + " and frame: " + frame._key.toString(), "Expected to find a ModelMetricsHGLM for model: " + model._key.toString() + " and frame: " + frame._key.toString() + " but found a: " + (mm == null ? null : mm.getClass()));
        }
        return (ModelMetricsRegressionHGLM)mm;
    }

    public static double[] calICC(double[][] tmat, double varResidual) {
        int numLevel2 = tmat.length;
        double[] icc = new double[numLevel2];
        double denom = varResidual;
        double oOverDenom = 1.0 / (denom += new Matrix(tmat).trace());
        for (int index = 0; index < numLevel2; ++index) {
            icc[index] = tmat[index][index] * oOverDenom;
        }
        return icc;
    }

    public double llg() {
        return this._log_likelihood;
    }

    @Override
    public String toString() {
        int index;
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" mean square error with fixed predictor coefficients: " + this._mse_fixed);
        int numLevel2 = this._ubeta.length;
        for (index = 0; index < numLevel2; ++index) {
            sb.append(" standard error of random effects for level 2 index " + index + ": " + this._tmat[index][index]);
        }
        sb.append(" standard error of residual error: " + this._var_residual);
        sb.append(" ICC: " + Arrays.toString(this._icc));
        sb.append(" loglikelihood: " + this._log_likelihood);
        sb.append(" iterations taken to build model: " + this._iterations);
        sb.append(" coefficients for fixed effect: " + Arrays.toString(this._beta));
        for (index = 0; index < numLevel2; ++index) {
            sb.append(" coefficients for random effect for level 2 index: " + index + ": " + Arrays.toString(this._ubeta[index]));
        }
        return sb.toString();
    }
}

